/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.custom.goal;

import net.emilsg.clutterbestiary.entity.custom.MantaRayEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.JumpGoal;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;

public class MantaRayJumpGoal
extends JumpGoal {
    private static final int[] OFFSET_MULTIPLIERS = new int[]{0, 1, 4, 5, 6, 7};
    private final MantaRayEntity mantaRay;
    private final int chance;
    private boolean inWater;

    public MantaRayJumpGoal(MantaRayEntity mantaRay, int chance) {
        this.mantaRay = mantaRay;
        this.chance = MantaRayJumpGoal.reducedTickDelay((int)chance);
    }

    public boolean canUse() {
        if (this.mantaRay.getRandom().nextInt(this.chance) != 0) {
            return false;
        }
        Direction direction = this.mantaRay.getMotionDirection();
        int i = direction.getStepX();
        int j = direction.getStepZ();
        BlockPos blockPos = this.mantaRay.blockPosition();
        for (int k : OFFSET_MULTIPLIERS) {
            if (this.isWater(blockPos, i, j, k) && this.isAirAbove(blockPos, i, j, k)) continue;
            return false;
        }
        return true;
    }

    public boolean isInterruptable() {
        return false;
    }

    public boolean canContinueToUse() {
        double d = this.mantaRay.getDeltaMovement().y;
        return !(d * d < (double)0.03f && this.mantaRay.getXRot() != 0.0f && Math.abs(this.mantaRay.getXRot()) < 10.0f && this.mantaRay.isInWater() || this.mantaRay.onGround());
    }

    public void start() {
        Direction direction = this.mantaRay.getMotionDirection();
        this.mantaRay.setDeltaMovement(this.mantaRay.getDeltaMovement().add((double)direction.getStepX() * 0.6, 0.7, (double)direction.getStepZ() * 0.6));
        this.mantaRay.getNavigation().stop();
    }

    public void stop() {
        this.mantaRay.setXRot(0.0f);
    }

    public void tick() {
        boolean bl = this.inWater;
        if (!bl) {
            FluidState fluidState = this.mantaRay.level().getFluidState(this.mantaRay.blockPosition());
            this.inWater = fluidState.is(FluidTags.WATER);
        }
        if (this.inWater && !bl) {
            this.mantaRay.playSound(SoundEvents.DOLPHIN_JUMP, 1.0f, 1.0f);
        }
        Vec3 vec3d = this.mantaRay.getDeltaMovement();
        if (vec3d.y * vec3d.y < (double)0.03f && this.mantaRay.getXRot() != 0.0f) {
            this.mantaRay.setXRot(Mth.rotLerp((float)0.2f, (float)this.mantaRay.getXRot(), (float)0.0f));
        } else if (vec3d.length() > (double)1.0E-5f) {
            double d = vec3d.horizontalDistance();
            double e = Math.atan2(-vec3d.y, d) * 57.2957763671875;
            this.mantaRay.setXRot((float)e);
        }
    }

    private boolean isAirAbove(BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        return this.mantaRay.level().getBlockState(pos.offset(offsetX * multiplier, 1, offsetZ * multiplier)).isAir() && this.mantaRay.level().getBlockState(pos.offset(offsetX * multiplier, 2, offsetZ * multiplier)).isAir();
    }

    private boolean isWater(BlockPos pos, int offsetX, int offsetZ, int multiplier) {
        BlockPos blockPos = pos.offset(offsetX * multiplier, 0, offsetZ * multiplier);
        return this.mantaRay.level().getFluidState(blockPos).is(FluidTags.WATER) && !this.mantaRay.level().getBlockState(blockPos).blocksMotion();
    }
}

