/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.resources.ResourceLocation;

public enum ButterflyVariant {
    WHITE("white", ChatFormatting.WHITE, 0),
    LIGHT_GRAY("light_gray", ChatFormatting.GRAY, 1),
    GRAY("gray", ChatFormatting.DARK_GRAY, 2),
    BLACK("black", ChatFormatting.BLACK, 3),
    BROWN("brown", ChatFormatting.GOLD, 4),
    RED("red", ChatFormatting.DARK_RED, 5),
    ORANGE("orange", ChatFormatting.GOLD, 6),
    YELLOW("yellow", ChatFormatting.YELLOW, 7),
    LIME("lime", ChatFormatting.GREEN, 8),
    GREEN("green", ChatFormatting.DARK_GREEN, 9),
    LIGHT_BLUE("light_blue", ChatFormatting.BLUE, 10),
    CYAN("cyan", ChatFormatting.DARK_AQUA, 11),
    BLUE("blue", ChatFormatting.DARK_BLUE, 12),
    PURPLE("purple", ChatFormatting.DARK_PURPLE, 13),
    MAGENTA("magenta", ChatFormatting.LIGHT_PURPLE, 14),
    PINK("pink", ChatFormatting.RED, 15),
    WARPED("warped", ChatFormatting.DARK_AQUA, 16, true),
    CRIMSON("crimson", ChatFormatting.DARK_RED, 17, true),
    SOUL("soul", ChatFormatting.GOLD, 18, true);

    private final String name;
    private final ChatFormatting colorFormatting;
    private final boolean isFireImmune;
    private static final Map<ResourceLocation, ButterflyVariant> BY_ID;
    public static final Codec<ButterflyVariant> CODEC;
    private final int ID;

    private ButterflyVariant(String name, ChatFormatting colorFormatting, int ID, boolean isFireImmune) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = isFireImmune;
        this.ID = ID;
    }

    private ButterflyVariant(String name, ChatFormatting colorFormatting, int ID) {
        this.name = name;
        this.colorFormatting = colorFormatting;
        this.isFireImmune = false;
        this.ID = ID;
    }

    public static ButterflyVariant fromId(String id) {
        return Arrays.stream(ButterflyVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(WHITE);
    }

    public static ButterflyVariant getRandom(boolean overworldOnly) {
        List<ButterflyVariant> filtered = Arrays.stream(ButterflyVariant.values()).filter(v -> !overworldOnly || !v.isFireImmune()).toList();
        return filtered.get(new Random().nextInt(filtered.size()));
    }

    public ChatFormatting getColorFormatting() {
        return this.colorFormatting;
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/butterfly/" + this.getName() + "_butterfly.png"));
    }

    public boolean isFireImmune() {
        return this.isFireImmune;
    }

    public int getOrderedID() {
        return this.ID;
    }

    static {
        BY_ID = Arrays.stream(ButterflyVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            ButterflyVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)((Object)v)) : DataResult.error(() -> "Unknown butterfly variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

