/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.entity.variants;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;

public enum SeahorseVariant {
    YELLOW("yellow"),
    LIGHT_BLUE("light_blue"),
    RED("red"),
    PURPLE("purple");

    private final String name;
    private static final Map<ResourceLocation, SeahorseVariant> BY_ID;
    public static final Codec<SeahorseVariant> CODEC;

    private SeahorseVariant(String name) {
        this.name = name;
    }

    public static SeahorseVariant fromId(String id) {
        return Arrays.stream(SeahorseVariant.values()).filter(v -> v.getId().equals(id)).findFirst().orElse(YELLOW);
    }

    public static SeahorseVariant getRandom() {
        List<SeahorseVariant> variants = Arrays.stream(SeahorseVariant.values()).toList();
        return variants.get(new Random().nextInt(variants.size()));
    }

    public String getId() {
        return "clutterbestiary:" + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public ResourceLocation getTextureLocation() {
        return ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)("textures/entity/seahorse/" + this.getName() + "_seahorse.png"));
    }

    static {
        BY_ID = Arrays.stream(SeahorseVariant.values()).collect(Collectors.toMap(v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()), v -> v));
        CODEC = ResourceLocation.CODEC.comapFlatMap(id -> {
            SeahorseVariant v = BY_ID.get(id);
            return v != null ? DataResult.success((Object)((Object)v)) : DataResult.error(() -> "Unknown seahorse variant: " + String.valueOf(id));
        }, v -> ResourceLocation.fromNamespaceAndPath((String)"clutterbestiary", (String)v.getName()));
    }
}

