/*
 * Decompiled with CFR 0.152.
 */
package net.emilsg.clutterbestiary.item.custom;

import java.util.Objects;
import net.emilsg.clutterbestiary.entity.ModEntityTypes;
import net.emilsg.clutterbestiary.entity.custom.EchofinEntity;
import net.emilsg.clutterbestiary.entity.variants.EchofinVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;

public class EchofinBucketItem
extends Item {
    private final EchofinVariant variant;

    public EchofinBucketItem(Item.Properties settings, EchofinVariant variant) {
        super(settings);
        this.variant = variant;
    }

    public InteractionResult useOn(UseOnContext context) {
        Level world = context.getLevel();
        if (!(world instanceof ServerLevel)) {
            return InteractionResult.SUCCESS;
        }
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockState blockState = world.getBlockState(blockPos);
        BlockPos blockPos2 = blockState.getCollisionShape((BlockGetter)world, blockPos).isEmpty() ? blockPos : blockPos.relative(direction);
        EchofinEntity echofinEntity = (EchofinEntity)((EntityType)ModEntityTypes.ECHOFIN.get()).create(world);
        assert (echofinEntity != null);
        echofinEntity.setVariant(this.variant);
        echofinEntity.setPersistenceRequired();
        echofinEntity.absMoveTo((double)blockPos2.getX() + 0.5, blockPos2.getY(), (double)blockPos2.getZ() + 0.5);
        echofinEntity.setHomePos(blockPos2);
        world.playSound(null, blockPos2, SoundEvents.BUCKET_EMPTY_FISH, SoundSource.NEUTRAL, 1.0f, 1.0f);
        world.addFreshEntity((Entity)echofinEntity);
        if (Objects.requireNonNull(context.getPlayer()).isAlwaysTicking() && !context.getPlayer().getAbilities().instabuild) {
            context.getPlayer().setItemInHand(context.getHand(), new ItemStack((ItemLike)Items.BUCKET));
        }
        world.gameEvent((Entity)context.getPlayer(), (Holder)GameEvent.ENTITY_PLACE, blockPos);
        return InteractionResult.CONSUME;
    }
}

