/*
 * Decompiled with CFR 0.152.
 */
package net.mtheninja615.codex_of_champions.item.curios;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import io.redspace.ironsspellbooks.api.registry.AttributeRegistry;
import io.redspace.ironsspellbooks.entity.spells.root.RootEntity;
import net.acetheeldritchking.aces_spell_utils.items.curios.SheathCurioItem;
import net.acetheeldritchking.aces_spell_utils.utils.ASRarities;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.mtheninja615.codex_of_champions.Registries.ItemRegistries;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.living.LivingDamageEvent;
import top.theillusivec4.curios.api.SlotContext;

@EventBusSubscriber
public class VitalicSheathCurio
extends SheathCurioItem {
    public static final int COOLDOWN = 500;

    public VitalicSheathCurio() {
        super(new Item.Properties().stacksTo(1).rarity((Rarity)ASRarities.VERDANT_RARITY_PROXY.getValue()).fireResistant(), null);
    }

    protected int getCooldownTicks() {
        return 500;
    }

    @SubscribeEvent
    public static void handleAbility(LivingDamageEvent.Pre event) {
        ServerPlayer player;
        VitalicSheathCurio sheath = (VitalicSheathCurio)ItemRegistries.VITALICSHEATHCURIO.get();
        Entity attacker = event.getSource().getEntity();
        if (attacker instanceof ServerPlayer && sheath.isEquippedBy((LivingEntity)(player = (ServerPlayer)attacker)) && sheath.tryProcCooldown((Player)player)) {
            LivingEntity victim = event.getEntity();
            RootEntity rootEntity = new RootEntity(player.level(), (LivingEntity)player);
            rootEntity.setDuration(125);
            rootEntity.moveTo(victim.position());
            player.level().addFreshEntity((Entity)rootEntity);
            victim.startRiding((Entity)rootEntity, true);
        }
    }

    public Multimap<Holder<Attribute>, AttributeModifier> getAttributeModifiers(SlotContext slotContext, ResourceLocation id, ItemStack stack) {
        LinkedHashMultimap attr = LinkedHashMultimap.create();
        attr.put((Object)AttributeRegistry.NATURE_SPELL_POWER, (Object)new AttributeModifier(id, 0.1, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)AttributeRegistry.CAST_TIME_REDUCTION, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        attr.put((Object)Attributes.ATTACK_DAMAGE, (Object)new AttributeModifier(id, 0.05, AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
        return attr;
    }
}

