/*
 * Decompiled with CFR 0.152.
 */
package net.mtheninja615.codex_of_champions.spells.eldritch;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.events.SpellHealEvent;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellAnimations;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.SoundRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.mtheninja615.codex_of_champions.Registries.EffectRegistry;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;

@AutoSpellConfig
public class PersonaBondSpell
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"codex_of_champions", (String)"persona_bond");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.LEGENDARY).setSchoolResource(SchoolRegistry.ELDRITCH_RESOURCE).setMaxLevel(1).setCooldownSeconds(200.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.effect_length", (Object[])new Object[]{Utils.timeFromTicks((float)(this.getSpellPower(spellLevel, (Entity)caster) * 40.0f), (int)1)}));
    }

    public PersonaBondSpell() {
        this.manaCostPerLevel = 15;
        this.baseSpellPower = 5;
        this.spellPowerPerLevel = 1;
        this.castTime = 0;
        this.baseManaCost = 120;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public AnimationHolder getCastStartAnimation() {
        return SpellAnimations.SELF_CAST_TWO_HANDS;
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of((SoundEvent)SoundRegistry.SUMMONED_SWORDS_CAST.get());
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        float healing = this.getHealAmount(entity, spellLevel);
        NeoForge.EVENT_BUS.post((Event)new SpellHealEvent(entity, entity, healing, this.getSchoolType()));
        entity.heal(healing);
        entity.addEffect(new MobEffectInstance(EffectRegistry.PersonaBond, this.getEffectDuration(entity, spellLevel), 0, false, false, true));
        int count = 8;
        float radius = 0.25f;
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    private float getHealAmount(LivingEntity caster, int spellLevel) {
        return this.getSpellPower(spellLevel, (Entity)caster) / 3.5f;
    }

    public boolean canBeCraftedBy(Player player) {
        return false;
    }

    public boolean allowLooting() {
        return false;
    }

    public boolean allowCrafting() {
        return false;
    }

    public boolean requiresLearning() {
        return false;
    }

    private int getEffectDuration(LivingEntity caster, int spellLevel) {
        return (int)(20.0f * this.getSpellPower(spellLevel, (Entity)caster));
    }
}

