/*
 * Decompiled with CFR 0.152.
 */
package net.mtheninja615.codex_of_champions.spells.ender;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.comet.Comet;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

@AutoSpellConfig
public class MissileSalvo
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"codex_of_champions", (String)"missile_salvo");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.UNCOMMON).setSchoolResource(SchoolRegistry.ENDER_RESOURCE).setMaxLevel(5).setCooldownSeconds(40.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}));
    }

    public MissileSalvo() {
        this.manaCostPerLevel = 1;
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 5;
        this.castTime = 55;
        this.baseManaCost = 5;
    }

    public CastType getCastType() {
        return CastType.CONTINUOUS;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Comet bolt = new Comet(world, entity);
        bolt.setPos(entity.position().add(0.75, (double)entity.getEyeHeight() - bolt.getBoundingBox().getYsize() * 0.5, 0.0));
        bolt.shoot(entity.getLookAngle());
        bolt.setDamage(this.getDamage(spellLevel, entity));
        bolt.setExplosionRadius(2.0f);
        world.addFreshEntity((Entity)bolt);
        Comet bolt1 = new Comet(world, entity);
        bolt1.setPos(entity.position().add(-0.75, (double)entity.getEyeHeight() - bolt1.getBoundingBox().getYsize() * 0.5, 0.0));
        bolt1.shoot(entity.getLookAngle());
        bolt1.setDamage(this.getDamage(spellLevel, entity));
        world.addFreshEntity((Entity)bolt1);
        Comet bolt2 = new Comet(world, entity);
        bolt2.setPos(entity.position().add(0.0, (double)entity.getEyeHeight() - bolt2.getBoundingBox().getYsize() * -0.5, 0.0));
        bolt2.shoot(entity.getLookAngle());
        bolt2.setDamage(this.getDamage(spellLevel, entity));
        world.addFreshEntity((Entity)bolt2);
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private int getCount(int spellLevel) {
        return spellLevel;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.25f;
    }
}

