/*
 * Decompiled with CFR 0.152.
 */
package net.mtheninja615.codex_of_champions.spells.fire;

import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.entity.spells.firebolt.FireboltProjectile;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

@AutoSpellConfig
public class FireCluster
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"codex_of_champions", (String)"fire_cluster");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.FIRE_RESOURCE).setMaxLevel(5).setCooldownSeconds(45.0).build();

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.damage", (Object[])new Object[]{Utils.stringTruncation((double)this.getDamage(spellLevel, caster), (int)2)}), Component.translatable((String)"ui.irons_spellbooks.projectile_count", (Object[])new Object[]{this.getCount(spellLevel)}));
    }

    public FireCluster() {
        this.manaCostPerLevel = 20;
        this.baseSpellPower = 8;
        this.spellPowerPerLevel = 4;
        this.castTime = 0;
        this.baseManaCost = 45;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public void onCast(Level world, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        int count = this.getCount(spellLevel);
        float damage = this.getDamage(spellLevel, entity);
        int degreesPerBolt = 360 / count;
        HitResult raycast = Utils.raycastForEntity((Level)world, (Entity)entity, (float)32.0f, (boolean)true);
        for (int i = 0; i < count; ++i) {
            FireboltProjectile bolt = new FireboltProjectile(world, entity);
            int rotation = degreesPerBolt * i - degreesPerBolt;
            bolt.setDamage(damage);
            Vec3 spawn = entity.getEyePosition().add(new Vec3(0.0, 1.5, 0.0).zRot((float)rotation * ((float)Math.PI / 180)).xRot(-entity.getXRot() * ((float)Math.PI / 180)).yRot(-entity.getYRot() * ((float)Math.PI / 180)));
            bolt.moveTo(spawn);
            bolt.shoot(raycast.getLocation().subtract(spawn).normalize());
            world.addFreshEntity((Entity)bolt);
        }
        super.onCast(world, spellLevel, entity, castSource, playerMagicData);
    }

    private int getCount(int spellLevel) {
        return spellLevel;
    }

    private float getDamage(int spellLevel, LivingEntity caster) {
        return this.getSpellPower(spellLevel, (Entity)caster) * 0.25f;
    }
}

