/*
 * Decompiled with CFR 0.152.
 */
package net.mtheninja615.codex_of_champions.spells.nature;

import dev.shadowsoffire.apothic_attributes.api.ALObjects;
import io.redspace.ironsspellbooks.api.config.DefaultConfig;
import io.redspace.ironsspellbooks.api.magic.MagicData;
import io.redspace.ironsspellbooks.api.registry.SchoolRegistry;
import io.redspace.ironsspellbooks.api.spells.AbstractSpell;
import io.redspace.ironsspellbooks.api.spells.AutoSpellConfig;
import io.redspace.ironsspellbooks.api.spells.CastSource;
import io.redspace.ironsspellbooks.api.spells.CastType;
import io.redspace.ironsspellbooks.api.spells.ICastData;
import io.redspace.ironsspellbooks.api.spells.SpellRarity;
import io.redspace.ironsspellbooks.api.util.AnimationHolder;
import io.redspace.ironsspellbooks.api.util.Utils;
import io.redspace.ironsspellbooks.registries.MobEffectRegistry;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.mtheninja615.codex_of_champions.network.particles.PetalStepParticlesPacket;
import net.neoforged.neoforge.network.PacketDistributor;

@AutoSpellConfig
public class PetalStep
extends AbstractSpell {
    private final ResourceLocation spellId = ResourceLocation.fromNamespaceAndPath((String)"codex_of_champions", (String)"petal_step");
    private final DefaultConfig defaultConfig = new DefaultConfig().setMinRarity(SpellRarity.EPIC).setSchoolResource(SchoolRegistry.NATURE_RESOURCE).setMaxLevel(5).setCooldownSeconds(3.0).build();

    public PetalStep() {
        this.baseSpellPower = 10;
        this.spellPowerPerLevel = 10;
        this.baseManaCost = 20;
        this.manaCostPerLevel = 2;
        this.castTime = 0;
    }

    public DefaultConfig getDefaultConfig() {
        return this.defaultConfig;
    }

    public CastType getCastType() {
        return CastType.INSTANT;
    }

    public ResourceLocation getSpellResource() {
        return this.spellId;
    }

    public Optional<SoundEvent> getCastStartSound() {
        return Optional.empty();
    }

    public Optional<SoundEvent> getCastFinishSound() {
        return Optional.of(SoundEvents.CHERRY_LEAVES_FALL);
    }

    public void onCast(Level level, int spellLevel, LivingEntity entity, CastSource castSource, MagicData playerMagicData) {
        Vec3 potentialTarget;
        TeleportData teleportData = (TeleportData)playerMagicData.getAdditionalCastData();
        Vec3 dest = null;
        if (teleportData != null && (potentialTarget = teleportData.getTeleportTargetPosition()) != null) {
            dest = potentialTarget;
        }
        if (dest == null) {
            dest = PetalStep.findTeleportLocation(level, entity, this.getDistance(spellLevel, entity));
        }
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)entity, (CustomPacketPayload)new PetalStepParticlesPacket(entity.position(), dest), (CustomPacketPayload[])new CustomPacketPayload[0]);
        if (entity.isPassenger()) {
            entity.stopRiding();
        }
        Utils.handleSpellTeleport((AbstractSpell)this, (Entity)entity, (Vec3)dest);
        entity.resetFallDistance();
        playerMagicData.resetAdditionalCastData();
        entity.playSound(this.getCastFinishSound().get(), 2.0f, 1.0f);
        entity.addEffect(new MobEffectInstance(ALObjects.MobEffects.MOVEMENT_SPEED, 150, 1, false, false, true));
        entity.addEffect(new MobEffectInstance((Holder)MobEffectRegistry.TRUE_INVISIBILITY, 75, 0, false, false, true));
        super.onCast(level, spellLevel, entity, castSource, playerMagicData);
    }

    public static Vec3 findTeleportLocation(Level level, LivingEntity entity, float maxDistance) {
        BlockHitResult blockHitResult = Utils.getTargetBlock((Level)level, (LivingEntity)entity, (ClipContext.Fluid)ClipContext.Fluid.NONE, (double)maxDistance);
        return PetalStep.solveTeleportDestination(level, entity, blockHitResult.getBlockPos(), blockHitResult.getLocation());
    }

    public static Vec3 solveTeleportDestination(Level level, LivingEntity entity, BlockPos blockPos, Vec3 vec3) {
        boolean los;
        BlockPos pos = blockPos;
        Vec3 bbOffset = entity.getForward().normalize().multiply((double)(entity.getBbWidth() / 3.0f), 0.0, (double)(entity.getBbHeight() / 3.0f));
        Vec3 bbImpact = vec3.subtract(bbOffset);
        double ledgeY = level.clip((ClipContext)new ClipContext((Vec3)Vec3.atBottomCenterOf((Vec3i)pos).add((double)0.0, (double)3.0, (double)0.0), (Vec3)Vec3.atBottomCenterOf((Vec3i)pos), (ClipContext.Block)ClipContext.Block.COLLIDER, (ClipContext.Fluid)ClipContext.Fluid.NONE, (CollisionContext)CollisionContext.empty())).getLocation().y;
        boolean isAir = level.getBlockState(new BlockPos(new Vec3i(pos.getX(), (int)ledgeY, pos.getZ())).above()).isAir();
        boolean bl = los = level.clip(new ClipContext(bbImpact, bbImpact.add(0.0, ledgeY - (double)pos.getY(), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).getType() == HitResult.Type.MISS;
        if (isAir && los && Math.abs(ledgeY - (double)pos.getY()) <= 3.0) {
            return new Vec3((double)pos.getX() + 0.5, ledgeY + 0.001, (double)pos.getZ() + 0.5);
        }
        return level.clip(new ClipContext(bbImpact, bbImpact.add(0.0, (double)(-entity.getBbHeight()), 0.0), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)entity)).getLocation().add(0.0, 0.001, 0.0);
    }

    public static void particleCloud(Level level, Vec3 pos) {
        if (level.isClientSide) {
            double width = 0.5;
            float height = 1.0f;
            for (int i = 0; i < 55; ++i) {
                double x = pos.x + Utils.random.nextDouble() * width * 2.0 - width;
                double y = pos.y + (double)height + Utils.random.nextDouble() * (double)height * 1.2 * 2.0 - (double)height * 1.2;
                double z = pos.z + Utils.random.nextDouble() * width * 2.0 - width;
                double dx = Utils.random.nextDouble() * 0.1 * (double)(Utils.random.nextBoolean() ? 1 : -1);
                double dy = Utils.random.nextDouble() * 0.1 * (double)(Utils.random.nextBoolean() ? 1 : -1);
                double dz = Utils.random.nextDouble() * 0.1 * (double)(Utils.random.nextBoolean() ? 1 : -1);
                level.addParticle((ParticleOptions)ParticleTypes.CHERRY_LEAVES, true, x, y, z, dx, dy, dz);
            }
        }
    }

    private float getDistance(int spellLevel, LivingEntity sourceEntity) {
        return (float)(Utils.softCapFormula((double)this.getEntityPowerMultiplier(sourceEntity)) * (double)this.getSpellPower(spellLevel, null));
    }

    public List<MutableComponent> getUniqueInfo(int spellLevel, LivingEntity caster) {
        return List.of(Component.translatable((String)"ui.irons_spellbooks.distance", (Object[])new Object[]{Utils.stringTruncation((double)this.getDistance(spellLevel, caster), (int)1)}));
    }

    public AnimationHolder getCastStartAnimation() {
        return AnimationHolder.none();
    }

    public static class TeleportData
    implements ICastData {
        private Vec3 teleportTargetPosition;

        public TeleportData(Vec3 teleportTargetPosition) {
            this.teleportTargetPosition = teleportTargetPosition;
        }

        public void setTeleportTargetPosition(Vec3 targetPosition) {
            this.teleportTargetPosition = targetPosition;
        }

        public Vec3 getTeleportTargetPosition() {
            return this.teleportTargetPosition;
        }

        public void reset() {
        }
    }
}

