/*
 * Decompiled with CFR 0.152.
 */
package dev.djefrey.colorwheel.compile.transform;

import dev.djefrey.colorwheel.compile.transform.ClrwlASTTransformer;
import dev.djefrey.colorwheel.compile.transform.ClrwlTransformOutput;
import dev.djefrey.colorwheel.compile.transform.ClrwlTransformParameters;
import io.github.douira.glsl_transformer.ast.node.Identifier;
import io.github.douira.glsl_transformer.ast.node.TranslationUnit;
import io.github.douira.glsl_transformer.ast.node.Version;
import io.github.douira.glsl_transformer.ast.node.abstract_node.ASTNode;
import io.github.douira.glsl_transformer.ast.node.declaration.DeclarationMember;
import io.github.douira.glsl_transformer.ast.node.declaration.TypeAndInitDeclaration;
import io.github.douira.glsl_transformer.ast.node.expression.LiteralExpression;
import io.github.douira.glsl_transformer.ast.node.expression.ReferenceExpression;
import io.github.douira.glsl_transformer.ast.node.expression.binary.ArrayAccessExpression;
import io.github.douira.glsl_transformer.ast.node.external_declaration.DeclarationExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.external_declaration.ExternalDeclaration;
import io.github.douira.glsl_transformer.ast.node.type.specifier.BuiltinNumericTypeSpecifier;
import io.github.douira.glsl_transformer.ast.node.type.specifier.TypeSpecifier;
import io.github.douira.glsl_transformer.ast.print.PrintType;
import io.github.douira.glsl_transformer.ast.query.Root;
import io.github.douira.glsl_transformer.ast.query.RootSupplier;
import io.github.douira.glsl_transformer.ast.query.match.AutoHintedMatcher;
import io.github.douira.glsl_transformer.ast.query.match.HintedMatcher;
import io.github.douira.glsl_transformer.ast.transform.ASTInjectionPoint;
import io.github.douira.glsl_transformer.ast.transform.Template;
import io.github.douira.glsl_transformer.parser.ParseShape;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.irisshaders.iris.gl.texture.TextureType;
import net.irisshaders.iris.helpers.Tri;
import net.irisshaders.iris.pipeline.transform.PatchShaderType;
import net.irisshaders.iris.pipeline.transform.parameter.Parameters;
import net.irisshaders.iris.pipeline.transform.transformer.CommonTransformer;
import net.irisshaders.iris.shaderpack.properties.ProgramDirectives;
import net.irisshaders.iris.shaderpack.texture.TextureStage;
import org.apache.commons.lang3.function.TriFunction;

public class ClrwlTransformPatcher {
    private static final ClrwlASTTransformer<ClrwlTransformParameters> transformer;
    public static final Pattern versionPattern;
    public static final Pattern extensionPattern;
    private static final String LIGHTMAP_SCALE = "1.0 / 240.0";
    private static final String LIGHTMAP_OFFSET = "0.03125";
    private static final String LIGHTMAP_MATRIX;
    private static final AutoHintedMatcher<ExternalDeclaration> fragdataLayoutDeclaration;
    private static final AutoHintedMatcher<ExternalDeclaration> fragdataOutDeclaration;
    private static final Template<ExternalDeclaration> outputGlobalVarDeclaration;

    private static int getAttributeDimensionAndDelete(Root root, String name, int defaultDimension) {
        int dimension = defaultDimension;
        for (Identifier identifier : root.identifierIndex.get(name)) {
            DeclarationExternalDeclaration extDecl;
            TypeAndInitDeclaration initDecl = (TypeAndInitDeclaration)identifier.getAncestor(2, 0, TypeAndInitDeclaration.class::isInstance);
            if (initDecl == null || (extDecl = (DeclarationExternalDeclaration)initDecl.getAncestor(1, 0, DeclarationExternalDeclaration.class::isInstance)) == null) continue;
            TypeSpecifier typeSpecifier = initDecl.getType().getTypeSpecifier();
            if (typeSpecifier instanceof BuiltinNumericTypeSpecifier) {
                BuiltinNumericTypeSpecifier numType = (BuiltinNumericTypeSpecifier)typeSpecifier;
                switch (numType.type) {
                    case FLOAT32: {
                        dimension = 1;
                        break;
                    }
                    case F32VEC2: {
                        dimension = 2;
                        break;
                    }
                    case F32VEC3: {
                        dimension = 3;
                        break;
                    }
                    case F32VEC4: {
                        dimension = 4;
                    }
                }
            }
            extDecl.detachAndDelete();
            initDecl.detachAndDelete();
            identifier.detachAndDelete();
            break;
        }
        return dimension;
    }

    private static void replaceVec2WithVariableDimension(Root root, String name, String vec2) {
        int dimension = ClrwlTransformPatcher.getAttributeDimensionAndDelete(root, name, 2);
        if (dimension == 1) {
            root.replaceReferenceExpressions(transformer, name, vec2 + ".x");
        } else if (dimension == 2) {
            root.replaceReferenceExpressions(transformer, name, vec2);
        } else if (dimension == 3) {
            root.replaceReferenceExpressions(transformer, name, "vec3(" + vec2 + ", 0.0)");
        } else {
            root.replaceReferenceExpressions(transformer, name, "vec4(" + vec2 + ", 0.0, 1.0)");
        }
    }

    private static void replaceVec4WithVariableDimension(Root root, String name, String vec4) {
        int dimension = ClrwlTransformPatcher.getAttributeDimensionAndDelete(root, name, 4);
        if (dimension == 1) {
            root.replaceReferenceExpressions(transformer, name, vec4 + ".x");
        } else if (dimension == 2) {
            root.replaceReferenceExpressions(transformer, name, vec4 + ".xy");
        } else if (dimension == 3) {
            root.replaceReferenceExpressions(transformer, name, vec4 + ".xyz");
        } else {
            root.replaceReferenceExpressions(transformer, name, vec4);
        }
    }

    private static void replaceFilledVec2WithVariableDimension(Root root, String name, String value) {
        int dimension = ClrwlTransformPatcher.getAttributeDimensionAndDelete(root, name, 2);
        if (dimension == 1) {
            root.replaceReferenceExpressions(transformer, name, "(" + value + ")");
        } else if (dimension == 2) {
            root.replaceReferenceExpressions(transformer, name, "vec2(" + value + ")");
        } else if (dimension == 3) {
            root.replaceReferenceExpressions(transformer, name, "vec3(vec2(" + value + "), 0.0)");
        } else {
            root.replaceReferenceExpressions(transformer, name, "vec4(vec2(" + value + "), 0.0, 1.0)");
        }
    }

    public static String patchVertex(String vertex, boolean isCrumbling, ProgramDirectives programDirectives, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        ClrwlTransformParameters.Directives directives = ClrwlTransformParameters.Directives.fromVertex(programDirectives);
        ClrwlTransformParameters parameters = new ClrwlTransformParameters(PatchShaderType.VERTEX, isCrumbling, false, directives, textureMap);
        return transformer.transform(vertex, parameters).code();
    }

    public static String patchGeometry(String vertex, boolean isCrumbling, ProgramDirectives programDirectives, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        ClrwlTransformParameters.Directives directives = ClrwlTransformParameters.Directives.fromVertex(programDirectives);
        ClrwlTransformParameters parameters = new ClrwlTransformParameters(PatchShaderType.GEOMETRY, isCrumbling, false, directives, textureMap);
        return transformer.transform(vertex, parameters).code();
    }

    public static ClrwlTransformOutput patchFragment(String fragment, boolean isCrumbling, boolean customOutputs, ProgramDirectives programDirectives, Object2ObjectMap<Tri<String, TextureType, TextureStage>, String> textureMap) {
        ClrwlTransformParameters.Directives directives = ClrwlTransformParameters.Directives.fromFragment(programDirectives);
        ClrwlTransformParameters parameters = new ClrwlTransformParameters(PatchShaderType.FRAGMENT, isCrumbling, customOutputs, directives, textureMap);
        return transformer.transform(fragment, parameters);
    }

    static {
        versionPattern = Pattern.compile("^.*#version\\h+(\\d+)\\V*", 32);
        extensionPattern = Pattern.compile("^.*#extension\\s+([a-zA-Z0-9_]+)\\s+:\\s+([a-zA-Z0-9_]+)", 32);
        LIGHTMAP_MATRIX = String.format("mat4(%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s,%s)", LIGHTMAP_SCALE, "0.0", "0.0", "0.0", "0.0", LIGHTMAP_SCALE, "0.0", "0.0", "0.0", "0.0", "1.0", "0.0", LIGHTMAP_OFFSET, LIGHTMAP_OFFSET, "0.0", "1.0");
        fragdataLayoutDeclaration = new AutoHintedMatcher<ExternalDeclaration>("layout (location = __index) out vec4 __name;", ParseShape.EXTERNAL_DECLARATION){
            {
                this.markClassedPredicateWildcard("__index", ((Identifier)((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getUnique("__index")).getAncestor(ReferenceExpression.class), LiteralExpression.class, literalExpression -> literalExpression.isInteger() && literalExpression.getInteger() >= 0L);
                this.markClassWildcard("__name", ((Identifier)((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getUnique("__name")).getAncestor(DeclarationMember.class));
            }
        };
        fragdataOutDeclaration = new AutoHintedMatcher<ExternalDeclaration>("out vec4 __name;", ParseShape.EXTERNAL_DECLARATION){
            {
                this.markClassedPredicateWildcard("__name", ((Identifier)((ExternalDeclaration)this.pattern).getRoot().identifierIndex.getUnique("__name")).getAncestor(DeclarationMember.class), DeclarationMember.class, declarationMember -> declarationMember.getName().getName().matches("outColor\\d+$"));
            }
        };
        outputGlobalVarDeclaration = Template.withExternalDeclaration((String)"vec4 __name;");
        outputGlobalVarDeclaration.markIdentifierReplacement("__name");
        transformer = new ClrwlASTTransformer<ClrwlTransformParameters>(){
            {
                this.setRootSupplier(RootSupplier.PREFIX_UNORDERED_ED_EXACT);
            }

            public TranslationUnit parseTranslationUnit(Root rootInstance, String input) {
                Matcher versionMatcher = versionPattern.matcher(input);
                if (!versionMatcher.find()) {
                    throw new IllegalArgumentException("No #version directive found in source code! See debugging.md for more information.");
                }
                ClrwlTransformPatcher.transformer.getLexer().version = Version.fromNumber((int)Integer.parseInt(versionMatcher.group(1)));
                input = versionMatcher.replaceAll("");
                Matcher extensionMatcher = extensionPattern.matcher(input);
                input = extensionMatcher.replaceAll("");
                return super.parseTranslationUnit(rootInstance, input);
            }
        };
        transformer.setPrintType(PrintType.INDENTED);
        transformer.setTransformation((TriFunction<TranslationUnit, Root, ClrwlTransformParameters, Map<Integer, String>>)((TriFunction)(tree, root, parameters) -> {
            tree.outputOptions.enablePrintInfo();
            HashMap outputs = new HashMap();
            root.indexBuildSession(() -> {
                root.replaceReferenceExpressions(transformer, "gl_Vertex", "flw_vertexPos");
                root.replaceReferenceExpressions(transformer, "gl_Normal", "flw_vertexNormal");
                root.replaceReferenceExpressions(transformer, "gl_Color", "flw_vertexColor");
                ClrwlTransformPatcher.replaceVec4WithVariableDimension(root, "at_midBlock", "clrwl_vertexMidMesh");
                ClrwlTransformPatcher.replaceVec4WithVariableDimension(root, "at_tangent", "clrwl_vertexTangent");
                ClrwlTransformPatcher.replaceVec2WithVariableDimension(root, "mc_midTexCoord", "clrwl_vertexMidTexCoord");
                ClrwlTransformPatcher.replaceVec2WithVariableDimension(root, "mc_Entity", "clrwl_vertexEntity");
                root.replaceReferenceExpressions(transformer, "gl_MultiTexCoord0", "vec4(flw_vertexTexCoord, 0.0, 1.0)");
                root.replaceReferenceExpressions(transformer, "gl_MultiTexCoord1", "vec4(flw_vertexLight * 240.0, 0.0, 1.0)");
                root.replaceReferenceExpressions(transformer, "gl_MultiTexCoord2", "vec4(flw_vertexLight * 240.0, 0.0, 1.0)");
                root.rename("renderStage", "_clrwl_renderPhase");
                root.rename("blendFunc", "_clrwl_blendFunc");
                root.rename("atlasSize", "_clrwl_atlasSize");
                root.rename("blockEntityId", "_clrwl_blockEntityId");
                root.rename("entityId", "_clrwl_entityId");
                root.replaceReferenceExpressions(transformer, "entityColor", "clrwl_overlayColor");
                root.replaceReferenceExpressions(transformer, "gl_ModelViewMatrix", "flw_view");
                root.replaceReferenceExpressions(transformer, "modelViewMatrix", "flw_view");
                root.replaceReferenceExpressions(transformer, "gl_ModelViewMatrixInverse", "flw_viewInverse");
                root.replaceReferenceExpressions(transformer, "modelViewMatrixInverse", "flw_viewInverse");
                root.replaceReferenceExpressions(transformer, "gl_ProjectionMatrix", "flw_projection");
                root.replaceReferenceExpressions(transformer, "projectionMatrix", "flw_projection");
                root.replaceReferenceExpressions(transformer, "gl_ProjectionMatrixInverse", "flw_projectionInverse");
                root.replaceReferenceExpressions(transformer, "projectionMatrixInverse", "flw_projectionInverse\t");
                root.replaceReferenceExpressions(transformer, "gl_ModelViewProjectionMatrix", "flw_viewProjection");
                root.replaceReferenceExpressions(transformer, "modelViewProjectionMatrix", "flw_viewProjection");
                root.replaceReferenceExpressions(transformer, "gl_ModelViewProjectionMatrixInverse", "flw_viewProjectionInverse");
                root.replaceReferenceExpressions(transformer, "modelViewProjectionMatrixInverse", "flw_viewProjectionInverse");
                root.replaceExpressionMatches(transformer, (HintedMatcher)CommonTransformer.glTextureMatrix0, "mat4(1.0)");
                root.replaceReferenceExpressions(transformer, "textureMatrix", "mat4(1.0)");
                root.replaceExpressionMatches(transformer, (HintedMatcher)CommonTransformer.glTextureMatrix1, LIGHTMAP_MATRIX);
                root.replaceExpressionMatches(transformer, (HintedMatcher)CommonTransformer.glTextureMatrix2, LIGHTMAP_MATRIX);
                root.replaceReferenceExpressions(transformer, "gl_NormalMatrix", "clrwl_normal");
                root.replaceReferenceExpressions(transformer, "normalMatrix", "clrwl_normal");
                root.replaceReferenceExpressions(transformer, "clrwl_view", "flw_view");
                root.replaceReferenceExpressions(transformer, "clrwl_viewInverse", "flw_viewInverse");
                root.replaceReferenceExpressions(transformer, "clrwl_viewPrev", "flw_viewPrev");
                root.replaceReferenceExpressions(transformer, "clrwl_projection", "flw_projection");
                root.replaceReferenceExpressions(transformer, "clrwl_projectionInverse", "flw_projectionInverse");
                root.replaceReferenceExpressions(transformer, "clrwl_projectionPrev", "flw_projectionPrev");
                root.replaceReferenceExpressions(transformer, "clrwl_viewProjection", "flw_viewProjection");
                root.replaceReferenceExpressions(transformer, "clrwl_viewProjectionInverse", "flw_viewProjectionInverse");
                root.replaceReferenceExpressions(transformer, "clrwl_viewProjectionPrev", "flw_viewProjectionPrev");
                root.replaceReferenceExpressions(transformer, "clrwl_renderOrigin", "flw_renderOrigin");
                root.replaceReferenceExpressions(transformer, "clrwl_cameraPos", "flw_cameraPos");
                root.rename("clrwl_vertexPos", "flw_vertexPos");
                root.rename("clrwl_vertexColor", "flw_vertexColor");
                root.rename("clrwl_vertexTexCoord", "flw_vertexTexCoord");
                root.rename("clrwl_vertexOverlay", "flw_vertexOverlay");
                root.rename("clrwl_vertexLight", "flw_vertexLight");
                root.rename("clrwl_vertexNormal", "flw_vertexNormal");
                root.rename("clrwl_distance", "flw_distance");
                root.replaceReferenceExpressions(transformer, "clrwl_materialFragment", "_clrwl_materialFragment_hook");
                root.replaceReferenceExpressions(transformer, "clrwl_shaderLight", "_clrwl_shaderLight_hook");
                if (parameters.type == PatchShaderType.FRAGMENT) {
                    if (root.identifierIndex.has("gl_FragColor")) {
                        root.replaceReferenceExpressions(transformer, "gl_FragColor", "gl_FragData[0]");
                    }
                    HashMap<ArrayAccessExpression, Integer> glFragDataAccess = new HashMap<ArrayAccessExpression, Integer>();
                    HashSet<Integer> glFragDataIndexes = new HashSet<Integer>();
                    for (Identifier identifier : root.identifierIndex.get("gl_FragData")) {
                        ArrayAccessExpression arrayAccessExpression = (ArrayAccessExpression)identifier.getAncestor(ArrayAccessExpression.class);
                        long idx = ((LiteralExpression)arrayAccessExpression.getRight()).getInteger();
                        glFragDataAccess.put(arrayAccessExpression, (int)idx);
                        glFragDataIndexes.add((int)idx);
                    }
                    if (parameters.usesCustomOutputs()) {
                        for (Map.Entry entry : glFragDataAccess.entrySet()) {
                            ((ArrayAccessExpression)entry.getKey()).replaceByAndDelete((ASTNode)new ReferenceExpression(new Identifier("clrwl_FragData" + String.valueOf(entry.getValue()))));
                            outputs.putIfAbsent((Integer)entry.getValue(), "clrwl_FragData" + String.valueOf(entry.getValue()));
                        }
                        for (Integer n : glFragDataIndexes) {
                            tree.injectNode(ASTInjectionPoint.BEFORE_FUNCTIONS, (ExternalDeclaration)outputGlobalVarDeclaration.getInstanceFor(root, (ASTNode)new Identifier("clrwl_FragData" + n)));
                        }
                    } else {
                        for (Map.Entry entry : glFragDataAccess.entrySet()) {
                            outputs.putIfAbsent((Integer)entry.getValue(), "iris_FragData" + String.valueOf(entry.getValue()));
                        }
                    }
                    HashMap<DeclarationExternalDeclaration, String> outDeclarations = new HashMap<DeclarationExternalDeclaration, String>();
                    for (DeclarationExternalDeclaration declarationExternalDeclaration : root.nodeIndex.get(DeclarationExternalDeclaration.class)) {
                        if (fragdataLayoutDeclaration.matchesExtract((ASTNode)declarationExternalDeclaration)) {
                            long index = ((LiteralExpression)fragdataLayoutDeclaration.getNodeMatch("__index", LiteralExpression.class)).getInteger();
                            String name = ((DeclarationMember)fragdataLayoutDeclaration.getNodeMatch("__name", DeclarationMember.class)).getName().getName();
                            outputs.putIfAbsent((int)index, name);
                            outDeclarations.put(declarationExternalDeclaration, name);
                            continue;
                        }
                        if (!fragdataOutDeclaration.matchesExtract((ASTNode)declarationExternalDeclaration)) continue;
                        String name = ((DeclarationMember)fragdataOutDeclaration.getNodeMatch("__name", DeclarationMember.class)).getName().getName();
                        long index = Long.parseLong(name.substring(8));
                        outputs.putIfAbsent((int)index, name);
                        outDeclarations.put(declarationExternalDeclaration, name);
                    }
                    if (parameters.usesCustomOutputs()) {
                        for (Map.Entry entry : outDeclarations.entrySet()) {
                            ((DeclarationExternalDeclaration)entry.getKey()).replaceByAndDelete(outputGlobalVarDeclaration.getInstanceFor(root, (ASTNode)new Identifier((String)entry.getValue())));
                        }
                    }
                }
                CommonTransformer.transform(transformer, (TranslationUnit)tree, (Root)root, (Parameters)parameters, (boolean)false);
                if (!parameters.isCrumbling()) {
                    root.replaceReferenceExpressions(transformer, "tex", "flw_diffuseTex");
                    root.replaceReferenceExpressions(transformer, "gtexture", "flw_diffuseTex");
                } else {
                    root.replaceReferenceExpressions(transformer, "tex", "_flw_crumblingTex");
                    root.replaceReferenceExpressions(transformer, "gtexture", "_flw_crumblingTex");
                }
                root.rename("main", "_clrwl_shader_main");
            });
            return outputs;
        }));
    }
}

