/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.model.geo;

import com.github.eterdelta.crittersandcompanions.CrittersAndCompanions;
import com.github.eterdelta.crittersandcompanions.entity.OtterEntity;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.cache.object.GeoBone;
import software.bernie.geckolib.constant.DataTickets;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.model.data.EntityModelData;

public class OtterModel
extends GeoModel<OtterEntity> {
    private static final ResourceLocation[] MODELS = new ResourceLocation[]{CrittersAndCompanions.createId("geo/entity/otter.geo.json"), CrittersAndCompanions.createId("geo/entity/baby_otter.geo.json")};
    private static final ResourceLocation[] TEXTURES = new ResourceLocation[]{CrittersAndCompanions.createId("textures/entity/otter.png"), CrittersAndCompanions.createId("textures/entity/baby_otter.png")};
    private static final ResourceLocation[] ANIMATIONS = new ResourceLocation[]{CrittersAndCompanions.createId("animations/entity/otter.animation.json"), CrittersAndCompanions.createId("animations/entity/baby_otter.animation.json")};

    public ResourceLocation getModelResource(OtterEntity object) {
        return MODELS[object.isBaby() ? 1 : 0];
    }

    public ResourceLocation getTextureResource(OtterEntity object) {
        return TEXTURES[object.isBaby() ? 1 : 0];
    }

    public ResourceLocation getAnimationResource(OtterEntity animatable) {
        return ANIMATIONS[animatable.isBaby() ? 1 : 0];
    }

    public void setCustomAnimations(OtterEntity animatable, long instanceId, AnimationState<OtterEntity> animationState) {
        GeoBone headOrMain;
        super.setCustomAnimations((GeoAnimatable)animatable, instanceId, animationState);
        GeoBone root = this.getAnimationProcessor().getBone("main");
        if (root != null && !animatable.isInWater()) {
            root.setRotX(0.0f);
            root.setRotY(0.0f);
            root.setRotZ(0.0f);
        }
        if ((headOrMain = this.getAnimationProcessor().getBone(animatable.isInWater() ? "main" : "head")) != null && !animatable.isEating() && !animatable.isFloating()) {
            float pitch;
            EntityModelData data = (EntityModelData)animationState.getData(DataTickets.ENTITY_MODEL_DATA);
            float yaw = Mth.clamp((float)data.netHeadYaw(), (float)-35.0f, (float)35.0f);
            float f = pitch = animatable.isInWater() ? Mth.clamp((float)data.headPitch(), (float)-90.0f, (float)90.0f) : 0.0f;
            if (!animatable.isInWater() && animationState.isMoving()) {
                yaw *= 0.6f;
            }
            headOrMain.setRotY(yaw * ((float)Math.PI / 180));
            headOrMain.setRotX(pitch * ((float)Math.PI / 180));
        }
    }
}

