/*
 * Decompiled with CFR 0.152.
 */
package com.github.eterdelta.crittersandcompanions.client.renderer;

import com.github.eterdelta.crittersandcompanions.extension.ISilkLeashState;
import com.github.eterdelta.crittersandcompanions.mixin.EntityAccessor;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix4f;

public class SilkLeashRenderer {
    public static void renderSilkLeash(Entity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (entity instanceof ISilkLeashState) {
                ISilkLeashState leashState = (ISilkLeashState)entity;
                Set<LivingEntity> leashedByEntities = leashState.getLeashedByEntities();
                for (LivingEntity leashedBy : leashedByEntities) {
                    SilkLeashRenderer.renderSilkLeash(livingEntity, partialTicks, poseStack, bufferSource, leashedBy);
                }
            }
        }
    }

    private static void addVertexPair(VertexConsumer vertexConsumer, Matrix4f matrix4f, float p_174310_, float p_174311_, float p_174312_, int p_174313_, int p_174315_, int p_174316_, float p_174318_, float p_174319_, float p_174320_, int p_174321_, boolean p_174322_, float gradient) {
        float f = (float)p_174321_ / 24.0f;
        int i = (int)Mth.lerp((float)f, (float)p_174313_, (float)1.0f);
        int j = (int)Mth.lerp((float)f, (float)p_174315_, (float)p_174316_);
        int k = LightTexture.pack((int)i, (int)j);
        float f1 = p_174321_ % 2 == (p_174322_ ? 1 : 0) ? 0.7f : 1.0f;
        float r = 0.75f * f1 * gradient;
        float g = 0.72f * f1 * gradient;
        float b = 0.8f * f1 * gradient;
        float f5 = p_174310_ * f;
        float f6 = p_174311_ > 0.0f ? p_174311_ * f * f : p_174311_ - p_174311_ * (1.0f - f) * (1.0f - f);
        float f7 = p_174312_ * f;
        vertexConsumer.addVertex(matrix4f, f5 - p_174319_, f6 + p_174318_, f7 + p_174320_).setColor(r, g, b, 1.0f).setLight(k);
        vertexConsumer.addVertex(matrix4f, f5 + p_174319_, f6 + 0.025f - p_174318_, f7 - p_174320_).setColor(r, g, b, 1.0f).setLight(k);
    }

    public static <E extends Entity> void renderSilkLeash(LivingEntity entity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, E leashedToEntity) {
        poseStack.pushPose();
        Vec3 vec3 = leashedToEntity.getRopeHoldPosition(partialTicks);
        double d0 = (double)(Mth.lerp((float)partialTicks, (float)entity.yBodyRotO, (float)entity.yBodyRot) * ((float)Math.PI / 180)) + 1.5707963267948966;
        Vec3 vec31 = ((EntityAccessor)entity).invokeGetLeashOffset();
        double d1 = Math.cos(d0) * vec31.z + Math.sin(d0) * vec31.x;
        double d2 = Math.sin(d0) * vec31.z - Math.cos(d0) * vec31.x;
        double d3 = Mth.lerp((double)partialTicks, (double)entity.xo, (double)entity.getX()) + d1;
        double d4 = Mth.lerp((double)partialTicks, (double)entity.yo, (double)entity.getY()) + vec31.y;
        double d5 = Mth.lerp((double)partialTicks, (double)entity.zo, (double)entity.getZ()) + d2;
        poseStack.translate(d1, vec31.y, d2);
        float f = (float)(vec3.x - d3);
        float f1 = (float)(vec3.y - d4);
        float f2 = (float)(vec3.z - d5);
        VertexConsumer vertexconsumer = bufferSource.getBuffer(RenderType.leash());
        Matrix4f matrix4f = poseStack.last().pose();
        float f4 = (float)(Mth.fastInvSqrt((double)(f * f + f2 * f2)) * (double)0.025f / 2.0);
        float f5 = f2 * f4;
        float f6 = f * f4;
        BlockPos blockpos = BlockPos.containing((Position)entity.getEyePosition(partialTicks));
        BlockPos blockpos1 = BlockPos.containing((Position)leashedToEntity.getEyePosition(partialTicks));
        int i = entity.level().getBrightness(LightLayer.BLOCK, blockpos);
        int k = entity.level().getBrightness(LightLayer.SKY, blockpos);
        int l = entity.level().getBrightness(LightLayer.SKY, blockpos1);
        for (int i1 = 0; i1 <= 24; ++i1) {
            SilkLeashRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, k, l, 0.025f, f5, f6, i1, false, 0.25f + 0.75f * ((float)i1 / 24.0f));
        }
        for (int j1 = 24; j1 >= 0; --j1) {
            SilkLeashRenderer.addVertexPair(vertexconsumer, matrix4f, f, f1, f2, i, k, l, 0.0f, f5, f6, j1, true, 0.25f + 0.75f * ((float)j1 / 24.0f));
        }
        poseStack.popPose();
    }
}

