/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.datagen;

import com.epherical.croptopia.register.Content;
import com.epherical.croptopia.register.helpers.FarmlandCrop;
import com.epherical.croptopia.register.helpers.IceCream;
import com.epherical.croptopia.register.helpers.Jam;
import com.epherical.croptopia.register.helpers.Juice;
import com.epherical.croptopia.register.helpers.Pie;
import com.epherical.croptopia.register.helpers.Smoothie;
import com.epherical.croptopia.register.helpers.Tree;
import com.epherical.croptopia.register.helpers.TreeCrop;
import com.google.common.collect.ImmutableMap;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.recipes.ShapelessRecipeBuilder;
import net.minecraft.data.recipes.SimpleCookingRecipeBuilder;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class CroptopiaRecipeProvider
extends RecipeProvider {
    public CroptopiaRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public void buildRecipes(RecipeOutput exporter) {
        this.generateSeeds(exporter);
        this.generateSaplings(exporter);
        this.generateBarkWood(exporter);
        this.generateJams(exporter);
        this.generateJuices(exporter);
        this.generateSmoothies(exporter);
        this.generateIceCream(exporter);
        this.generatePie(exporter);
        this.generateFurnace(exporter);
        this.generateUtensil(exporter);
        this.generateMiscShapeless(exporter);
        this.generateMiscShaped(exporter);
    }

    protected void generateSeeds(RecipeOutput exporter) {
        for (FarmlandCrop crop : FarmlandCrop.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(crop.getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)crop.getSeedItem()).requires(tag).unlockedBy("has_" + crop.getLowercaseName(), CroptopiaRecipeProvider.has((ItemLike)crop)).save(exporter);
        }
    }

    protected void generateSaplings(RecipeOutput exporter) {
        for (TreeCrop crop : TreeCrop.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(crop.getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)crop.getSaplingItem()).requires(tag).requires(tag).requires(ItemTags.SAPLINGS).unlockedBy("has_" + crop.getLowercaseName(), CroptopiaRecipeProvider.has((ItemLike)crop)).save(exporter);
        }
    }

    protected void generateBarkWood(RecipeOutput exporter) {
        for (Tree crop : Tree.copy()) {
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)crop.getWood()).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)crop.getLog()).unlockedBy("has_" + crop.getLowercaseName() + "_log", CroptopiaRecipeProvider.has((ItemLike)crop.getLog())).save(exporter);
            ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)crop.getStrippedWood()).pattern("##").pattern("##").define(Character.valueOf('#'), (ItemLike)crop.getStrippedLog()).unlockedBy("has_stripped" + crop.getLowercaseName() + "_log", CroptopiaRecipeProvider.has((ItemLike)crop.getStrippedLog())).save(exporter);
        }
    }

    protected void generateJams(RecipeOutput exporter) {
        for (Jam jam : Jam.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(jam.getCrop().getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)jam).requires(tag).requires((ItemLike)Items.SUGAR).requires((ItemLike)Content.COOKING_POT).unlockedBy("has_" + jam.getCrop().getLowercaseName(), CroptopiaRecipeProvider.has(tag)).save(exporter);
        }
    }

    protected void generateJuices(RecipeOutput exporter) {
        for (Juice juice : Juice.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(juice.getCrop().getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)juice).requires(tag).requires((ItemLike)Content.FOOD_PRESS).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_" + juice.getCrop().getLowercaseName(), CroptopiaRecipeProvider.has(tag)).save(exporter);
        }
    }

    protected void generateSmoothies(RecipeOutput exporter) {
        for (Smoothie smoothie : Smoothie.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(smoothie.getCrop().getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)smoothie).requires(tag).requires((ItemLike)Items.ICE).requires(CroptopiaRecipeProvider.independentTag("milks")).requires((ItemLike)Items.GLASS_BOTTLE).unlockedBy("has_" + smoothie.getCrop().getLowercaseName(), CroptopiaRecipeProvider.has(tag)).save(exporter);
        }
    }

    protected void generateIceCream(RecipeOutput exporter) {
        for (IceCream iceCream : IceCream.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(iceCream.getCrop().getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)iceCream).requires(tag).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.EGG).requires(CroptopiaRecipeProvider.independentTag("milks")).requires((ItemLike)Content.COOKING_POT).unlockedBy("has_" + iceCream.getCrop().getLowercaseName(), CroptopiaRecipeProvider.has(tag)).save(exporter);
        }
    }

    protected void generatePie(RecipeOutput exporter) {
        for (Pie pie : Pie.copy()) {
            TagKey<Item> tag = CroptopiaRecipeProvider.independentTag(pie.getCrop().getPlural());
            ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)pie).requires(tag).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.EGG).requires(CroptopiaRecipeProvider.independentTag("flour")).requires(CroptopiaRecipeProvider.independentTag("doughs")).requires((ItemLike)Content.FRYING_PAN).unlockedBy("has_" + pie.getCrop().getLowercaseName(), CroptopiaRecipeProvider.has(tag)).save(exporter);
        }
    }

    protected void offerFoodCookingRecipe(RecipeOutput exporter, ItemLike input, String inputName, ItemLike output, int time, float exp, boolean campFire) {
        SimpleCookingRecipeBuilder.smelting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)exp, (int)time).unlockedBy("has_" + inputName, CroptopiaRecipeProvider.has((ItemLike)input)).save(exporter, "croptopia:" + CroptopiaRecipeProvider.getItemName((ItemLike)output) + "_from_" + inputName);
        SimpleCookingRecipeBuilder.smoking((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{input}), (RecipeCategory)RecipeCategory.FOOD, (ItemLike)output, (float)exp, (int)(time / 2)).unlockedBy("has_" + inputName, CroptopiaRecipeProvider.has((ItemLike)input)).save(exporter, "croptopia:" + CroptopiaRecipeProvider.getItemName((ItemLike)output) + "_from_smoking_" + inputName);
    }

    protected void generateFurnace(RecipeOutput exporter) {
        int time = 200;
        float exp = 0.2f;
        ImmutableMap cookingList = new ImmutableMap.Builder().put((Object)Content.BLACKBEAN, (Object)Content.BAKED_BEANS).put((Object)Content.SWEETPOTATO, (Object)Content.BAKED_SWEET_POTATO).put((Object)Content.YAM, (Object)Content.BAKED_YAM).put((Object)Content.ANCHOVY, (Object)Content.COOKED_ANCHOVY).put((Object)Content.CALAMARI, (Object)Content.COOKED_CALAMARI).put((Object)Content.GLOWING_CALAMARI, (Object)Content.COOKED_CALAMARI).put((Object)Content.SHRIMP, (Object)Content.COOKED_SHRIMP).put((Object)Content.TUNA, (Object)Content.COOKED_TUNA).put((Object)Content.CORN, (Object)Content.POPCORN).put((Object)Content.GRAPE, (Object)Content.RAISINS).build();
        cookingList.forEach((input, output) -> this.offerFoodCookingRecipe(exporter, (ItemLike)input, input.getLowercaseName(), (ItemLike)output, 200, 0.2f, true));
        this.offerFoodCookingRecipe(exporter, (ItemLike)Content.RAW_BACON, "bacon", Content.COOKED_BACON, 200, 0.2f, true);
        this.offerFoodCookingRecipe(exporter, (ItemLike)Items.SUGAR, "sugar", Content.CARAMEL, 200, 0.2f, true);
        this.offerFoodCookingRecipe(exporter, (ItemLike)Items.SUGAR_CANE, "sugar_cane", Content.MOLASSES, 200, 0.2f, false);
        this.offerFoodCookingRecipe(exporter, (ItemLike)Items.BREAD, "bread", Content.TOAST, 200, 0.2f, false);
        this.offerFoodCookingRecipe(exporter, (ItemLike)Content.WATER_BOTTLE, "water_bottle", (ItemLike)Content.SALT, 800, 0.1f, false);
        this.offerFoodCookingRecipe(exporter, (ItemLike)Content.RAW_RAVAGER_MEAT, "raw_ravager_meat", Content.COOKED_RAVAGER_MEAT, 800, 0.1f, false);
        SimpleCookingRecipeBuilder.blasting((Ingredient)Ingredient.of((ItemLike[])new ItemLike[]{Content.WATER_BOTTLE}), (RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.SALT, (float)0.1f, (int)400);
    }

    protected void generateUtensil(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.COOKING_POT).pattern("# #").pattern("# #").pattern(" # ").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_iron", CroptopiaRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.FOOD_PRESS).pattern("I").pattern("H").pattern("I").define(Character.valueOf('I'), (ItemLike)Items.PISTON).define(Character.valueOf('H'), (ItemLike)Items.HOPPER).unlockedBy("has_piston", CroptopiaRecipeProvider.has((ItemLike)Items.PISTON)).unlockedBy("has_hopper", CroptopiaRecipeProvider.has((ItemLike)Items.HOPPER)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.FRYING_PAN).pattern("#  ").pattern(" ##").pattern(" ##").define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_iron", CroptopiaRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.KNIFE).pattern(" #").pattern("i ").define(Character.valueOf('i'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (ItemLike)Items.IRON_INGOT).unlockedBy("has_iron", CroptopiaRecipeProvider.has((ItemLike)Items.IRON_INGOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.MORTAR_AND_PESTLE).pattern("i").pattern("#").define(Character.valueOf('i'), (ItemLike)Items.STICK).define(Character.valueOf('#'), (ItemLike)Items.BOWL).unlockedBy("has_bowl", CroptopiaRecipeProvider.has((ItemLike)Items.BOWL)).save(exporter);
    }

    protected void generateMiscShapeless(RecipeOutput exporter) {
        TagKey<Item> saltTag = CroptopiaRecipeProvider.independentTag("salts");
        TagKey<Item> butterTag = CroptopiaRecipeProvider.independentTag("butters");
        TagKey<Item> kumquatTag = CroptopiaRecipeProvider.independentTag(Content.KUMQUAT.getPlural());
        TagKey<Item> turmericTag = CroptopiaRecipeProvider.independentTag(Content.TURMERIC.getPlural());
        TagKey<Item> grapeTag = CroptopiaRecipeProvider.independentTag(Content.GRAPE.getPlural());
        TagKey<Item> almondTag = CroptopiaRecipeProvider.independentTag(Content.ALMOND.getPlural());
        TagKey<Item> artichoke = CroptopiaRecipeProvider.independentTag(Content.ARTICHOKE.getPlural());
        TagKey<Item> banana = CroptopiaRecipeProvider.independentTag(Content.BANANA.getPlural());
        TagKey<Item> vanilla = CroptopiaRecipeProvider.independentTag(Content.VANILLA.getPlural());
        TagKey<Item> hops = CroptopiaRecipeProvider.independentTag(Content.HOPS.getPlural());
        TagKey<Item> barley = CroptopiaRecipeProvider.independentTag(Content.BARLEY.getPlural());
        TagKey<Item> lettuce = CroptopiaRecipeProvider.independentTag(Content.LETTUCE.getPlural());
        TagKey<Item> tomato = CroptopiaRecipeProvider.independentTag(Content.TOMATO.getPlural());
        TagKey<Item> blackbean = CroptopiaRecipeProvider.independentTag(Content.BLACKBEAN.getPlural());
        TagKey<Item> rice = CroptopiaRecipeProvider.independentTag(Content.RICE.getPlural());
        TagKey<Item> tortilla = CroptopiaRecipeProvider.independentTag("tortillas");
        TagKey<Item> flour = CroptopiaRecipeProvider.independentTag("flour");
        TagKey<Item> milks = CroptopiaRecipeProvider.independentTag("milks");
        TagKey<Item> cheese = CroptopiaRecipeProvider.independentTag("cheeses");
        TagKey<Item> nuts = CroptopiaRecipeProvider.independentTag("nuts");
        TagKey<Item> chocolates = CroptopiaRecipeProvider.independentTag("chocolates");
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.ALMOND_BRITTLE, (int)2).requires(butterTag).requires(almondTag).requires((ItemLike)Items.SUGAR, 2).unlockedBy("has_almond", CroptopiaRecipeProvider.has((ItemLike)Content.ALMOND)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.ARTICHOKE_DIP).requires(artichoke).requires(cheese).unlockedBy("has_artichoke", CroptopiaRecipeProvider.has((ItemLike)Content.ARTICHOKE)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BANANA_CREAM_PIE).requires(banana).requires(vanilla).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.EGG).requires(milks).requires((ItemLike)Content.FRYING_PAN).unlockedBy("has_banana", CroptopiaRecipeProvider.has((ItemLike)Content.BANANA)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BANANA_NUT_BREAD, (int)2).requires((ItemLike)Content.CINNAMON).requires((ItemLike)Items.SUGAR).requires(flour).requires(banana).requires(nuts).unlockedBy("has_banana", CroptopiaRecipeProvider.has(banana)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BEER).requires((ItemLike)Items.GLASS_BOTTLE).requires(hops).requires(barley).requires((ItemLike)Content.FOOD_PRESS).unlockedBy("has_hops", CroptopiaRecipeProvider.has((ItemLike)Content.HOPS)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BLT).requires((ItemLike)Items.BREAD).requires((ItemLike)Content.COOKED_BACON).requires(lettuce).requires(tomato).unlockedBy("has_cooked_bacon", CroptopiaRecipeProvider.has((ItemLike)Content.COOKED_BACON)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BROWNIES).requires((ItemLike)Items.SUGAR).requires((ItemLike)Items.EGG).requires((ItemLike)Content.FRYING_PAN).requires(flour).requires(milks).requires(chocolates).unlockedBy("has_chocolates", CroptopiaRecipeProvider.has(chocolates)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BURRITO).requires(tortilla).requires(rice).requires(blackbean).requires(tomato).unlockedBy("has_rice", CroptopiaRecipeProvider.has(rice)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.DEAD_BUSH).requires(saltTag).requires(ItemTags.SAPLINGS).unlockedBy("has_salts", CroptopiaRecipeProvider.has(saltTag)).save(exporter, "croptopia:" + CroptopiaRecipeProvider.getItemName((ItemLike)Items.DEAD_BUSH));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CANDIED_KUMQUATS, (int)7).requires(kumquatTag).requires(kumquatTag).requires(kumquatTag).requires(kumquatTag).requires(kumquatTag).requires(kumquatTag).requires(kumquatTag).requires(CroptopiaRecipeProvider.independentTag("vanilla")).requires((ItemLike)Items.HONEY_BOTTLE).unlockedBy("has_kumquat", CroptopiaRecipeProvider.has((ItemLike)Content.KUMQUAT)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.ORANGE_DYE, (int)2).requires(turmericTag).requires(turmericTag).requires(turmericTag).unlockedBy("has_turmeric", CroptopiaRecipeProvider.has((ItemLike)Content.TURMERIC)).save(exporter, "croptopia:" + CroptopiaRecipeProvider.getItemName((ItemLike)Items.ORANGE_DYE));
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Items.PURPLE_DYE, (int)2).requires(grapeTag).requires(grapeTag).requires(grapeTag).unlockedBy("has_grape", CroptopiaRecipeProvider.has((ItemLike)Content.GRAPE)).save(exporter, "croptopia:" + CroptopiaRecipeProvider.getItemName((ItemLike)Items.PURPLE_DYE));
    }

    protected void generateMiscShaped(RecipeOutput exporter) {
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.ROASTED_PUMPKIN_SEEDS).pattern("123").pattern(" 4 ").define(Character.valueOf('1'), (ItemLike)Items.PUMPKIN_SEEDS).define(Character.valueOf('3'), (ItemLike)Content.PEPPER.asItem()).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('4'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_pumpkin_seed", CroptopiaRecipeProvider.has((ItemLike)Items.PUMPKIN_SEEDS)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.ROASTED_SUNFLOWER_SEEDS).pattern("123").pattern(" 4 ").define(Character.valueOf('1'), (ItemLike)Items.SUNFLOWER).define(Character.valueOf('3'), (ItemLike)Content.PEPPER.asItem()).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('4'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_sunflower", CroptopiaRecipeProvider.has((ItemLike)Items.SUNFLOWER)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.PUMPKIN_BARS, (int)3).pattern("586").pattern("124").pattern("373").define(Character.valueOf('1'), (ItemLike)Items.EGG).define(Character.valueOf('2'), (ItemLike)Items.SUGAR).define(Character.valueOf('3'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('5'), (ItemLike)Content.CINNAMON).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('7'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('8'), CroptopiaRecipeProvider.independentTag("vanilla")).unlockedBy("has_pumpkin", CroptopiaRecipeProvider.has((ItemLike)Items.PUMPKIN)).unlockedBy("has_cinnamon", CroptopiaRecipeProvider.has((ItemLike)Content.CINNAMON)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CORN_BREAD).pattern("111").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("corn")).unlockedBy("has_corn", CroptopiaRecipeProvider.has((ItemLike)Content.CORN.asItem())).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.PUMPKIN_SOUP, (int)2).pattern("123").pattern(" 5 ").pattern("464").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("onions")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("garlic")).define(Character.valueOf('3'), (ItemLike)Content.PEPPER.asItem()).define(Character.valueOf('4'), (ItemLike)Items.PUMPKIN).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('6'), (ItemLike)Content.COOKING_POT).unlockedBy("has_pumpkin", CroptopiaRecipeProvider.has((ItemLike)Items.PUMPKIN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.MERINGUE, (int)2).pattern("243").pattern("111").define(Character.valueOf('1'), (ItemLike)Items.EGG).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('3'), (ItemLike)Items.SUGAR).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("vanilla")).unlockedBy("has_egg", CroptopiaRecipeProvider.has((ItemLike)Items.EGG)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CABBAGE_ROLL, (int)2).pattern("121").pattern("456").pattern("585").define(Character.valueOf('8'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('1'), this.croptopia("beef_replacements")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("onions")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("rice")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("cabbage")).unlockedBy("has_cabbage", CroptopiaRecipeProvider.has((ItemLike)Content.CABBAGE.asItem())).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.BORSCHT, (int)2).pattern("123").pattern("456").pattern("789").define(Character.valueOf('1'), (ItemLike)Items.CARROT).define(Character.valueOf('2'), (ItemLike)Items.POTATO).define(Character.valueOf('3'), (ItemLike)Items.BEETROOT).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("onions")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("tomatoes")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("water_bottles")).define(Character.valueOf('8'), (ItemLike)Content.COOKING_POT).define(Character.valueOf('7'), CroptopiaRecipeProvider.independentTag("cabbage")).define(Character.valueOf('9'), CroptopiaRecipeProvider.independentTag("garlic")).unlockedBy("has_cabbage", CroptopiaRecipeProvider.has((ItemLike)Content.CABBAGE.asItem())).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.GOULASH).pattern("123").pattern("454").pattern("183").define(Character.valueOf('8'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('1'), this.croptopia("pork_replacements")).define(Character.valueOf('3'), this.croptopia("beef_replacements")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("onions")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("cabbage")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("tomatoes")).unlockedBy("has_cabbage", CroptopiaRecipeProvider.has((ItemLike)Content.CABBAGE.asItem())).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.BEETROOT_SALAD).pattern("111").pattern("745").pattern(" 6 ").define(Character.valueOf('1'), (ItemLike)Items.BEETROOT).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("lemons")).define(Character.valueOf('6'), (ItemLike)Content.COOKING_POT).define(Character.valueOf('7'), CroptopiaRecipeProvider.independentTag("lettuce")).unlockedBy("has_beetroot", CroptopiaRecipeProvider.has((ItemLike)Items.BEETROOT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.STEAMED_CRAB).pattern("1").pattern("2").pattern("3").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("crabs")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("water_bottles")).define(Character.valueOf('3'), (ItemLike)Content.COOKING_POT).unlockedBy("has_crab", CroptopiaRecipeProvider.has((ItemLike)Content.CRAB)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.DEEP_FRIED_SHRIMP, (int)2).pattern("111").pattern("456").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("shrimp")).define(Character.valueOf('4'), (ItemLike)Items.EGG).define(Character.valueOf('6'), (ItemLike)Items.BREAD).define(Character.valueOf('5'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_shrimp", CroptopiaRecipeProvider.has((ItemLike)Content.SHRIMP)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.TUNA_ROLL, (int)2).pattern("234").pattern(" 1 ").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("tuna")).define(Character.valueOf('2'), (ItemLike)Items.DRIED_KELP).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("rice")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("onions")).unlockedBy("has_tuna", CroptopiaRecipeProvider.has((ItemLike)Content.TUNA)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.FRIED_CALAMARI, (int)2).pattern("123").pattern("456").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("calamari")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("lemons")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("olive_oils")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('5'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("sea_lettuce")).unlockedBy("has_calamari", CroptopiaRecipeProvider.has((ItemLike)Content.CALAMARI)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CRAB_LEGS, (int)2).pattern("123").pattern("455").pattern(" 7 ").define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("crabs")).define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("garlic")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('4'), (ItemLike)Content.PEPPER.asItem()).define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_crab", CroptopiaRecipeProvider.has((ItemLike)Content.CRAB)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.STEAMED_CLAMS, (int)2).pattern("123").pattern("455").pattern(" 7 ").define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("clams")).define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("garlic")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('4'), (ItemLike)Content.PEPPER.asItem()).define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_clams", CroptopiaRecipeProvider.has((ItemLike)Content.CLAM)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.GRILLED_OYSTERS, (int)2).pattern("121").pattern("456").pattern(" 7 ").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("oysters")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("lemons")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("garlic")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_oysters", CroptopiaRecipeProvider.has((ItemLike)Content.GRILLED_OYSTERS)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.ANCHOVY_PIZZA, (int)1).pattern("123").pattern(" 4 ").pattern(" 7 ").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("tomatoes")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("anchovies")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("doughs")).define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_anchovies", CroptopiaRecipeProvider.has((ItemLike)Content.ANCHOVY)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.MASHED_POTATOES, (int)1).pattern("1 ").pattern("24").pattern("3 ").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("potatoes")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('3'), (ItemLike)Content.MORTAR_AND_PESTLE).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("milks")).unlockedBy("has_milk", CroptopiaRecipeProvider.has((ItemLike)Items.MILK_BUCKET)).save(exporter);
        ShapelessRecipeBuilder.shapeless((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.TORTILLA, (int)2).requires(CroptopiaRecipeProvider.independentTag("flour")).requires((ItemLike)Content.FRYING_PAN).requires(CroptopiaRecipeProvider.independentTag("water_bottles")).unlockedBy("took_flour", CroptopiaRecipeProvider.has(CroptopiaRecipeProvider.independentTag("flour"))).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.SWEET_CREPES, (int)1).pattern("123").pattern("4 5").pattern(" 6 ").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('2'), (ItemLike)Items.EGG).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("milks")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("jams")).define(Character.valueOf('5'), (ItemLike)Items.SUGAR).define(Character.valueOf('6'), (ItemLike)Content.FRYING_PAN).unlockedBy("took_flour", CroptopiaRecipeProvider.has(CroptopiaRecipeProvider.independentTag("flour"))).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.BAKED_CREPES, (int)1).pattern("121").pattern("356").pattern(" 7 ").define(Character.valueOf('1'), (ItemLike)Items.EGG).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("milks")).define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("spinach")).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.QUICHE, (int)1).pattern(" 1 ").pattern("234").pattern("5 6").define(Character.valueOf('1'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("onions")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("milks")).define(Character.valueOf('3'), (ItemLike)Items.EGG).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("spinach")).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.DAUPHINE_POTATOES, (int)1).pattern("213").pattern("456").define(Character.valueOf('1'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("water_bottles")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("milks")).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("olive_oils")).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CROQUE_MONSIEUR, (int)1).pattern(" 1 ").pattern(" 26").pattern("435").define(Character.valueOf('1'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('2'), (ItemLike)Items.BREAD).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('4'), this.croptopia("pork_replacements")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("flour")).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CROQUE_MADAME, (int)1).pattern(" 1 ").pattern("726").pattern("435").define(Character.valueOf('1'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('2'), (ItemLike)Items.BREAD).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('4'), this.croptopia("pork_replacements")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('6'), CroptopiaRecipeProvider.independentTag("flour")).define(Character.valueOf('7'), (ItemLike)Items.EGG).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.SUNNY_SIDE_EGGS, (int)2).pattern("121").define(Character.valueOf('2'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('1'), (ItemLike)Items.EGG).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.MACARON, (int)2).pattern("122").pattern("565").define(Character.valueOf('1'), (ItemLike)Items.EGG).define(Character.valueOf('2'), (ItemLike)Items.SUGAR).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("almonds")).define(Character.valueOf('6'), (ItemLike)Content.FOOD_PRESS).unlockedBy("has_food_press", CroptopiaRecipeProvider.has((ItemLike)Content.FOOD_PRESS)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.THE_BIG_BREAKFAST, (int)1).pattern("123").pattern("736").pattern(" 45").define(Character.valueOf('7'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('1'), (ItemLike)Items.EGG).define(Character.valueOf('2'), (ItemLike)Content.RAW_BACON).define(Character.valueOf('3'), (ItemLike)Content.HASHED_BROWN).define(Character.valueOf('4'), (ItemLike)Content.BAKED_BEANS).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("sausages")).define(Character.valueOf('6'), (ItemLike)Content.TOAST).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.GROUND_PORK, (int)2).pattern("1").pattern("2").define(Character.valueOf('1'), this.croptopia("pork_replacements")).define(Character.valueOf('2'), (ItemLike)Content.FOOD_PRESS).unlockedBy("has_food_press", CroptopiaRecipeProvider.has((ItemLike)Content.FOOD_PRESS)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.SAUSAGE, (int)1).pattern("1").pattern("2").pattern("3").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("ground_pork")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("paprika")).unlockedBy("has_ground_pork", CroptopiaRecipeProvider.has((ItemLike)Content.GROUND_PORK)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.CINNAMON_ROLL, (int)3).pattern("123").pattern("456").pattern("798").define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("milks")).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("doughs")).define(Character.valueOf('3'), (ItemLike)Items.EGG).define(Character.valueOf('4'), CroptopiaRecipeProvider.independentTag("butters")).define(Character.valueOf('5'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('6'), (ItemLike)Items.SUGAR).define(Character.valueOf('7'), CroptopiaRecipeProvider.independentTag("cinnamon")).define(Character.valueOf('8'), (ItemLike)Content.WHIPPING_CREAM).define(Character.valueOf('9'), (ItemLike)Content.FRYING_PAN).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.MISC, (ItemLike)Content.HASHED_BROWN, (int)4).pattern("123").pattern(" 4 ").define(Character.valueOf('4'), (ItemLike)Content.KNIFE).define(Character.valueOf('1'), CroptopiaRecipeProvider.independentTag("potatoes")).define(Character.valueOf('2'), (ItemLike)Content.FRYING_PAN).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("olive_oils")).unlockedBy("has_frying_pan", CroptopiaRecipeProvider.has((ItemLike)Content.FRYING_PAN)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.BEEF_JERKY, (int)14).pattern("111").pattern("121").pattern("111").define(Character.valueOf('1'), (ItemLike)Items.BEEF).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).unlockedBy("has_salt", CroptopiaRecipeProvider.has((ItemLike)Content.SALT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.PORK_JERKY, (int)14).pattern("111").pattern("121").pattern("111").define(Character.valueOf('1'), (ItemLike)Items.PORKCHOP).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("salts")).unlockedBy("has_salt", CroptopiaRecipeProvider.has((ItemLike)Content.SALT)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.DRAGON_EGG_OMELETTE, (int)1).pattern(" 1 ").pattern(" 2 ").pattern("3 4").define(Character.valueOf('1'), (ItemLike)Items.DRAGON_EGG).define(Character.valueOf('2'), CroptopiaRecipeProvider.independentTag("cheeses")).define(Character.valueOf('3'), CroptopiaRecipeProvider.independentTag("salts")).define(Character.valueOf('4'), (ItemLike)Content.PEPPER).unlockedBy("has_dragon_egg", CroptopiaRecipeProvider.has((ItemLike)Items.DRAGON_EGG)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.NETHER_STAR_CAKE, (int)1).pattern(" 1 ").pattern("222").pattern("444").define(Character.valueOf('1'), (ItemLike)Items.NETHER_STAR).define(Character.valueOf('2'), (ItemLike)Content.DOUGH).define(Character.valueOf('4'), (ItemLike)Items.SUGAR).unlockedBy("has_nether_star", CroptopiaRecipeProvider.has((ItemLike)Items.NETHER_STAR)).save(exporter);
        ShapedRecipeBuilder.shaped((RecipeCategory)RecipeCategory.FOOD, (ItemLike)Content.TRANSCENDENTAL_BREAKFAST, (int)1).pattern("616").pattern("234").pattern("656").define(Character.valueOf('1'), (ItemLike)Content.MOUNTAIN_SALT).define(Character.valueOf('2'), (ItemLike)Content.NETHER_STAR_CAKE).define(Character.valueOf('3'), (ItemLike)Content.TUNA_SANDWICH).define(Character.valueOf('4'), (ItemLike)Content.DRAGON_EGG_OMELETTE).define(Character.valueOf('5'), (ItemLike)Content.COOKED_RAVAGER_MEAT).define(Character.valueOf('6'), (ItemLike)Content.THE_BIG_BREAKFAST).unlockedBy("has_nether_star_cake", CroptopiaRecipeProvider.has((ItemLike)Content.NETHER_STAR_CAKE)).save(exporter);
    }

    private TagKey<Item> croptopia(String name) {
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"croptopia", (String)name));
    }

    public static TagKey<Item> independentTag(String name) {
        ResourceLocation location = ResourceLocation.fromNamespaceAndPath((String)"c", (String)name);
        return TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)location);
    }
}

