/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.MapCodec;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.MultifaceBlock;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.VineBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.neoforge.common.IShearable;

public class FleshVeinsBlock
extends Block
implements IShearable {
    public static final MapCodec<VineBlock> CODEC = FleshVeinsBlock.simpleCodec(VineBlock::new);
    private static final int MAX_CONNECTED_VEINS = 30;
    public static final BooleanProperty UP = PipeBlock.UP;
    public static final BooleanProperty NORTH = PipeBlock.NORTH;
    public static final BooleanProperty EAST = PipeBlock.EAST;
    public static final BooleanProperty SOUTH = PipeBlock.SOUTH;
    public static final BooleanProperty WEST = PipeBlock.WEST;
    public static final Map<Direction, BooleanProperty> PROPERTY_BY_DIRECTION = (Map)PipeBlock.PROPERTY_BY_DIRECTION.entrySet().stream().filter(p_57886_ -> p_57886_.getKey() != Direction.DOWN).collect(Util.toMap());
    protected static final float AABB_OFFSET = 1.0f;
    private static final VoxelShape UP_AABB = Block.box((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape WEST_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    private static final VoxelShape EAST_AABB = Block.box((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape NORTH_AABB = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    private static final VoxelShape SOUTH_AABB = Block.box((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    private final Map<BlockState, VoxelShape> shapesCache;

    public MapCodec<VineBlock> codec() {
        return CODEC;
    }

    public FleshVeinsBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false)));
        this.shapesCache = ImmutableMap.copyOf(this.stateDefinition.getPossibleStates().stream().collect(Collectors.toMap(Function.identity(), FleshVeinsBlock::calculateShape)));
    }

    private static VoxelShape calculateShape(BlockState state) {
        VoxelShape voxelshape = Shapes.empty();
        if (((Boolean)state.getValue((Property)UP)).booleanValue()) {
            voxelshape = UP_AABB;
        }
        if (((Boolean)state.getValue((Property)NORTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)NORTH_AABB);
        }
        if (((Boolean)state.getValue((Property)SOUTH)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)SOUTH_AABB);
        }
        if (((Boolean)state.getValue((Property)EAST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)EAST_AABB);
        }
        if (((Boolean)state.getValue((Property)WEST)).booleanValue()) {
            voxelshape = Shapes.or((VoxelShape)voxelshape, (VoxelShape)WEST_AABB);
        }
        return voxelshape.isEmpty() ? Shapes.block() : voxelshape;
    }

    protected VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return this.shapesCache.get(pState);
    }

    protected boolean propagatesSkylightDown(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return true;
    }

    protected boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return this.hasFaces(this.getUpdatedState(pState, (BlockGetter)pLevel, pPos));
    }

    private boolean hasFaces(BlockState pState) {
        return this.countFaces(pState) > 0;
    }

    private int countFaces(BlockState pState) {
        int i = 0;
        for (BooleanProperty booleanproperty : PROPERTY_BY_DIRECTION.values()) {
            if (!((Boolean)pState.getValue((Property)booleanproperty)).booleanValue()) continue;
            ++i;
        }
        return i;
    }

    private boolean canSupportAtFace(BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        if (pDirection == Direction.DOWN) {
            return false;
        }
        BlockPos blockpos = pPos.relative(pDirection);
        if (FleshVeinsBlock.isAcceptableNeighbour(pLevel, blockpos, pDirection)) {
            return true;
        }
        if (pDirection.getAxis() == Direction.Axis.Y) {
            return false;
        }
        BooleanProperty booleanproperty = PROPERTY_BY_DIRECTION.get(pDirection);
        BlockState blockstate = pLevel.getBlockState(pPos.above());
        return blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
    }

    public static boolean isAcceptableNeighbour(BlockGetter pBlockReader, BlockPos pNeighborPos, Direction pAttachedFace) {
        return MultifaceBlock.canAttachTo((BlockGetter)pBlockReader, (Direction)pAttachedFace, (BlockPos)pNeighborPos, (BlockState)pBlockReader.getBlockState(pNeighborPos));
    }

    private BlockState getUpdatedState(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        if (((Boolean)pState.getValue((Property)UP)).booleanValue()) {
            pState = (BlockState)pState.setValue((Property)UP, (Comparable)Boolean.valueOf(FleshVeinsBlock.isAcceptableNeighbour(pLevel, blockpos, Direction.DOWN)));
        }
        BlockState blockstate = null;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty = FleshVeinsBlock.getPropertyForFace(direction);
            if (!((Boolean)pState.getValue((Property)booleanproperty)).booleanValue()) continue;
            boolean flag = this.canSupportAtFace(pLevel, pPos, direction);
            if (!flag) {
                if (blockstate == null) {
                    blockstate = pLevel.getBlockState(blockpos);
                }
                flag = blockstate.is((Block)this) && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            }
            pState = (BlockState)pState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(flag));
        }
        return pState;
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        if (pFacing == Direction.DOWN) {
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        BlockState blockstate = this.getUpdatedState(pState, (BlockGetter)pLevel, pCurrentPos);
        return !this.hasFaces(blockstate) ? Blocks.AIR.defaultBlockState() : blockstate;
    }

    protected void randomTick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (pLevel.getGameRules().getBoolean(GameRules.RULE_DO_VINES_SPREAD) && pLevel.random.nextInt(4) == 0 && pLevel.isAreaLoaded(pPos, 4)) {
            Direction direction = Direction.getRandom((RandomSource)pRandom);
            BlockPos blockpos = pPos.above();
            int connectedVeins = this.countConnectedVeins((BlockGetter)pLevel, pPos);
            if (connectedVeins >= 30) {
                return;
            }
            if (direction.getAxis().isHorizontal() && !((Boolean)pState.getValue((Property)FleshVeinsBlock.getPropertyForFace(direction))).booleanValue()) {
                if (this.canSpread((BlockGetter)pLevel, pPos)) {
                    BlockPos blockpos4 = pPos.relative(direction);
                    BlockState blockstate4 = pLevel.getBlockState(blockpos4);
                    if (blockstate4.isAir()) {
                        Direction direction3 = direction.getClockWise();
                        Direction direction4 = direction.getCounterClockWise();
                        boolean flag = (Boolean)pState.getValue((Property)FleshVeinsBlock.getPropertyForFace(direction3));
                        boolean flag1 = (Boolean)pState.getValue((Property)FleshVeinsBlock.getPropertyForFace(direction4));
                        BlockPos blockpos2 = blockpos4.relative(direction3);
                        BlockPos blockpos3 = blockpos4.relative(direction4);
                        if (flag && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockpos2, direction3)) {
                            pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue((Property)FleshVeinsBlock.getPropertyForFace(direction3), (Comparable)Boolean.valueOf(true)), 2);
                        } else if (flag1 && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockpos3, direction4)) {
                            pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue((Property)FleshVeinsBlock.getPropertyForFace(direction4), (Comparable)Boolean.valueOf(true)), 2);
                        } else {
                            Direction direction1 = direction.getOpposite();
                            if (flag && pLevel.isEmptyBlock(blockpos2) && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, pPos.relative(direction3), direction1)) {
                                pLevel.setBlock(blockpos2, (BlockState)this.defaultBlockState().setValue((Property)FleshVeinsBlock.getPropertyForFace(direction1), (Comparable)Boolean.valueOf(true)), 2);
                            } else if (flag1 && pLevel.isEmptyBlock(blockpos3) && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, pPos.relative(direction4), direction1)) {
                                pLevel.setBlock(blockpos3, (BlockState)this.defaultBlockState().setValue((Property)FleshVeinsBlock.getPropertyForFace(direction1), (Comparable)Boolean.valueOf(true)), 2);
                            } else if ((double)pRandom.nextFloat() < 0.05 && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockpos4.above(), Direction.UP)) {
                                pLevel.setBlock(blockpos4, (BlockState)this.defaultBlockState().setValue((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                            }
                        }
                    } else if (FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockpos4, direction)) {
                        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)FleshVeinsBlock.getPropertyForFace(direction), (Comparable)Boolean.valueOf(true)), 2);
                    }
                }
            } else {
                BlockState blockstate2;
                BlockState blockstate1;
                BlockPos blockpos1;
                BlockState blockstate;
                if (direction == Direction.UP && pPos.getY() < pLevel.getMaxBuildHeight() - 1) {
                    if (this.canSupportAtFace((BlockGetter)pLevel, pPos, direction)) {
                        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)UP, (Comparable)Boolean.valueOf(true)), 2);
                        return;
                    }
                    if (pLevel.isEmptyBlock(blockpos)) {
                        if (!this.canSpread((BlockGetter)pLevel, pPos)) {
                            return;
                        }
                        BlockState blockstate3 = pState;
                        for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                            if (!pRandom.nextBoolean() && FleshVeinsBlock.isAcceptableNeighbour((BlockGetter)pLevel, blockpos.relative(direction2), direction2)) continue;
                            blockstate3 = (BlockState)blockstate3.setValue((Property)FleshVeinsBlock.getPropertyForFace(direction2), (Comparable)Boolean.valueOf(false));
                        }
                        if (this.hasHorizontalConnection(blockstate3)) {
                            pLevel.setBlock(blockpos, blockstate3, 2);
                        }
                        return;
                    }
                }
                if (pPos.getY() > pLevel.getMinBuildHeight() && ((blockstate = pLevel.getBlockState(blockpos1 = pPos.below())).isAir() || blockstate.is((Block)this)) && (blockstate1 = blockstate.isAir() ? this.defaultBlockState() : blockstate) != (blockstate2 = this.copyRandomFaces(pState, blockstate1, pRandom)) && this.hasHorizontalConnection(blockstate2)) {
                    pLevel.setBlock(blockpos1, blockstate2, 2);
                }
            }
        }
    }

    private BlockState copyRandomFaces(BlockState pSourceState, BlockState pSpreadState, RandomSource pRandom) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BooleanProperty booleanproperty;
            if (!pRandom.nextBoolean() || !((Boolean)pSourceState.getValue((Property)(booleanproperty = FleshVeinsBlock.getPropertyForFace(direction)))).booleanValue()) continue;
            pSpreadState = (BlockState)pSpreadState.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return pSpreadState;
    }

    private boolean hasHorizontalConnection(BlockState pState) {
        return (Boolean)pState.getValue((Property)NORTH) != false || (Boolean)pState.getValue((Property)EAST) != false || (Boolean)pState.getValue((Property)SOUTH) != false || (Boolean)pState.getValue((Property)WEST) != false;
    }

    private boolean canSpread(BlockGetter pBlockReader, BlockPos pPos) {
        int i = 4;
        Iterable iterable = BlockPos.betweenClosed((int)(pPos.getX() - 4), (int)(pPos.getY() - 1), (int)(pPos.getZ() - 4), (int)(pPos.getX() + 4), (int)(pPos.getY() + 1), (int)(pPos.getZ() + 4));
        int j = 5;
        for (BlockPos blockpos : iterable) {
            if (!pBlockReader.getBlockState(blockpos).is((Block)this) || --j > 0) continue;
            return false;
        }
        return true;
    }

    protected boolean canBeReplaced(BlockState pState, BlockPlaceContext pUseContext) {
        BlockState blockstate = pUseContext.getLevel().getBlockState(pUseContext.getClickedPos());
        return blockstate.is((Block)this) ? this.countFaces(blockstate) < PROPERTY_BY_DIRECTION.size() : super.canBeReplaced(pState, pUseContext);
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        BlockState blockstate = pContext.getLevel().getBlockState(pContext.getClickedPos());
        boolean flag = blockstate.is((Block)this);
        BlockState blockstate1 = flag ? blockstate : this.defaultBlockState();
        for (Direction direction : pContext.getNearestLookingDirections()) {
            boolean flag1;
            if (direction == Direction.DOWN) continue;
            BooleanProperty booleanproperty = FleshVeinsBlock.getPropertyForFace(direction);
            boolean bl = flag1 = flag && (Boolean)blockstate.getValue((Property)booleanproperty) != false;
            if (flag1 || !this.canSupportAtFace((BlockGetter)pContext.getLevel(), pContext.getClickedPos(), direction)) continue;
            return (BlockState)blockstate1.setValue((Property)booleanproperty, (Comparable)Boolean.valueOf(true));
        }
        return flag ? blockstate1 : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{UP, NORTH, EAST, SOUTH, WEST});
    }

    protected BlockState rotate(BlockState pState, Rotation pRotate) {
        switch (pRotate) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)((Boolean)pState.getValue((Property)SOUTH)))).setValue((Property)EAST, (Comparable)((Boolean)pState.getValue((Property)WEST)))).setValue((Property)SOUTH, (Comparable)((Boolean)pState.getValue((Property)NORTH)))).setValue((Property)WEST, (Comparable)((Boolean)pState.getValue((Property)EAST)));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)((Boolean)pState.getValue((Property)EAST)))).setValue((Property)EAST, (Comparable)((Boolean)pState.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)pState.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)pState.getValue((Property)NORTH)));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)((Boolean)pState.getValue((Property)WEST)))).setValue((Property)EAST, (Comparable)((Boolean)pState.getValue((Property)NORTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)pState.getValue((Property)EAST)))).setValue((Property)WEST, (Comparable)((Boolean)pState.getValue((Property)SOUTH)));
            }
        }
        return pState;
    }

    protected BlockState mirror(BlockState pState, Mirror pMirror) {
        switch (pMirror) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)pState.setValue((Property)NORTH, (Comparable)((Boolean)pState.getValue((Property)SOUTH)))).setValue((Property)SOUTH, (Comparable)((Boolean)pState.getValue((Property)NORTH)));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)pState.setValue((Property)EAST, (Comparable)((Boolean)pState.getValue((Property)WEST)))).setValue((Property)WEST, (Comparable)((Boolean)pState.getValue((Property)EAST)));
            }
        }
        return super.mirror(pState, pMirror);
    }

    public static BooleanProperty getPropertyForFace(Direction pFace) {
        return PROPERTY_BY_DIRECTION.get(pFace);
    }

    private int countConnectedVeins(BlockGetter pLevel, BlockPos pPos) {
        int count = 0;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos neighborPos = pPos.relative(direction);
            BlockState neighborState = pLevel.getBlockState(neighborPos);
            if (!neighborState.is((Block)this)) continue;
            ++count;
        }
        if (pLevel.getBlockState(pPos).is((Block)this)) {
            ++count;
        }
        return count;
    }
}

