/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.veroxuniverse.crystal_chronicles.block.AxonBlock;
import org.jetbrains.annotations.NotNull;

public class NeuronBlock
extends HalfTransparentBlock {
    public static final VoxelShape SHAPE_BASE = Block.box((double)3.0, (double)3.0, (double)3.0, (double)13.0, (double)13.0, (double)13.0);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;
    private static final int MIN_TICK_INTERVAL = 100;
    private static final int MAX_TICK_INTERVAL = 100;
    private static final int MIN_LIGHT_DURATION = 100;
    private static final int MAX_LIGHT_DURATION = 100;
    private static final int MAX_AXONS = 10;

    public NeuronBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void onPlace(BlockState pState, Level pLevel, BlockPos pPos, BlockState pOldState, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            pLevel.scheduleTick(pPos, (Block)this, this.getRandomInterval(100, 100));
        }
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return (BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false));
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        int tickInterval = 100 + pRandom.nextInt(1);
        int lightDuration = 100 + pRandom.nextInt(1);
        boolean shouldBeLit = (Boolean)pState.getValue((Property)LIT) == false;
        pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
        this.updateAboveBlocks(pLevel, pPos);
        pLevel.scheduleTick(pPos, (Block)this, tickInterval);
    }

    private void updateAboveBlocks(ServerLevel pLevel, BlockPos pPos) {
        BlockState currentState;
        int count = 0;
        for (BlockPos currentPos = pPos.above(); currentPos != null && count < 10 && (currentState = pLevel.getBlockState(currentPos)).getBlock() instanceof AxonBlock; currentPos = currentPos.above()) {
            boolean shouldBeLit = (Boolean)pLevel.getBlockState(pPos).getValue((Property)LIT);
            if ((Boolean)currentState.getValue((Property)AxonBlock.LIT) == shouldBeLit) continue;
            pLevel.setBlock(currentPos, (BlockState)currentState.setValue((Property)AxonBlock.LIT, (Comparable)Boolean.valueOf(shouldBeLit)), 3);
            ++count;
        }
    }

    public int getLightBlock(BlockState state, BlockGetter world, BlockPos pos) {
        return state.getLightEmission();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{LIT});
    }

    public boolean isSignalSource(BlockState state) {
        return false;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.NORMAL;
    }

    private int getRandomInterval(int minTicks, int maxTicks) {
        Random random = new Random();
        return minTicks + random.nextInt(maxTicks - minTicks + 1);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.MODEL;
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        return SHAPE_BASE;
    }

    public boolean useShapeForLightOcclusion(BlockState pState) {
        return true;
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE_BASE;
    }

    @NotNull
    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext context) {
        return SHAPE_BASE;
    }
}

