/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.PipeBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.util.TriState;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;

public class VeinBlock
extends PipeBlock {
    public static final MapCodec<VeinBlock> CODEC = VeinBlock.simpleCodec(VeinBlock::new);

    public MapCodec<VeinBlock> codec() {
        return CODEC;
    }

    public VeinBlock(BlockBehaviour.Properties properties) {
        super(0.3125f, properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)NORTH, (Comparable)Boolean.valueOf(false))).setValue((Property)EAST, (Comparable)Boolean.valueOf(false))).setValue((Property)SOUTH, (Comparable)Boolean.valueOf(false))).setValue((Property)WEST, (Comparable)Boolean.valueOf(false))).setValue((Property)UP, (Comparable)Boolean.valueOf(false))).setValue((Property)DOWN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        return VeinBlock.getStateWithConnections((BlockGetter)pContext.getLevel(), pContext.getClickedPos(), this.defaultBlockState());
    }

    public static BlockState getStateWithConnections(BlockGetter getter, BlockPos pos, BlockState state) {
        BlockState blockstate = getter.getBlockState(pos.below());
        BlockState blockstate1 = getter.getBlockState(pos.above());
        BlockState blockstate2 = getter.getBlockState(pos.north());
        BlockState blockstate3 = getter.getBlockState(pos.east());
        BlockState blockstate4 = getter.getBlockState(pos.south());
        BlockState blockstate5 = getter.getBlockState(pos.west());
        Block block = state.getBlock();
        TriState soilDecision = blockstate.canSustainPlant(getter, pos.below(), Direction.UP, state);
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)state.trySetValue((Property)DOWN, (Comparable)Boolean.valueOf(blockstate.is(block) || blockstate.is(CCBlocks.ARTREE_CAPILLARY) || blockstate.is(CCBlocks.ARTREE_BASE) || soilDecision.isTrue()))).trySetValue((Property)UP, (Comparable)Boolean.valueOf(blockstate1.is(block) || blockstate1.is(CCBlocks.ARTREE_CAPILLARY)))).trySetValue((Property)NORTH, (Comparable)Boolean.valueOf(blockstate2.is(block) || blockstate2.is(CCBlocks.ARTREE_CAPILLARY)))).trySetValue((Property)EAST, (Comparable)Boolean.valueOf(blockstate3.is(block) || blockstate3.is(CCBlocks.ARTREE_CAPILLARY)))).trySetValue((Property)SOUTH, (Comparable)Boolean.valueOf(blockstate4.is(block) || blockstate4.is(CCBlocks.ARTREE_CAPILLARY)))).trySetValue((Property)WEST, (Comparable)Boolean.valueOf(blockstate5.is(block) || blockstate5.is(CCBlocks.ARTREE_CAPILLARY)));
    }

    protected BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        TriState soilDecision;
        boolean flag;
        if (!pState.canSurvive((LevelReader)pLevel, pCurrentPos)) {
            pLevel.scheduleTick(pCurrentPos, (Block)this, 1);
            return super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
        }
        boolean bl = flag = pFacingState.is((Block)this) || pFacingState.is(CCBlocks.ARTREE_BASE) || pFacingState.is(CCBlocks.ARTREE_CAPILLARY);
        if (pFacing == Direction.DOWN && !(soilDecision = pFacingState.canSustainPlant((BlockGetter)pLevel, pFacingPos.relative(pFacing), pFacing.getOpposite(), pState)).isDefault()) {
            flag = soilDecision.isTrue();
        }
        return (BlockState)pState.setValue((Property)PROPERTY_BY_DIRECTION.get(pFacing), (Comparable)Boolean.valueOf(flag));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN});
    }
}

