/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.datagen;

import java.util.Set;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.functions.ApplyBonusCount;
import net.minecraft.world.level.storage.loot.functions.FunctionUserBuilder;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.SetItemCountFunction;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.UniformGenerator;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;
import net.veroxuniverse.crystal_chronicles.registry.CCItems;

public class CCBlockLootTableProvider
extends BlockLootSubProvider {
    protected CCBlockLootTableProvider(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf((Block)CCBlocks.BLOOD_BASES.get());
        this.dropSelf((Block)CCBlocks.FLESH_BLOCK.get());
        this.dropSelf((Block)CCBlocks.MUSCLE_BLOCK.get());
        this.dropSelf((Block)CCBlocks.ARTREE_BASE.get());
        this.dropSelf((Block)CCBlocks.ARTREE_CAPILLARY.get());
        this.dropSelf((Block)CCBlocks.ARTREE_VEIN.get());
        this.dropSelf((Block)CCBlocks.AXON.get());
        this.dropSelf((Block)CCBlocks.NEURON_TORCH.get());
        this.dropOther((Block)CCBlocks.NEURON_TORCH_WALL.get(), (ItemLike)CCBlocks.NEURON_TORCH.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_PLANKS.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_STAIRS.get());
        this.add((Block)CCBlocks.BRONCHUS_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.BRONCHUS_SLAB.get()));
        this.dropSelf((Block)CCBlocks.BRONCHUS_FENCE.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_FENCE_GATE.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_BUTTON.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_PRESSURE_PLATE.get());
        this.dropSelf((Block)CCBlocks.BRONCHUS_TRAPDOOR.get());
        this.add((Block)CCBlocks.VEINS.get(), block -> CCBlockLootTableProvider.createShearsOnlyDrop((ItemLike)((ItemLike)CCBlocks.VEINS.get())));
        this.dropSelf((Block)CCBlocks.CRUSTONE.get());
        this.dropSelf((Block)CCBlocks.CRUSTONE_BRICKS.get());
        this.dropSelf((Block)CCBlocks.CRACKED_CRUSTONE_BRICKS.get());
        this.dropSelf((Block)CCBlocks.POLISHED_CRUSTONE.get());
        this.dropSelf((Block)CCBlocks.CHISELED_CRUSTONE.get());
        this.dropSelf((Block)CCBlocks.CRUSTONE_STAIRS.get());
        this.dropSelf((Block)CCBlocks.CRUSTONE_BRICKS_STAIRS.get());
        this.dropSelf((Block)CCBlocks.CRACKED_CRUSTONE_BRICKS_STAIRS.get());
        this.dropSelf((Block)CCBlocks.POLISHED_CRUSTONE_STAIRS.get());
        this.dropSelf((Block)CCBlocks.CHISELED_CRUSTONE_STAIRS.get());
        this.dropSelf((Block)CCBlocks.CRUSTONE_WALL.get());
        this.dropSelf((Block)CCBlocks.CRUSTONE_BRICKS_WALL.get());
        this.dropSelf((Block)CCBlocks.CRACKED_CRUSTONE_BRICKS_WALL.get());
        this.dropSelf((Block)CCBlocks.POLISHED_CRUSTONE_WALL.get());
        this.dropSelf((Block)CCBlocks.CHISELED_CRUSTONE_WALL.get());
        this.dropSelf((Block)CCBlocks.ALVEOLUS.get());
        this.add((Block)CCBlocks.CRUSTONE_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.CRUSTONE_SLAB.get()));
        this.add((Block)CCBlocks.CRUSTONE_BRICKS_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.CRUSTONE_BRICKS_SLAB.get()));
        this.add((Block)CCBlocks.CRACKED_CRUSTONE_BRICKS_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.CRACKED_CRUSTONE_BRICKS_SLAB.get()));
        this.add((Block)CCBlocks.POLISHED_CRUSTONE_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.POLISHED_CRUSTONE_SLAB.get()));
        this.add((Block)CCBlocks.CHISELED_CRUSTONE_SLAB.get(), block -> this.createSlabItemTable((Block)CCBlocks.CHISELED_CRUSTONE_SLAB.get()));
        this.dropSelf((Block)CCBlocks.TENDON_BLOCK.get());
        this.dropSelf((Block)CCBlocks.CELVER_LIGHT.get());
        this.dropSelf((Block)CCBlocks.SKIN_LAYER.get());
        this.dropSelf((Block)CCBlocks.BLOOD_BASES.get());
        this.dropSelf((Block)CCBlocks.HANGING_VEINS.get());
        this.add((Block)CCBlocks.FAT_TISSUE_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.FAT_TISSUE_BLOCK.get(), (Item)CCItems.FAT_TISSUE_BALL.get(), 2.0f, 4.0f));
        this.add((Block)CCBlocks.NEURON_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.NEURON_BLOCK.get(), (Item)CCItems.NEURON.get(), 2.0f, 4.0f));
        this.add((Block)CCBlocks.ROTTEN_FLESH_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.ROTTEN_FLESH_BLOCK.get(), Items.ROTTEN_FLESH, 2.0f, 4.0f));
        this.add((Block)CCBlocks.EYE_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.EYE_BLOCK.get(), (Item)CCItems.EYE.get(), 1.0f, 1.0f));
        this.add((Block)CCBlocks.HEMALITE_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.HEMALITE_BLOCK.get(), (Item)CCItems.HEMALITE_SHARD.get(), 1.0f, 4.0f));
        this.add((Block)CCBlocks.ALVEOLUS_BLOCK.get(), block -> this.createMultipleOreDrops((Block)CCBlocks.ALVEOLUS_BLOCK.get(), Item.byBlock((Block)((Block)CCBlocks.ALVEOLUS.get())), 0.0f, 1.0f));
        this.add((Block)CCBlocks.BRONCHUS_DOOR.get(), block -> this.createDoorTable((Block)CCBlocks.BRONCHUS_DOOR.get()));
        this.add((Block)CCBlocks.TALL_BLOOD_BASES.get(), block -> this.createDoorTable((Block)CCBlocks.TALL_BLOOD_BASES.get()));
    }

    protected LootTable.Builder createMultipleOreDrops(Block pBlock, Item item, float minDrops, float maxDrops) {
        HolderLookup.RegistryLookup registrylookup = this.registries.lookupOrThrow(Registries.ENCHANTMENT);
        return this.createSilkTouchDispatchTable(pBlock, (LootPoolEntryContainer.Builder)this.applyExplosionDecay((ItemLike)pBlock, (FunctionUserBuilder)LootItem.lootTableItem((ItemLike)item).apply((LootItemFunction.Builder)SetItemCountFunction.setCount((NumberProvider)UniformGenerator.between((float)minDrops, (float)maxDrops))).apply((LootItemFunction.Builder)ApplyBonusCount.addOreBonusCount((Holder)registrylookup.getOrThrow(Enchantments.FORTUNE)))));
    }

    protected Iterable<Block> getKnownBlocks() {
        return CCBlocks.BLOCKS.getEntries().stream().map(Holder::value)::iterator;
    }
}

