/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.datagen;

import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.client.model.generators.ItemModelBuilder;
import net.neoforged.neoforge.client.model.generators.ItemModelProvider;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.veroxuniverse.crystal_chronicles.fluid.CCFluids;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;
import net.veroxuniverse.crystal_chronicles.registry.CCItems;

public class CCItemModelProvider
extends ItemModelProvider {
    public CCItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "crystal_chronicles", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)CCItems.TANK_HELMET.get());
        this.basicItem((Item)CCItems.TANK_CHESTPLATE.get());
        this.basicItem((Item)CCItems.TANK_LEGGINGS.get());
        this.basicItem((Item)CCItems.TANK_BOOTS.get());
        this.basicItem((Item)CCItems.ROGUE_HELMET.get());
        this.basicItem((Item)CCItems.ROGUE_CHESTPLATE.get());
        this.basicItem((Item)CCItems.ROGUE_LEGGINGS.get());
        this.basicItem((Item)CCItems.ROGUE_BOOTS.get());
        this.basicItem((Item)CCItems.MAGE_HELMET.get());
        this.basicItem((Item)CCItems.MAGE_CHESTPLATE.get());
        this.basicItem((Item)CCItems.MAGE_LEGGINGS.get());
        this.basicItem((Item)CCItems.MAGE_BOOTS.get());
        this.basicItem((Item)CCItems.PALADIN_HELMET.get());
        this.basicItem((Item)CCItems.PALADIN_CHESTPLATE.get());
        this.basicItem((Item)CCItems.PALADIN_LEGGINGS.get());
        this.basicItem((Item)CCItems.PALADIN_BOOTS.get());
        this.basicItem((Item)CCItems.HEMALITE_SHARD.get());
        this.basicItem((Item)CCItems.VOIDSTONE_SHARD.get());
        this.basicItem((Item)CCItems.DIVINITE_SHARD.get());
        this.basicItem((Item)CCItems.VOLTITE_SHARD.get());
        this.basicItem((Item)CCItems.FLORALITE_SHARD.get());
        this.basicItem((Item)CCItems.VOLCANITE_SHARD.get());
        this.basicItem((Item)CCItems.TOXIC_HELMET.get());
        this.basicItem((Item)CCItems.TOXIC_CHESTPLATE.get());
        this.basicItem((Item)CCItems.TOXIC_LEGGINGS.get());
        this.basicItem((Item)CCItems.TOXIC_BOOTS.get());
        this.basicItem((Item)CCItems.PYROMANCER_HELMET.get());
        this.basicItem((Item)CCItems.PYROMANCER_CHESTPLATE.get());
        this.basicItem((Item)CCItems.PYROMANCER_LEGGINGS.get());
        this.basicItem((Item)CCItems.PYROMANCER_BOOTS.get());
        this.basicItem((Item)CCItems.EVOKER_HELMET.get());
        this.basicItem((Item)CCItems.EVOKER_CHESTPLATE.get());
        this.basicItem((Item)CCItems.EVOKER_LEGGINGS.get());
        this.basicItem((Item)CCItems.EVOKER_BOOTS.get());
        this.basicItem((Item)CCItems.ELECTROMANCER_HELMET.get());
        this.basicItem((Item)CCItems.ELECTROMANCER_CHESTPLATE.get());
        this.basicItem((Item)CCItems.ELECTROMANCER_LEGGINGS.get());
        this.basicItem((Item)CCItems.ELECTROMANCER_BOOTS.get());
        this.basicItem((Item)CCItems.FAT_TISSUE_BALL.get());
        this.basicItem((Item)CCItems.ICE_SHARD.get());
        this.basicItem((Item)CCItems.NEURON.get());
        this.basicItem((Item)CCItems.EYE.get());
        this.basicItem((Item)CCFluids.BLOOD_BUCKET.get());
        this.flowerItem(CCBlocks.BLOOD_BASES);
        this.flowerItem(CCBlocks.AXON);
        this.flowerItem(CCBlocks.HANGING_VEINS);
        this.buttonItem(CCBlocks.BRONCHUS_BUTTON, CCBlocks.BRONCHUS_PLANKS);
        this.fenceItem(CCBlocks.BRONCHUS_FENCE, CCBlocks.BRONCHUS_PLANKS);
        this.basicItem(CCBlocks.BRONCHUS_DOOR.asItem());
        this.saplingItem(CCBlocks.ALVEOLUS);
        this.wallItem(CCBlocks.CRUSTONE_WALL, CCBlocks.CRUSTONE);
        this.wallItem(CCBlocks.CRUSTONE_BRICKS_WALL, CCBlocks.CRUSTONE_BRICKS);
        this.wallItem(CCBlocks.CRACKED_CRUSTONE_BRICKS_WALL, CCBlocks.CRACKED_CRUSTONE_BRICKS);
        this.wallItem(CCBlocks.POLISHED_CRUSTONE_WALL, CCBlocks.POLISHED_CRUSTONE);
        this.wallItem(CCBlocks.CHISELED_CRUSTONE_WALL, CCBlocks.CHISELED_CRUSTONE);
    }

    private ItemModelBuilder saplingItem(DeferredBlock<Block> item) {
        return (ItemModelBuilder)((ItemModelBuilder)this.withExistingParent(item.getId().getPath(), ResourceLocation.parse((String)"item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)("block/" + item.getId().getPath())));
    }

    public void flowerItem(DeferredBlock<Block> block) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("item/generated"))).texture("layer0", ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)("block/" + block.getId().getPath())));
    }

    public void buttonItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/button_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void fenceItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/fence_inventory"))).texture("texture", ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)("block/" + baseBlock.getId().getPath())));
    }

    public void wallItem(DeferredBlock<Block> block, DeferredBlock<Block> baseBlock) {
        ((ItemModelBuilder)this.withExistingParent(block.getId().getPath(), this.mcLoc("block/wall_inventory"))).texture("wall", ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)("block/" + baseBlock.getId().getPath())));
    }
}

