/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.datagen;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.veroxuniverse.crystal_chronicles.datagen.CCBlockLootTableProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCBlockStateProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCBlockTagProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCFluidTagsProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCItemModelProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCItemTagProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCRecipeProvider;
import net.veroxuniverse.crystal_chronicles.datagen.CCWorldGenProvider;

@EventBusSubscriber(modid="crystal_chronicles", bus=EventBusSubscriber.Bus.MOD)
public class DataGenerator {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        net.minecraft.data.DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new CCRecipeProvider(packOutput, lookupProvider));
        generator.addProvider(event.includeServer(), (DataProvider)new LootTableProvider(packOutput, Collections.emptySet(), List.of(new LootTableProvider.SubProviderEntry(CCBlockLootTableProvider::new, LootContextParamSets.BLOCK)), lookupProvider));
        CCBlockTagProvider blockTagsProvider = new CCBlockTagProvider(packOutput, lookupProvider, existingFileHelper);
        generator.addProvider(event.includeServer(), (DataProvider)blockTagsProvider);
        generator.addProvider(event.includeServer(), (DataProvider)new CCFluidTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CCItemTagProvider(packOutput, lookupProvider, blockTagsProvider.contentsGetter(), existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new CCItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new CCBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new CCWorldGenProvider(packOutput, lookupProvider));
    }
}

