/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.entity;

import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.veroxuniverse.crystal_chronicles.entity.custom.CrystalDrakeEntity;
import net.veroxuniverse.crystal_chronicles.entity.custom.CrystalGolemEntity;
import net.veroxuniverse.crystal_chronicles.entity.custom.CrystalScorpionEntity;
import net.veroxuniverse.crystal_chronicles.entity.custom.CrystalWolfEntity;

public class CCEntityTypes {
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((Registry)BuiltInRegistries.ENTITY_TYPE, (String)"crystal_chronicles");
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalDrakeEntity>> CRYSTAL_DRAKE = CCEntityTypes.registerEntity("crystal_drake", EntityType.Builder.of(CrystalDrakeEntity::new, (MobCategory)MobCategory.MONSTER).sized(3.2f, 2.2f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalGolemEntity>> CRYSTAL_GOLEM = CCEntityTypes.registerEntity("crystal_golem", EntityType.Builder.of(CrystalGolemEntity::new, (MobCategory)MobCategory.MONSTER).sized(0.8f, 1.2f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalScorpionEntity>> CRYSTAL_SCORPION = CCEntityTypes.registerEntity("crystal_scorpion", EntityType.Builder.of(CrystalScorpionEntity::new, (MobCategory)MobCategory.MONSTER).sized(3.2f, 2.2f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true));
    public static final DeferredHolder<EntityType<?>, EntityType<CrystalWolfEntity>> CRYSTAL_WOLF = CCEntityTypes.registerEntity("crystal_wolf", EntityType.Builder.of(CrystalWolfEntity::new, (MobCategory)MobCategory.MONSTER).sized(1.2f, 0.8f).setTrackingRange(20).setShouldReceiveVelocityUpdates(true));

    static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> registerEntity(String name, EntityType.Builder<T> builder) {
        return ENTITIES.register(name, () -> builder.build("crystal_chronicles:" + name));
    }

    public static void register(IEventBus eventBus) {
        ENTITIES.register(eventBus);
    }
}

