/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.registry;

import java.util.function.Supplier;
import java.util.function.ToIntFunction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.veroxuniverse.crystal_chronicles.block.ArteeBaseBlock;
import net.veroxuniverse.crystal_chronicles.block.AxonBlock;
import net.veroxuniverse.crystal_chronicles.block.BloodFlowerBlock;
import net.veroxuniverse.crystal_chronicles.block.BronchusBlock;
import net.veroxuniverse.crystal_chronicles.block.CCSaplingBlock;
import net.veroxuniverse.crystal_chronicles.block.CapillaryBlock;
import net.veroxuniverse.crystal_chronicles.block.CleverLightBlock;
import net.veroxuniverse.crystal_chronicles.block.EyeBlock;
import net.veroxuniverse.crystal_chronicles.block.FleshBlock;
import net.veroxuniverse.crystal_chronicles.block.FleshVeinsBlock;
import net.veroxuniverse.crystal_chronicles.block.HangingVeinsBlock;
import net.veroxuniverse.crystal_chronicles.block.NeuronBlock;
import net.veroxuniverse.crystal_chronicles.block.NeuronTorchBlock;
import net.veroxuniverse.crystal_chronicles.block.SkinLayerBlock;
import net.veroxuniverse.crystal_chronicles.block.TallBloodFlowerBlock;
import net.veroxuniverse.crystal_chronicles.block.VeinBlock;
import net.veroxuniverse.crystal_chronicles.block.WallNeuronTorchBlock;
import net.veroxuniverse.crystal_chronicles.registry.CCItems;
import net.veroxuniverse.crystal_chronicles.worldgen.tree.CCTreeGrower;

public class CCBlocks {
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"crystal_chronicles");
    public static final DeferredBlock<Block> BLOOD_BASES = CCBlocks.registerBlock("blood_bases", () -> new BloodFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SHORT_GRASS)));
    public static final DeferredBlock<Block> TALL_BLOOD_BASES = CCBlocks.registerBlock("tall_blood_bases", () -> new TallBloodFlowerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.TALL_GRASS)));
    public static final DeferredBlock<Block> ALVEOLUS_BLOCK = CCBlocks.registerBlock("alveolus_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> FLESH_BLOCK = CCBlocks.registerBlock("flesh_block", () -> new FleshBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> MUSCLE_BLOCK = CCBlocks.registerBlock("muscle_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> TENDON_BLOCK = CCBlocks.registerBlock("tendon_block", () -> new RotatedPillarBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> FAT_TISSUE_BLOCK = CCBlocks.registerBlock("fat_tissue_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> ARTREE_BASE = CCBlocks.registerBlock("artree_base", () -> new ArteeBaseBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL).noOcclusion()));
    public static final DeferredBlock<Block> ARTREE_VEIN = CCBlocks.registerBlock("artree_vein", () -> new VeinBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL).noOcclusion()));
    public static final DeferredBlock<Block> ARTREE_CAPILLARY = CCBlocks.registerBlock("artree_capillary", () -> new CapillaryBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.COBBLESTONE_WALL).noOcclusion()));
    public static final DeferredBlock<Block> NEURON_BLOCK = CCBlocks.registerBlock("neuron_block", () -> new NeuronBlock(BlockBehaviour.Properties.of().lightLevel(CCBlocks.litBlockEmission(15)).strength(0.3f).sound(SoundType.FROGLIGHT).isValidSpawn(Blocks::always).noOcclusion().randomTicks()));
    public static final DeferredBlock<Block> AXON = CCBlocks.registerBlock("axon", () -> new AxonBlock(BlockBehaviour.Properties.of().lightLevel(CCBlocks.litBlockEmission(15)).strength(0.3f).sound(SoundType.FROGLIGHT).isValidSpawn(Blocks::always).noOcclusion().randomTicks()));
    public static final DeferredBlock<Block> ROTTEN_FLESH_BLOCK = CCBlocks.registerBlock("rotten_flesh_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> BRONCHUS = CCBlocks.registerBlock("bronchus", () -> new BronchusBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).requiresCorrectToolForDrops().noOcclusion()));
    public static final DeferredBlock<Block> BRONCHUS_PLANKS = CCBlocks.registerBlock("bronchus_planks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PLANKS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_STAIRS = CCBlocks.registerBlock("bronchus_stairs", () -> new StairBlock(((Block)BRONCHUS_PLANKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_SLAB = CCBlocks.registerBlock("bronchus_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_FENCE = CCBlocks.registerBlock("bronchus_fence", () -> new FenceBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_FENCE_GATE = CCBlocks.registerBlock("bronchus_fence_gate", () -> new FenceGateBlock(WoodType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_FENCE_GATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_BUTTON = CCBlocks.registerBlock("bronchus_button", () -> new ButtonBlock(BlockSetType.OAK, 10, BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops().noCollission()));
    public static final DeferredBlock<Block> BRONCHUS_PRESSURE_PLATE = CCBlocks.registerBlock("bronchus_pressure_plate", () -> new PressurePlateBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_PRESSURE_PLATE).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_DOOR = CCBlocks.registerBlock("bronchus_door", () -> new DoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_DOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> BRONCHUS_TRAPDOOR = CCBlocks.registerBlock("bronchus_trapdoor", () -> new TrapDoorBlock(BlockSetType.OAK, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.OAK_TRAPDOOR).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> NEURON_TORCH = CCBlocks.registerBlockWithoutItem("neuron_torch", () -> new NeuronTorchBlock(ParticleTypes.CRIT, BlockBehaviour.Properties.of().lightLevel(state -> 14).strength(0.3f).sound(SoundType.FROGLIGHT).noOcclusion().noCollission()));
    public static final DeferredBlock<Block> NEURON_TORCH_WALL = CCBlocks.registerBlockWithoutItem("neuron_torch_wall", () -> new WallNeuronTorchBlock(ParticleTypes.CRIT, BlockBehaviour.Properties.of().lightLevel(state -> 14).strength(0.3f).sound(SoundType.FROGLIGHT).noOcclusion().noCollission().lootFrom(NEURON_TORCH)));
    public static final DeferredBlock<Block> EYE_BLOCK = CCBlocks.registerBlock("eye_block", () -> new EyeBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> HANGING_VEINS = CCBlocks.registerBlock("hanging_veins", () -> new HangingVeinsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> CRUSTONE = CCBlocks.registerBlock("crustone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final DeferredBlock<Block> CRUSTONE_STAIRS = CCBlocks.registerBlock("crustone_stairs", () -> new StairBlock(((Block)CRUSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRUSTONE_SLAB = CCBlocks.registerBlock("crustone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRUSTONE_WALL = CCBlocks.registerBlock("crustone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRUSTONE_BRICKS = CCBlocks.registerBlock("crustone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final DeferredBlock<Block> CRUSTONE_BRICKS_STAIRS = CCBlocks.registerBlock("crustone_bricks_stairs", () -> new StairBlock(((Block)CRUSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRUSTONE_BRICKS_SLAB = CCBlocks.registerBlock("crustone_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRUSTONE_BRICKS_WALL = CCBlocks.registerBlock("crustone_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRACKED_CRUSTONE_BRICKS = CCBlocks.registerBlock("cracked_crustone_bricks", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final DeferredBlock<Block> CRACKED_CRUSTONE_BRICKS_STAIRS = CCBlocks.registerBlock("cracked_crustone_bricks_stairs", () -> new StairBlock(((Block)CRACKED_CRUSTONE_BRICKS.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRACKED_CRUSTONE_BRICKS_SLAB = CCBlocks.registerBlock("cracked_crustone_bricks_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CRACKED_CRUSTONE_BRICKS_WALL = CCBlocks.registerBlock("cracked_crustone_bricks_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_CRUSTONE = CCBlocks.registerBlock("polished_crustone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final DeferredBlock<Block> POLISHED_CRUSTONE_STAIRS = CCBlocks.registerBlock("polished_crustone_stairs", () -> new StairBlock(((Block)POLISHED_CRUSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_CRUSTONE_SLAB = CCBlocks.registerBlock("polished_crustone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> POLISHED_CRUSTONE_WALL = CCBlocks.registerBlock("polished_crustone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHISELED_CRUSTONE = CCBlocks.registerBlock("chiseled_crustone", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.SANDSTONE)));
    public static final DeferredBlock<Block> CHISELED_CRUSTONE_STAIRS = CCBlocks.registerBlock("chiseled_crustone_stairs", () -> new StairBlock(((Block)CHISELED_CRUSTONE.get()).defaultBlockState(), BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_STAIRS).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHISELED_CRUSTONE_SLAB = CCBlocks.registerBlock("chiseled_crustone_slab", () -> new SlabBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_SLAB).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> CHISELED_CRUSTONE_WALL = CCBlocks.registerBlock("chiseled_crustone_wall", () -> new WallBlock(BlockBehaviour.Properties.of().strength(4.0f).requiresCorrectToolForDrops()));
    public static final DeferredBlock<Block> ALVEOLUS = CCBlocks.registerBlock("alveolus", () -> new CCSaplingBlock(CCTreeGrower.BRONCHUS, BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_FUNGUS).randomTicks(), (Block)FLESH_BLOCK.get()));
    public static final DeferredBlock<Block> SKIN_LAYER = CCBlocks.registerBlock("skin_layer", () -> new SkinLayerBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.MUD)));
    public static final DeferredBlock<Block> CELVER_LIGHT = CCBlocks.registerBlock("clever_light", () -> new CleverLightBlock(BlockBehaviour.Properties.of().lightLevel(state -> (Boolean)state.getValue((Property)CleverLightBlock.LIT) != false ? 15 : 0).strength(0.3f).sound(SoundType.FROGLIGHT).isValidSpawn(Blocks::always).noOcclusion()));
    public static final DeferredBlock<Block> HEMALITE_BLOCK = CCBlocks.registerBlock("hemalite_block", () -> new Block(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.AMETHYST_BLOCK)));
    public static final DeferredBlock<Block> VEINS = CCBlocks.registerBlock("veins", () -> new FleshVeinsBlock(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.VINE)));

    private static <T extends Block> DeferredBlock<T> registerBlock(String name, Supplier<T> block) {
        DeferredBlock toReturn = BLOCKS.register(name, block);
        CCBlocks.registerBlockItem(name, toReturn);
        return toReturn;
    }

    private static <T extends Block> DeferredBlock<T> registerBlockWithoutItem(String name, Supplier<T> block) {
        return BLOCKS.register(name, block);
    }

    private static ToIntFunction<BlockState> litBlockEmission(int pLightValue) {
        return state -> (Boolean)state.getValue((Property)BlockStateProperties.LIT) != false ? pLightValue : 0;
    }

    private static <T extends Block> void registerBlockItem(String name, DeferredBlock<T> block) {
        CCItems.ITEMS.register(name, () -> new BlockItem((Block)block.get(), new Item.Properties()));
    }

    public static void register(IEventBus eventBus) {
        BLOCKS.register(eventBus);
    }
}

