/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.worldgen;

import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.data.worldgen.placement.VegetationPlacements;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.BiomeFilter;
import net.minecraft.world.level.levelgen.placement.CountOnEveryLayerPlacement;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.placement.RarityFilter;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;
import net.veroxuniverse.crystal_chronicles.worldgen.CCConfiguredFeatures;

public class CCPlacedFeatures {
    public static final ResourceKey<PlacedFeature> BRONCHUS_PLACED_KEY = CCPlacedFeatures.registerKey("bronchus_placed");
    public static final ResourceKey<PlacedFeature> BRONCHUS_PLACED_CAVE_KEY = CCPlacedFeatures.registerKey("bronchus_cave");

    public static void bootstrap(BootstrapContext<PlacedFeature> context) {
        HolderGetter configuredFeatures = context.lookup(Registries.CONFIGURED_FEATURE);
        CCPlacedFeatures.register(context, BRONCHUS_PLACED_KEY, configuredFeatures.getOrThrow(CCConfiguredFeatures.BRONCHUS_KEY), VegetationPlacements.treePlacement((PlacementModifier)PlacementUtils.countExtra((int)3, (float)0.1f, (int)2), (Block)((Block)CCBlocks.ALVEOLUS.get())));
        CCPlacedFeatures.register(context, BRONCHUS_PLACED_CAVE_KEY, configuredFeatures.getOrThrow(CCConfiguredFeatures.BRONCHUS_KEY), List.of(RarityFilter.onAverageOnceEvery((int)15), CountOnEveryLayerPlacement.of((int)7), BiomeFilter.biome()));
    }

    private static ResourceKey<PlacedFeature> registerKey(String name) {
        return ResourceKey.create((ResourceKey)Registries.PLACED_FEATURE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"crystal_chronicles", (String)name));
    }

    private static void register(BootstrapContext<PlacedFeature> context, ResourceKey<PlacedFeature> key, Holder<ConfiguredFeature<?, ?>> configuration, List<PlacementModifier> modifiers) {
        context.register(key, (Object)new PlacedFeature(configuration, List.copyOf(modifiers)));
    }
}

