/*
 * Decompiled with CFR 0.152.
 */
package net.veroxuniverse.crystal_chronicles.worldgen;

import com.mojang.serialization.Codec;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.levelgen.Column;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.phys.Vec3;
import net.veroxuniverse.crystal_chronicles.registry.CCBlocks;
import net.veroxuniverse.crystal_chronicles.util.MuscleUtils;
import net.veroxuniverse.crystal_chronicles.worldgen.LargeMuscleDripstoneConfiguration;

public class LargeMuscleDripstoneFeature
extends Feature<LargeMuscleDripstoneConfiguration> {
    public LargeMuscleDripstoneFeature(Codec<LargeMuscleDripstoneConfiguration> pCodec) {
        super(pCodec);
    }

    public boolean place(FeaturePlaceContext<LargeMuscleDripstoneConfiguration> pContext) {
        WorldGenLevel worldgenlevel = pContext.level();
        BlockPos blockpos = pContext.origin();
        LargeMuscleDripstoneConfiguration largedripstoneconfiguration = (LargeMuscleDripstoneConfiguration)pContext.config();
        RandomSource randomsource = pContext.random();
        if (!MuscleUtils.isEmptyOrWater((LevelAccessor)worldgenlevel, blockpos)) {
            return false;
        }
        Optional optional = Column.scan((LevelSimulatedReader)worldgenlevel, (BlockPos)blockpos, (int)largedripstoneconfiguration.floorToCeilingSearchRange, MuscleUtils::isEmptyOrWater, MuscleUtils::isMuscleBaseOrLava);
        if (!optional.isEmpty() && optional.get() instanceof Column.Range) {
            Column.Range column$range = (Column.Range)optional.get();
            if (column$range.height() < 4) {
                return false;
            }
            int i = (int)((float)column$range.height() * largedripstoneconfiguration.maxColumnRadiusToCaveHeightRatio);
            int j = Mth.clamp((int)i, (int)largedripstoneconfiguration.columnRadius.getMinValue(), (int)largedripstoneconfiguration.columnRadius.getMaxValue());
            int k = Mth.randomBetweenInclusive((RandomSource)randomsource, (int)largedripstoneconfiguration.columnRadius.getMinValue(), (int)j);
            LargeDripstone largedripstonefeature$largedripstone = LargeMuscleDripstoneFeature.makeDripstone(blockpos.atY(column$range.ceiling() - 1), false, randomsource, k, largedripstoneconfiguration.stalactiteBluntness, largedripstoneconfiguration.heightScale);
            LargeDripstone largedripstonefeature$largedripstone1 = LargeMuscleDripstoneFeature.makeDripstone(blockpos.atY(column$range.floor() + 1), true, randomsource, k, largedripstoneconfiguration.stalagmiteBluntness, largedripstoneconfiguration.heightScale);
            WindOffsetter largedripstonefeature$windoffsetter = largedripstonefeature$largedripstone.isSuitableForWind(largedripstoneconfiguration) && largedripstonefeature$largedripstone1.isSuitableForWind(largedripstoneconfiguration) ? new WindOffsetter(blockpos.getY(), randomsource, largedripstoneconfiguration.windSpeed) : WindOffsetter.noWind();
            boolean flag = largedripstonefeature$largedripstone.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            boolean flag1 = largedripstonefeature$largedripstone1.moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(worldgenlevel, largedripstonefeature$windoffsetter);
            if (flag) {
                largedripstonefeature$largedripstone.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter);
            }
            if (flag1) {
                largedripstonefeature$largedripstone1.placeBlocks(worldgenlevel, randomsource, largedripstonefeature$windoffsetter);
            }
            return true;
        }
        return false;
    }

    private static LargeDripstone makeDripstone(BlockPos pRoot, boolean pPointingUp, RandomSource pRandom, int pRadius, FloatProvider pBluntnessBase, FloatProvider pScaleBase) {
        return new LargeDripstone(pRoot, pPointingUp, pRadius, pBluntnessBase.sample(pRandom), pScaleBase.sample(pRandom));
    }

    private void placeDebugMarkers(WorldGenLevel pLevel, BlockPos pPos, Column.Range pRange, WindOffsetter pWindOffsetter) {
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.ceiling() - 1)), Blocks.DIAMOND_BLOCK.defaultBlockState(), 2);
        pLevel.setBlock(pWindOffsetter.offset(pPos.atY(pRange.floor() + 1)), Blocks.GOLD_BLOCK.defaultBlockState(), 2);
        BlockPos.MutableBlockPos blockpos$mutableblockpos = pPos.atY(pRange.floor() + 2).mutable();
        while (blockpos$mutableblockpos.getY() < pRange.ceiling() - 1) {
            BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
            if (MuscleUtils.isEmptyOrWater((LevelAccessor)pLevel, blockpos) || pLevel.getBlockState(blockpos).is((Block)CCBlocks.MUSCLE_BLOCK.get())) {
                pLevel.setBlock(blockpos, Blocks.CREEPER_HEAD.defaultBlockState(), 2);
            }
            blockpos$mutableblockpos.move(Direction.UP);
        }
    }

    static final class LargeDripstone {
        private BlockPos root;
        private final boolean pointingUp;
        private int radius;
        private final double bluntness;
        private final double scale;

        LargeDripstone(BlockPos pRoot, boolean pPointingUp, int pRadius, double pBluntness, double pScale) {
            this.root = pRoot;
            this.pointingUp = pPointingUp;
            this.radius = pRadius;
            this.bluntness = pBluntness;
            this.scale = pScale;
        }

        private int getHeight() {
            return this.getHeightAtRadius(0.0f);
        }

        private int getMinY() {
            return this.pointingUp ? this.root.getY() : this.root.getY() - this.getHeight();
        }

        private int getMaxY() {
            return !this.pointingUp ? this.root.getY() : this.root.getY() + this.getHeight();
        }

        boolean moveBackUntilBaseIsInsideStoneAndShrinkRadiusIfNecessary(WorldGenLevel pLevel, WindOffsetter pWindOffsetter) {
            while (this.radius > 1) {
                BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.mutable();
                int i = Math.min(10, this.getHeight());
                for (int j = 0; j < i; ++j) {
                    if (pLevel.getBlockState((BlockPos)blockpos$mutableblockpos).is(Blocks.LAVA)) {
                        return false;
                    }
                    if (MuscleUtils.isCircleMostlyEmbeddedInStone(pLevel, pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos), this.radius)) {
                        this.root = blockpos$mutableblockpos;
                        return true;
                    }
                    blockpos$mutableblockpos.move(this.pointingUp ? Direction.DOWN : Direction.UP);
                }
                this.radius /= 2;
            }
            return false;
        }

        private int getHeightAtRadius(float pRadius) {
            return (int)MuscleUtils.getDripstoneHeight(pRadius, this.radius, this.scale, this.bluntness);
        }

        void placeBlocks(WorldGenLevel pLevel, RandomSource pRandom, WindOffsetter pWindOffsetter) {
            for (int i = -this.radius; i <= this.radius; ++i) {
                block1: for (int j = -this.radius; j <= this.radius; ++j) {
                    int k;
                    float f = Mth.sqrt((float)(i * i + j * j));
                    if (f > (float)this.radius || (k = this.getHeightAtRadius(f)) <= 0) continue;
                    if ((double)pRandom.nextFloat() < 0.2) {
                        k = (int)((float)k * Mth.randomBetween((RandomSource)pRandom, (float)0.8f, (float)1.0f));
                    }
                    BlockPos.MutableBlockPos blockpos$mutableblockpos = this.root.offset(i, 0, j).mutable();
                    boolean flag = false;
                    int l = this.pointingUp ? pLevel.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockpos$mutableblockpos.getX(), blockpos$mutableblockpos.getZ()) : Integer.MAX_VALUE;
                    for (int i1 = 0; i1 < k && blockpos$mutableblockpos.getY() < l; ++i1) {
                        BlockPos blockpos = pWindOffsetter.offset((BlockPos)blockpos$mutableblockpos);
                        if (MuscleUtils.isEmptyOrWaterOrLava((LevelAccessor)pLevel, blockpos)) {
                            flag = true;
                            Block block = (Block)CCBlocks.MUSCLE_BLOCK.get();
                            pLevel.setBlock(blockpos, block.defaultBlockState(), 2);
                        } else if (flag && pLevel.getBlockState(blockpos).is((Block)CCBlocks.FLESH_BLOCK.get())) continue block1;
                        blockpos$mutableblockpos.move(this.pointingUp ? Direction.UP : Direction.DOWN);
                    }
                }
            }
        }

        boolean isSuitableForWind(LargeMuscleDripstoneConfiguration pConfig) {
            return this.radius >= pConfig.minRadiusForWind && this.bluntness >= (double)pConfig.minBluntnessForWind;
        }
    }

    static final class WindOffsetter {
        private final int originY;
        @Nullable
        private final Vec3 windSpeed;

        WindOffsetter(int pOriginY, RandomSource pRandom, FloatProvider pMagnitude) {
            this.originY = pOriginY;
            float f = pMagnitude.sample(pRandom);
            float f1 = Mth.randomBetween((RandomSource)pRandom, (float)0.0f, (float)((float)Math.PI));
            this.windSpeed = new Vec3((double)(Mth.cos((float)f1) * f), 0.0, (double)(Mth.sin((float)f1) * f));
        }

        private WindOffsetter() {
            this.originY = 0;
            this.windSpeed = null;
        }

        static WindOffsetter noWind() {
            return new WindOffsetter();
        }

        BlockPos offset(BlockPos pPos) {
            if (this.windSpeed == null) {
                return pPos;
            }
            int i = this.originY - pPos.getY();
            Vec3 vec3 = this.windSpeed.scale((double)i);
            return pPos.offset(Mth.floor((double)vec3.x), 0, Mth.floor((double)vec3.z));
        }
    }
}

