/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.config;

import com.cmdpro.databank.Databank;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.neoforge.common.ModConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class DatabankClientConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final DatabankClientConfig CLIENT;
    public static boolean forceAlternateHiddenColors;
    public final ModConfigSpec.BooleanValue forceAlternateHiddenColorsValue;
    public static boolean forceAlternateChunkReload;
    public final ModConfigSpec.BooleanValue forceAlternateChunkReloadValue;
    public static double screenshakeMultiplier;
    public final ModConfigSpec.DoubleValue screenshakeMultiplierValue;
    public static boolean allowImpactVisuals;
    public final ModConfigSpec.BooleanValue allowImpactVisualsValue;
    public static boolean allowFlashOnImpactVisuals;
    public final ModConfigSpec.BooleanValue allowFlashOnImpactVisualsValue;

    public DatabankClientConfig(ModConfigSpec.Builder builder) {
        builder.push("compatibility");
        this.forceAlternateHiddenColorsValue = DatabankClientConfig.buildBoolean(builder, "forceAlternateHiddenColors", false, "Should the alternate method for block/item coloring be forcibly enabled? This is normally only applied for sodium and embeddium, Do not change unless there are problems", true);
        this.forceAlternateChunkReloadValue = DatabankClientConfig.buildBoolean(builder, "forceAlternateChunkReload", false, "Should the alternate method for reloading chunks when hidden blocks are updated be forcibly enabled? This is normally only applied for sodium and embeddium, Do not change unless there are problems", true);
        builder.pop();
        builder.push("accessibility");
        this.screenshakeMultiplierValue = DatabankClientConfig.buildDouble(builder, "screenshakeMultiplier", 1.0, 0.0, 1.0, "The multiplier to apply for screenshake intensity");
        this.allowImpactVisualsValue = DatabankClientConfig.buildBoolean(builder, "allowImpactVisuals", true, "Should impact visuals be allowed?");
        this.allowFlashOnImpactVisualsValue = DatabankClientConfig.buildBoolean(builder, "allowFlashOnImpactVisuals", true, "Should impact visuals be allowed to flash?");
        builder.pop();
    }

    private static ModConfigSpec.BooleanValue buildBoolean(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment, boolean gameRestart) {
        builder.comment(comment).translation(name);
        if (gameRestart) {
            builder.gameRestart();
        }
        return builder.define(name, defaultValue);
    }

    private static ModConfigSpec.BooleanValue buildBoolean(ModConfigSpec.Builder builder, String name, boolean defaultValue, String comment) {
        return DatabankClientConfig.buildBoolean(builder, name, defaultValue, comment, false);
    }

    private static ModConfigSpec.IntValue buildInteger(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment, boolean gameRestart) {
        builder.comment(comment).translation(name);
        if (gameRestart) {
            builder.gameRestart();
        }
        return builder.defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.IntValue buildInteger(ModConfigSpec.Builder builder, String name, int defaultValue, int min, int max, String comment) {
        return DatabankClientConfig.buildInteger(builder, name, defaultValue, min, max, name, false);
    }

    private static ModConfigSpec.DoubleValue buildDouble(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment, boolean gameRestart) {
        builder.comment(comment).translation(name);
        if (gameRestart) {
            builder.gameRestart();
        }
        return builder.defineInRange(name, defaultValue, min, max);
    }

    private static ModConfigSpec.DoubleValue buildDouble(ModConfigSpec.Builder builder, String name, double defaultValue, double min, double max, String comment) {
        return DatabankClientConfig.buildDouble(builder, name, defaultValue, min, max, name, false);
    }

    public static void bake(ModConfig config) {
        try {
            forceAlternateHiddenColors = (Boolean)DatabankClientConfig.CLIENT.forceAlternateHiddenColorsValue.get();
            forceAlternateChunkReload = (Boolean)DatabankClientConfig.CLIENT.forceAlternateChunkReloadValue.get();
            screenshakeMultiplier = (Double)DatabankClientConfig.CLIENT.screenshakeMultiplierValue.get();
            allowImpactVisuals = (Boolean)DatabankClientConfig.CLIENT.allowImpactVisualsValue.get();
            allowFlashOnImpactVisuals = (Boolean)DatabankClientConfig.CLIENT.allowFlashOnImpactVisualsValue.get();
        }
        catch (Exception e) {
            Databank.LOGGER.warn("[DATABANK] Failed to load client config!");
            e.printStackTrace();
        }
    }

    static {
        Pair specPair = new ModConfigSpec.Builder().configure(DatabankClientConfig::new);
        CLIENT = (DatabankClientConfig)specPair.getLeft();
        CLIENT_SPEC = (ModConfigSpec)specPair.getRight();
        forceAlternateHiddenColors = true;
        forceAlternateChunkReload = true;
        screenshakeMultiplier = 1.0;
        allowImpactVisuals = true;
        allowFlashOnImpactVisuals = true;
    }
}

