/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.megablock;

import com.cmdpro.databank.megablock.MegablockCore;
import com.cmdpro.databank.megablock.MegablockRouter;
import com.cmdpro.databank.megablock.MegablockShape;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;

public class MegablockCoreUtil {
    public static boolean ableToPlace(MegablockCore core, BlockPlaceContext context) {
        MegablockShape shape = core.getMegablockShape();
        for (Vec3i i : shape.shape) {
            if (context.getLevel().getBlockState(context.getClickedPos().offset(i)).canBeReplaced()) continue;
            return false;
        }
        return true;
    }

    public static void placeRouters(MegablockCore core, Rotation rotation, Level level, BlockPos pos) {
        MegablockShape shape = core.getMegablockShape().getRotated(rotation);
        for (Vec3i i : shape.shape) {
            if (i.equals((Object)Vec3i.ZERO) || !level.getBlockState(pos.offset(i)).canBeReplaced()) continue;
            BlockState router = core.getRouterBlock().defaultBlockState();
            level.setBlockAndUpdate(pos.offset(i), router);
        }
        MegablockCoreUtil.setRouterDirections(shape, core, pos, level, pos);
    }

    public static void setRouterDirections(MegablockCore core, BlockPos corePos, Level level, BlockPos pos) {
        MegablockCoreUtil.setRouterDirections(new ArrayList<BlockPos>(), core.getMegablockShape(), core, corePos, level, pos);
    }

    public static void setRouterDirections(MegablockShape shape, MegablockCore core, BlockPos corePos, Level level, BlockPos pos) {
        MegablockCoreUtil.setRouterDirections(new ArrayList<BlockPos>(), shape, core, corePos, level, pos);
    }

    private static void setRouterDirections(List<BlockPos> alreadyVisited, MegablockShape shape, MegablockCore core, BlockPos corePos, Level level, BlockPos pos) {
        Direction[] directions;
        alreadyVisited.add(pos);
        for (Direction i : directions = Direction.values()) {
            BlockState state;
            BlockPos shifted = pos.relative(i);
            if (alreadyVisited.contains(shifted) || !shape.shape.contains(shifted.subtract((Vec3i)corePos)) || !(state = level.getBlockState(shifted)).is(core.getRouterBlock())) continue;
            state = (BlockState)state.setValue(MegablockRouter.FACING, (Comparable)i.getOpposite());
            level.setBlockAndUpdate(shifted, state);
            MegablockCoreUtil.setRouterDirections(alreadyVisited, shape, core, corePos, level, shifted);
        }
    }

    public static void removeRouters(MegablockCore core, Rotation rotation, Level level, BlockPos pos) {
        MegablockShape shape = core.getMegablockShape().getRotated(rotation);
        for (Vec3i i : shape.shape) {
            if (!level.getBlockState(pos.offset(i)).is(core.getRouterBlock())) continue;
            level.destroyBlock(pos.offset(i), true);
        }
    }
}

