/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.misc.BaseGradient;
import org.joml.Math;

public class DoubleGradient
extends BaseGradient<Double> {
    public DoubleGradient(Double start, float startTime, Double end, float endTime) {
        super(start, startTime, end, endTime);
    }

    public DoubleGradient(Double start, Double end) {
        super(start, end);
    }

    @Override
    public Double blend(Double from, Double to, float progress) {
        return Math.lerp((double)from, (double)to, (double)progress);
    }

    public DoubleGradient addPoint(Double value, float time) {
        super.addPoint(value, time);
        return this;
    }

    public DoubleGradient addPoint(Double value, float time, boolean instant) {
        super.addPoint(value, time, instant);
        return this;
    }

    public DoubleGradient sort() {
        super.sort();
        return this;
    }

    public DoubleGradient fade(double fromMult, float startTime, double toMult, float endTime) {
        double start = (Double)this.getValue(startTime);
        double end = (Double)this.getValue(endTime);
        this.addPoint(start, startTime);
        this.addPoint(end, endTime);
        for (BaseGradient.GradientPoint i : this.points) {
            float progress = (i.time - startTime) / (endTime - startTime);
            double mult = fromMult + (toMult - fromMult) * (double)progress;
            if (i.time > endTime) {
                mult = toMult;
            } else if (i.time < startTime) {
                mult = fromMult;
            }
            BaseGradient.GradientPoint gradientPoint = i;
            Double.valueOf((Double)gradientPoint.value * mult);
            gradientPoint.value = gradientPoint.value;
        }
        this.sort();
        return this;
    }

    public DoubleGradient fade(double fromMult, double toMult) {
        return this.fade(fromMult, this.startTime, toMult, this.endTime);
    }

    public static DoubleGradient singleValue(Double value) {
        return new DoubleGradient(value, 0.0f, value, 1.0f);
    }
}

