/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.misc.BaseGradient;
import org.joml.Math;

public class FloatGradient
extends BaseGradient<Float> {
    public FloatGradient(Float start, float startTime, Float end, float endTime) {
        super(start, startTime, end, endTime);
    }

    public FloatGradient(Float start, Float end) {
        super(start, end);
    }

    @Override
    public Float blend(Float from, Float to, float progress) {
        return Float.valueOf(Math.lerp((float)from.floatValue(), (float)to.floatValue(), (float)progress));
    }

    public FloatGradient addPoint(Float value, float time) {
        super.addPoint(value, time);
        return this;
    }

    public FloatGradient addPoint(Float value, float time, boolean instant) {
        super.addPoint(value, time, instant);
        return this;
    }

    public FloatGradient sort() {
        super.sort();
        return this;
    }

    public FloatGradient fade(float fromMult, float startTime, float toMult, float endTime) {
        float start = ((Float)this.getValue(startTime)).floatValue();
        float end = ((Float)this.getValue(endTime)).floatValue();
        this.addPoint(Float.valueOf(start), startTime);
        this.addPoint(Float.valueOf(end), endTime);
        for (BaseGradient.GradientPoint i : this.points) {
            float progress = (i.time - startTime) / (endTime - startTime);
            float mult = fromMult + (toMult - fromMult) * progress;
            if (i.time > endTime) {
                mult = toMult;
            } else if (i.time < startTime) {
                mult = fromMult;
            }
            BaseGradient.GradientPoint gradientPoint = i;
            Float.valueOf(((Float)gradientPoint.value).floatValue() * mult);
            gradientPoint.value = gradientPoint.value;
        }
        this.sort();
        return this;
    }

    public FloatGradient fade(float fromMult, float toMult) {
        return this.fade(fromMult, this.startTime, toMult, this.endTime);
    }

    public static FloatGradient singleValue(Float value) {
        return new FloatGradient(value, 0.0f, value, 1.0f);
    }
}

