/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.misc;

import com.cmdpro.databank.mixin.client.ChannelHandleMixin;
import com.cmdpro.databank.mixin.client.ChannelMixin;
import com.cmdpro.databank.mixin.client.SoundEngineMixin;
import com.cmdpro.databank.mixin.client.SoundManagerMixin;
import com.mojang.blaze3d.audio.Channel;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.ChannelAccess;
import net.minecraft.client.sounds.SoundEngine;
import org.lwjgl.openal.AL10;

public class SoundUtil {
    private static SoundEngine getSoundEngine() {
        return ((SoundManagerMixin)Minecraft.getInstance().getSoundManager()).getSoundEngine();
    }

    public static ChannelAccess.ChannelHandle getChannelHandle(SoundInstance instance) {
        return ((SoundEngineMixin)SoundUtil.getSoundEngine()).getInstanceToChannel().get(instance);
    }

    public static int getSource(Channel channel) {
        return ((ChannelMixin)channel).getSource();
    }

    public static void setTime(SoundInstance instance, float time) {
        ChannelAccess.ChannelHandle handle = SoundUtil.getChannelHandle(instance);
        if (handle != null) {
            handle.execute(channel -> {
                int source = SoundUtil.getSource(channel);
                AL10.alSourcef((int)source, (int)4132, (float)time);
                AL10.alGetSourcef((int)source, (int)4132);
            });
        }
    }

    public static float getTime(SoundInstance instance) {
        Channel channel = SoundUtil.getChannel(instance);
        if (channel != null) {
            return AL10.alGetSourcef((int)SoundUtil.getSource(channel), (int)4132);
        }
        return -1.0f;
    }

    public static void modifySound(SoundInstance instance, Consumer<Channel> consumer) {
        SoundUtil.getChannelHandle(instance).execute(consumer);
    }

    public static Channel getChannel(SoundInstance instance) {
        return ((ChannelHandleMixin)SoundUtil.getChannelHandle(instance)).getChannel();
    }
}

