/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.multiblock;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.multiblock.Multiblock;
import com.cmdpro.databank.multiblock.MultiblockSerializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;

public class MultiblockManager
extends SimpleJsonResourceReloadListener {
    protected static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    public static MultiblockManager instance;
    public static Map<ResourceLocation, Multiblock> multiblocks;
    public static MultiblockSerializer serializer;

    protected MultiblockManager() {
        super(GSON, "databank/multiblocks");
    }

    public static MultiblockManager getOrCreateInstance() {
        if (instance == null) {
            instance = new MultiblockManager();
        }
        return instance;
    }

    protected void apply(Map<ResourceLocation, JsonElement> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        multiblocks = new HashMap<ResourceLocation, Multiblock>();
        Databank.LOGGER.info("[DATABANK] Adding Databank Multiblocks");
        for (Map.Entry<ResourceLocation, JsonElement> i : pObject.entrySet()) {
            ResourceLocation location = i.getKey();
            if (location.getPath().startsWith("_")) continue;
            try {
                Multiblock multiblock = serializer.read(i.getKey(), i.getValue().getAsJsonObject());
                if (multiblock == null) continue;
                multiblocks.put(i.getKey(), multiblock);
            }
            catch (JsonParseException | IllegalArgumentException e) {
                Databank.LOGGER.error("[DATABANK ERROR] Parsing error loading multiblock {}", (Object)location, (Object)e);
            }
        }
        Databank.LOGGER.info("[DATABANK] Loaded {} multiblocks", (Object)multiblocks.size());
    }

    static {
        multiblocks = new HashMap<ResourceLocation, Multiblock>();
        serializer = new MultiblockSerializer();
    }
}

