/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking;

import com.cmdpro.databank.networking.Message;
import com.cmdpro.databank.networking.packet.HiddenSyncS2CPacket;
import com.cmdpro.databank.networking.packet.LockAdvancementS2CPacket;
import com.cmdpro.databank.networking.packet.MultiblockSyncS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockAdvancementS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockHiddenSyncS2CPacket;
import com.cmdpro.databank.networking.packet.UnlockedHiddenSyncS2CPacket;
import com.cmdpro.databank.networking.packet.WorldGuiInteractC2SPacket;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.LogicalSide;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;

@EventBusSubscriber(modid="databank", bus=EventBusSubscriber.Bus.MOD)
public class ModMessages {
    @SubscribeEvent
    public static void register(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("databank").versioned("1.0");
        registrar.playToClient(UnlockedHiddenSyncS2CPacket.TYPE, ModMessages.getNetworkCodec(UnlockedHiddenSyncS2CPacket::read, UnlockedHiddenSyncS2CPacket::write), Handler::handle);
        registrar.playToClient(UnlockHiddenSyncS2CPacket.TYPE, ModMessages.getNetworkCodec(UnlockHiddenSyncS2CPacket::read, UnlockHiddenSyncS2CPacket::write), Handler::handle);
        registrar.playToClient(HiddenSyncS2CPacket.TYPE, ModMessages.getNetworkCodec(HiddenSyncS2CPacket::read, HiddenSyncS2CPacket::write), Handler::handle);
        registrar.playToClient(MultiblockSyncS2CPacket.TYPE, ModMessages.getNetworkCodec(MultiblockSyncS2CPacket::read, MultiblockSyncS2CPacket::write), Handler::handle);
        registrar.playToClient(LockAdvancementS2CPacket.TYPE, ModMessages.getNetworkCodec(LockAdvancementS2CPacket::read, LockAdvancementS2CPacket::write), Handler::handle);
        registrar.playToClient(UnlockAdvancementS2CPacket.TYPE, ModMessages.getNetworkCodec(UnlockAdvancementS2CPacket::read, UnlockAdvancementS2CPacket::write), Handler::handle);
        registrar.playToServer(WorldGuiInteractC2SPacket.TYPE, ModMessages.getNetworkCodec(WorldGuiInteractC2SPacket::read, WorldGuiInteractC2SPacket::write), Handler::handle);
    }

    public static <T extends Message> StreamCodec<RegistryFriendlyByteBuf, T> getNetworkCodec(Handler.Reader<T> reader, Handler.Writer<T> writer) {
        return StreamCodec.of(writer::write, reader::read);
    }

    public static <T extends Message> void sendToServer(T message) {
        PacketDistributor.sendToServer(message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends Message> void sendToPlayer(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayer((ServerPlayer)player, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public static <T extends Message> void sendToPlayersTrackingEntityAndSelf(T message, ServerPlayer player) {
        PacketDistributor.sendToPlayersTrackingEntityAndSelf((Entity)player, message, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    public class Handler {
        public Handler(ModMessages this$0) {
        }

        public static <T extends CustomPacketPayload> void handle(T message, IPayloadContext ctx) {
            if (message instanceof Message) {
                Message msg = (Message)message;
                if (ctx.flow().getReceptionSide() == LogicalSide.SERVER) {
                    ctx.enqueueWork(() -> Server.handle(msg, ctx));
                } else {
                    ctx.enqueueWork(() -> Client.handle(msg, ctx));
                }
            }
        }

        public class Client {
            public Client(Handler this$1) {
            }

            public static <T extends Message> void handle(T message, IPayloadContext ctx) {
                message.handleClient(Minecraft.getInstance(), (Player)Minecraft.getInstance().player, ctx);
            }
        }

        public class Server {
            public Server(Handler this$1) {
            }

            public static <T extends Message> void handle(T message, IPayloadContext ctx) {
                message.handleServer(ctx.player().getServer(), (ServerPlayer)ctx.player(), ctx);
            }
        }

        public static interface Writer<T extends Message> {
            public void write(RegistryFriendlyByteBuf var1, T var2);
        }

        public static interface Reader<T extends Message> {
            public T read(RegistryFriendlyByteBuf var1);
        }
    }
}

