/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.networking.packet;

import com.cmdpro.databank.Databank;
import com.cmdpro.databank.DatabankRegistries;
import com.cmdpro.databank.hidden.Hidden;
import com.cmdpro.databank.hidden.HiddenManager;
import com.cmdpro.databank.hidden.HiddenSerializer;
import com.cmdpro.databank.hidden.HiddenTypeInstance;
import com.cmdpro.databank.networking.Message;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record HiddenSyncS2CPacket(Map<ResourceLocation, Hidden> hidden) implements Message
{
    public static final CustomPacketPayload.Type<HiddenSyncS2CPacket> TYPE = new CustomPacketPayload.Type(Databank.locate("hidden_block_sync"));

    public static HiddenSyncS2CPacket read(FriendlyByteBuf buf) {
        Map blocks = buf.readMap(FriendlyByteBuf::readResourceLocation, buf2 -> (Hidden)HiddenSerializer.STREAM_CODEC.decode((Object)((RegistryFriendlyByteBuf)buf2)));
        for (Map.Entry i : blocks.entrySet()) {
            ((Hidden)i.getValue()).id = (ResourceLocation)i.getKey();
        }
        return new HiddenSyncS2CPacket(blocks);
    }

    public static void write(FriendlyByteBuf buf, HiddenSyncS2CPacket obj) {
        buf.writeMap(obj.hidden, FriendlyByteBuf::writeResourceLocation, (buf2, val) -> HiddenSerializer.STREAM_CODEC.encode((Object)((RegistryFriendlyByteBuf)buf2), val));
    }

    public CustomPacketPayload.Type<HiddenSyncS2CPacket> type() {
        return TYPE;
    }

    @Override
    public void handleClient(Minecraft minecraft, Player player, IPayloadContext context) {
        context.enqueueWork(() -> {
            HiddenManager.hidden.clear();
            HiddenManager.hidden.putAll(this.hidden);
            for (HiddenTypeInstance.HiddenType i : DatabankRegistries.HIDDEN_TYPE_REGISTRY.stream().toList()) {
                i.updateClient();
                i.onRecieveClient();
            }
        });
    }
}

