/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.shaders;

import com.cmdpro.databank.shaders.PostShaderInstance;
import java.util.ArrayList;
import java.util.List;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT}, modid="databank")
public class PostShaderManager {
    public static Matrix4f viewStackMatrix;
    public static List<PostShaderInstance> instances;
    public static List<PostShaderInstance> removalQueue;

    public static void addShader(PostShaderInstance instance) {
        instances.add(instance);
    }

    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Pre event) {
        for (PostShaderInstance i : instances) {
            i.tick();
        }
        for (PostShaderInstance i : removalQueue) {
            instances.remove(i);
        }
        removalQueue.clear();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void onRenderLevelStage(RenderLevelStageEvent event) {
        for (PostShaderInstance i : instances) {
            if (!event.getStage().equals(i.getRenderStage())) continue;
            i.process();
        }
    }

    static {
        instances = new ArrayList<PostShaderInstance>();
        removalQueue = new ArrayList<PostShaderInstance>();
    }
}

