/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.databank.temperature;

import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;

public class TemperatureUtil {
    public static int ABSOLUTE_ZERO = -273;
    public static int WATER_BOILING_POINT = 100;

    public static int getAmbientTemperatureAt(BlockPos pos) {
        ClientLevel world = Minecraft.getInstance().level;
        float T = TemperatureUtil.getBiomeTemperature((Biome)world.getBiome(pos).value());
        T += world.dimension() == Level.NETHER ? (float)WATER_BOILING_POINT : 0.0f;
        if (world.canSeeSky(pos)) {
            float angle = world.getSunAngle(0.0f);
            float sunIntensity = Math.clamp((float)(1.0 * Math.cos(angle * 2.0f + 0.2f)), 0.0f, 1.0f);
            sunIntensity *= (float)(1.0 - (double)(world.getRainLevel(0.0f) * 5.0f) / 16.0);
            T += ((sunIntensity *= (float)(1.0 - (double)(world.getThunderLevel(0.0f) * 5.0f) / 16.0)) - 0.75f) * (float)(world.isRaining() ? 2 : 4);
        }
        int seaLevel = world.getSeaLevel();
        int y = pos.getY();
        int dy = y - seaLevel;
        return (int)(T -= (float)dy * 0.75f);
    }

    public static int getBiomeTemperature(Biome biome) {
        float factor = biome.getBaseTemperature();
        return (int)(30.0f * factor) - 10;
    }
}

