/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence;

import com.cmdpro.datanessence.config.DataNEssenceClientConfig;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.entity.AncientSentinel;
import com.cmdpro.datanessence.registry.EntityRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.config.ModConfigEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;

@EventBusSubscriber(modid="datanessence", bus=EventBusSubscriber.Bus.MOD)
public class ModEventBusEvents {
    @SubscribeEvent
    public static void entityAttributeEvent(EntityAttributeCreationEvent event) {
        event.put(EntityRegistry.ANCIENT_SENTINEL.get(), AncientSentinel.setAttributes());
    }

    @SubscribeEvent
    public static void onModConfigEvent(ModConfigEvent event) {
        ModConfig config = event.getConfig();
        if (config.getSpec() == DataNEssenceConfig.COMMON_SPEC) {
            DataNEssenceConfig.bake(config);
        }
        if (config.getSpec() == DataNEssenceClientConfig.CLIENT_SPEC) {
            DataNEssenceClientConfig.bake(config);
        }
    }

    @SubscribeEvent
    public static void entitySpawnRestriction(RegisterSpawnPlacementsEvent event) {
    }

    @SubscribeEvent
    public static void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ItemRegistry.ESSENCE_BOMB.get()));
            DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ItemRegistry.LUNAR_ESSENCE_BOMB.get()));
            DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ItemRegistry.NATURAL_ESSENCE_BOMB.get()));
            DispenserBlock.registerProjectileBehavior((ItemLike)((ItemLike)ItemRegistry.EXOTIC_ESSENCE_BOMB.get()));
        });
    }
}

