/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence;

import com.cmdpro.datanessence.api.block.RedirectorInteractable;
import com.cmdpro.datanessence.api.block.TraversiteBlock;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.item.AdjustableAttributes;
import com.cmdpro.datanessence.api.node.block.BaseCapabilityPoint;
import com.cmdpro.datanessence.api.node.block.BaseEssencePoint;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlock;
import com.cmdpro.datanessence.api.util.DataTabletUtil;
import com.cmdpro.datanessence.api.util.PlayerDataUtil;
import com.cmdpro.datanessence.block.technical.StructureProtector;
import com.cmdpro.datanessence.block.technical.StructureProtectorBlockEntity;
import com.cmdpro.datanessence.block.transportation.TraversiteRoad;
import com.cmdpro.datanessence.client.particle.MoteParticleOptions;
import com.cmdpro.datanessence.client.particle.RhombusParticleOptions;
import com.cmdpro.datanessence.client.particle.SmallCircleParticleOptions;
import com.cmdpro.datanessence.data.computers.ComputerTypeManager;
import com.cmdpro.datanessence.data.databank.DataBankEntryManager;
import com.cmdpro.datanessence.data.databank.DataBankTypeManager;
import com.cmdpro.datanessence.data.datatablet.DataTabManager;
import com.cmdpro.datanessence.data.datatablet.Entries;
import com.cmdpro.datanessence.data.datatablet.Entry;
import com.cmdpro.datanessence.data.datatablet.EntryManager;
import com.cmdpro.datanessence.data.pinging.PingableStructureManager;
import com.cmdpro.datanessence.item.equipment.EssenceMeter;
import com.cmdpro.datanessence.item.equipment.EssenceRedirector;
import com.cmdpro.datanessence.item.equipment.GrapplingHook;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.DragonPartsSync;
import com.cmdpro.datanessence.networking.packet.s2c.EntrySync;
import com.cmdpro.datanessence.networking.packet.s2c.GrapplingHookSync;
import com.cmdpro.datanessence.networking.packet.s2c.PingableSync;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.BlockRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import com.cmdpro.datanessence.registry.TagRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.ItemAttributeModifierEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.living.LivingDestroyBlockEvent;
import net.neoforged.neoforge.event.entity.player.AdvancementEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.entity.player.UseItemOnBlockEvent;
import net.neoforged.neoforge.event.level.BlockEvent;
import net.neoforged.neoforge.event.level.ExplosionEvent;
import net.neoforged.neoforge.event.tick.EntityTickEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

@EventBusSubscriber(modid="datanessence")
public class ModEvents {
    @SubscribeEvent
    public static void onLivingEntityTick(EntityTickEvent.Pre event) {
        Entity entity = event.getEntity();
        if (entity instanceof LivingEntity) {
            LivingEntity ent = (LivingEntity)entity;
            Block block = event.getEntity().getBlockStateOn().getBlock();
            if (block instanceof TraversiteBlock) {
                TraversiteBlock road = (TraversiteBlock)block;
                if (!ent.level().isClientSide) {
                    if (ent.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID) == null) {
                        ent.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID, (double)road.getBoost(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                    } else if (ent.getAttribute(Attributes.MOVEMENT_SPEED).getModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID).amount() != (double)road.getBoost()) {
                        ent.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID);
                        ent.getAttribute(Attributes.MOVEMENT_SPEED).addPermanentModifier(new AttributeModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID, (double)road.getBoost(), AttributeModifier.Operation.ADD_MULTIPLIED_BASE));
                    }
                } else {
                    ent.level().addParticle((ParticleOptions)new RhombusParticleOptions().setColor(new Color(-9784324)).setAdditive(true), ent.position().x, ent.position().y, ent.position().z, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f), 0.25, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f));
                    ent.level().addParticle((ParticleOptions)new MoteParticleOptions().setColor(new Color(-1)).setAdditive(true), ent.position().x, ent.position().y, ent.position().z, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f), 0.25, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f));
                    ent.level().addParticle((ParticleOptions)new SmallCircleParticleOptions().setColor(new Color(-224581)).setAdditive(true), ent.position().x, ent.position().y, ent.position().z, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f), 0.25, (double)Mth.nextFloat((RandomSource)ent.getRandom(), (float)-0.25f, (float)0.25f));
                }
            } else if (!ent.level().isClientSide) {
                ent.getAttribute(Attributes.MOVEMENT_SPEED).removeModifier(TraversiteRoad.TRAVERSITE_ROAD_SPEED_UUID);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getLevel().isClientSide() && !event.getLevel().getBlockState(event.getPos()).is(BlockRegistry.STRUCTURE_PROTECTOR.get())) {
            ((Optional)event.getEntity().getData(AttachmentTypeRegistry.BINDING_STRUCTURE_CONTROLLER)).ifPresent(binding -> {
                if (binding.getLevel() != null) {
                    if (binding.bindProcess == 1) {
                        event.getEntity().sendSystemMessage((Component)Component.translatable((String)"block.datanessence.structure_protector.select_pos_2"));
                        binding.offsetCorner1 = event.getPos().offset((Vec3i)binding.getBlockPos().multiply(-1));
                        binding.getLevel().setBlock(binding.getBlockPos(), (BlockState)binding.getBlockState().setValue((Property)StructureProtector.FACING, (Comparable)Direction.NORTH), 3);
                        binding.bindProcess = 2;
                        binding.updateBlock();
                    } else if (binding.bindProcess == 2 && !binding.offsetCorner1.offset((Vec3i)binding.getBlockPos()).equals((Object)event.getPos())) {
                        binding.offsetCorner2 = event.getPos().offset((Vec3i)binding.getBlockPos().multiply(-1));
                        binding.getLevel().setBlock(binding.getBlockPos(), (BlockState)binding.getBlockState().setValue((Property)StructureProtector.FACING, (Comparable)Direction.NORTH), 3);
                        binding.bindProcess = 0;
                        event.getEntity().sendSystemMessage((Component)Component.translatable((String)"block.datanessence.structure_protector.finished"));
                        event.getEntity().removeData(AttachmentTypeRegistry.BINDING_STRUCTURE_CONTROLLER);
                        binding.updateBlock();
                    }
                } else {
                    event.getEntity().removeData(AttachmentTypeRegistry.BINDING_STRUCTURE_CONTROLLER);
                }
            });
        }
    }

    @SubscribeEvent
    public static void useItemOnBlockEvent(UseItemOnBlockEvent event) {
        if (event.getUsePhase() == UseItemOnBlockEvent.UsePhase.BLOCK) {
            if (event.getItemStack().getItem() instanceof EssenceMeter && event.getLevel().getBlockEntity(event.getPos()) instanceof EssenceBlockEntity) {
                event.cancelWithResult(ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION);
            }
            if (event.getItemStack().getItem() instanceof EssenceRedirector && event.getLevel().getBlockState(event.getPos()).getBlock() instanceof RedirectorInteractable) {
                event.cancelWithResult(ItemInteractionResult.SKIP_DEFAULT_BLOCK_INTERACTION);
            }
        }
    }

    @SubscribeEvent
    public static void preventBreakingProtectedBlocks(BlockEvent.BreakEvent event) {
        if (!event.getPlayer().isCreative() && !event.getLevel().getBlockState(event.getPos()).is(TagRegistry.Blocks.STRUCTURE_PROTECTOR_IGNORED) && !event.getLevel().isClientSide() && ((Level)event.getLevel()).hasData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)) {
            List ents = (List)((Level)event.getLevel()).getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS);
            for (StructureProtectorBlockEntity i : ents) {
                AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)i.getCorner1(), (BlockPos)i.getCorner2());
                if (!aabb.contains(event.getPos().getCenter())) continue;
                event.setCanceled(true);
                event.getLevel().playSound(null, event.getPos(), (SoundEvent)SoundRegistry.STRUCTURE_PROTECTOR_REFRESH.value(), SoundSource.BLOCKS, 1.0f, ((Level)event.getLevel()).random.nextFloat());
                break;
            }
        }
    }

    @SubscribeEvent
    public static void preventPlacingInProtectedZone(BlockEvent.EntityPlaceEvent event) {
        Player player;
        boolean creative;
        Entity entity = event.getEntity();
        boolean bl = creative = entity instanceof Player && (player = (Player)entity).isCreative();
        if (!creative && !event.getLevel().isClientSide() && !event.getPlacedBlock().is(TagRegistry.Blocks.STRUCTURE_PROTECTOR_IGNORED) && ((Level)event.getLevel()).hasData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)) {
            List ents = (List)((Level)event.getLevel()).getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS);
            for (StructureProtectorBlockEntity i : ents) {
                AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)i.getCorner1(), (BlockPos)i.getCorner2());
                if (!aabb.contains(event.getPos().getCenter())) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onExplosion(ExplosionEvent.Detonate event) {
        if (!event.getLevel().isClientSide() && event.getLevel().hasData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)) {
            List ents = (List)event.getLevel().getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS);
            ArrayList<BlockPos> toRemove = new ArrayList<BlockPos>();
            block0: for (BlockPos i : event.getExplosion().getToBlow()) {
                for (StructureProtectorBlockEntity o : ents) {
                    AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)o.getCorner1(), (BlockPos)o.getCorner2());
                    if (!aabb.contains(i.getCenter())) continue;
                    toRemove.add(i);
                    continue block0;
                }
            }
            event.getExplosion().getToBlow().removeAll(toRemove);
        }
    }

    @SubscribeEvent
    public static void onBlockDestroy(LivingDestroyBlockEvent event) {
        Player player;
        boolean creative = false;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).isCreative()) {
            creative = true;
        }
        if (!creative && !event.getEntity().level().isClientSide() && event.getEntity().level().hasData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS)) {
            List ents = (List)event.getEntity().level().getData(AttachmentTypeRegistry.STRUCTURE_CONTROLLERS);
            for (StructureProtectorBlockEntity i : ents) {
                AABB aabb = AABB.encapsulatingFullBlocks((BlockPos)i.getCorner1(), (BlockPos)i.getCorner2());
                if (!aabb.contains(event.getPos().getCenter())) continue;
                event.setCanceled(true);
                break;
            }
        }
    }

    @SubscribeEvent
    public static void playerStartTracking(PlayerEvent.StartTracking evt) {
        Entity target = evt.getTarget();
        Player player = evt.getEntity();
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (target instanceof Player) {
                Player targetPlayer = (Player)target;
                ModMessages.sendToPlayer(new DragonPartsSync(target.getId(), (Boolean)targetPlayer.getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)targetPlayer.getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)targetPlayer.getData(AttachmentTypeRegistry.HAS_WINGS)), serverPlayer);
                ModMessages.sendToPlayer(new GrapplingHookSync(target.getId(), ((Optional)targetPlayer.getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).orElse(null)), serverPlayer);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(PlayerTickEvent.Pre event) {
        if (!event.getEntity().level().isClientSide) {
            Optional ent = (Optional)event.getEntity().getData(AttachmentTypeRegistry.LINK_FROM);
            if (ent.isPresent()) {
                Block block;
                Block block2 = ((BlockEntity)ent.get()).getBlockState().getBlock();
                if (block2 instanceof BaseEssencePoint) {
                    block = (BaseEssencePoint)block2;
                    if (!event.getEntity().isHolding(block.getRequiredWire())) {
                        event.getEntity().setData(AttachmentTypeRegistry.LINK_FROM, Optional.empty());
                        PlayerDataUtil.updateData((ServerPlayer)event.getEntity());
                    }
                }
                if ((block2 = ((BlockEntity)ent.get()).getBlockState().getBlock()) instanceof BaseCapabilityPoint) {
                    block = (BaseCapabilityPoint)block2;
                    if (!event.getEntity().isHolding(block.getRequiredWire())) {
                        event.getEntity().setData(AttachmentTypeRegistry.LINK_FROM, Optional.empty());
                        PlayerDataUtil.updateData((ServerPlayer)event.getEntity());
                    }
                }
                if ((block2 = ((BlockEntity)ent.get()).getBlockState().getBlock()) instanceof PearlNetworkBlock) {
                    block = (PearlNetworkBlock)block2;
                    if (!event.getEntity().isHolding(PearlNetworkBlock.getLinkItem())) {
                        event.getEntity().setData(AttachmentTypeRegistry.LINK_FROM, Optional.empty());
                        PlayerDataUtil.updateData((ServerPlayer)event.getEntity());
                    }
                }
            }
            if (((Optional)event.getEntity().getData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA)).isPresent()) {
                event.getEntity().resetFallDistance();
                if (!event.getEntity().isHolding(stack -> stack.getItem() instanceof GrapplingHook)) {
                    event.getEntity().setData(AttachmentTypeRegistry.GRAPPLING_HOOK_DATA, Optional.empty());
                    ModMessages.sendToPlayersTrackingEntityAndSelf(new GrapplingHookSync(event.getEntity().getId(), null), (ServerPlayer)event.getEntity());
                }
            }
        }
    }

    @SubscribeEvent
    public static void addReloadListenerEvent(AddReloadListenerEvent event) {
        event.addListener((PreparableReloadListener)EntryManager.getOrCreateInstance());
        event.addListener((PreparableReloadListener)DataTabManager.getOrCreateInstance());
        event.addListener((PreparableReloadListener)DataBankEntryManager.getOrCreateInstance());
        event.addListener((PreparableReloadListener)DataBankTypeManager.getOrCreateInstance());
        event.addListener((PreparableReloadListener)ComputerTypeManager.getOrCreateInstance());
        event.addListener((PreparableReloadListener)PingableStructureManager.getOrCreateInstance());
    }

    @SubscribeEvent
    public static void onDatapackSync(OnDatapackSyncEvent event) {
        if (event.getPlayer() == null) {
            for (ServerPlayer player : event.getPlayerList().getPlayers()) {
                ModEvents.syncToPlayer(player);
                ModMessages.sendToPlayersTrackingEntityAndSelf(new DragonPartsSync(player.getId(), (Boolean)player.getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)player.getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)player.getData(AttachmentTypeRegistry.HAS_WINGS)), player);
            }
        } else {
            ModEvents.syncToPlayer(event.getPlayer());
            ModMessages.sendToPlayer(new DragonPartsSync(event.getPlayer().getId(), (Boolean)event.getPlayer().getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)event.getPlayer().getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)event.getPlayer().getData(AttachmentTypeRegistry.HAS_WINGS)), event.getPlayer());
        }
    }

    protected static void syncToPlayer(ServerPlayer player) {
        ModMessages.sendToPlayer(new EntrySync(Entries.entries, Entries.tabsSorted.stream().map(i -> i.id).toList(), Entries.tabs), player);
        ModMessages.sendToPlayer(new PingableSync(PingableStructureManager.types), player);
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().isClientSide() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            ModMessages.sendToPlayer(new DragonPartsSync(player.getId(), (Boolean)player.getData(AttachmentTypeRegistry.HAS_HORNS), (Boolean)player.getData(AttachmentTypeRegistry.HAS_TAIL), (Boolean)player.getData(AttachmentTypeRegistry.HAS_WINGS)), player);
            PlayerDataUtil.updateData(player);
            PlayerDataUtil.updateUnlockedEntries(player);
            PlayerDataUtil.sendTier(player, false);
        }
    }

    @SubscribeEvent
    public static void onPlayerAdvancement(AdvancementEvent.AdvancementEarnEvent event) {
        ArrayList<Entry> entries = new ArrayList<Entry>();
        for (Map.Entry entry : ((HashMap)event.getEntity().getData(AttachmentTypeRegistry.INCOMPLETE_STAGES)).entrySet()) {
            Entry entry2 = Entries.entries.get(entry.getKey());
            if (!entry2.completionStages.get((int)entry2.getIncompleteStageServer((Player)event.getEntity())).completionAdvancements.contains(event.getAdvancement().id())) continue;
            entries.add(entry2);
        }
        for (Entry entry : entries) {
            DataTabletUtil.unlockEntry(event.getEntity(), entry.id, entry.getIncompleteStageServer(event.getEntity()) + 1);
        }
    }

    @SubscribeEvent
    public static void adjustItemAttributes(ItemAttributeModifierEvent event) {
        Item item = event.getItemStack().getItem();
        if (item instanceof AdjustableAttributes) {
            AdjustableAttributes item2 = (AdjustableAttributes)item;
            item2.adjustAttributes(event);
        }
    }
}

