/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.ItemStackHandler;

public class LockableItemHandler
extends ItemStackHandler {
    public HashMap<Integer, ItemStack> lockedSlots = new HashMap();
    public boolean locked;

    public LockableItemHandler(int size) {
        super(size);
    }

    public LockableItemHandler(NonNullList<ItemStack> stacks) {
        super(stacks);
    }

    public CompoundTag serializeNBT(HolderLookup.Provider provider) {
        CompoundTag tag = super.serializeNBT(provider);
        ListTag locked = new ListTag();
        for (Map.Entry<Integer, ItemStack> i : this.lockedSlots.entrySet()) {
            CompoundTag tag2 = new CompoundTag();
            tag2.putInt("key", i.getKey().intValue());
            tag2.put("value", i.getValue().save(provider));
            locked.add((Object)tag2);
        }
        tag.put("locked", (Tag)locked);
        tag.putBoolean("isLocked", this.locked);
        return tag;
    }

    public void setLockedSlots() {
        int o = 0;
        for (ItemStack i : this.stacks) {
            if (!i.isEmpty()) {
                this.lockedSlots.put(o, i.copy());
            }
            ++o;
        }
    }

    public void clearLockedSlots() {
        this.lockedSlots.clear();
    }

    public boolean canInsertFromBuffer(int slot, ItemStack stack) {
        if (this.locked) {
            if (this.lockedSlots.containsKey(slot)) {
                ItemStack locked = this.lockedSlots.get(slot);
                if (ItemStack.isSameItem((ItemStack)stack, (ItemStack)locked)) {
                    return super.isItemValid(slot, stack);
                }
                return false;
            }
            return false;
        }
        return super.isItemValid(slot, stack);
    }

    public void setLocked(boolean locked) {
        this.locked = locked;
    }

    public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
        super.deserializeNBT(provider, nbt);
        this.lockedSlots.clear();
        if (nbt.contains("locked")) {
            ListTag locked = (ListTag)nbt.get("locked");
            for (Tag i : locked) {
                CompoundTag tag = (CompoundTag)i;
                this.lockedSlots.put(tag.getInt("key"), ItemStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tag.getCompound("value")));
            }
        }
        if (nbt.contains("isLocked")) {
            this.locked = nbt.getBoolean("isLocked");
        }
    }
}

