/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api;

import java.util.Iterator;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;
import net.neoforged.neoforge.fluids.capability.templates.FluidTank;

public class MultiFluidTank
implements IFluidHandler {
    private List<FluidTank> tanks;

    public MultiFluidTank(List<FluidTank> tanks) {
        this.tanks = tanks;
    }

    public int getTanks() {
        return this.tanks.size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.tanks.get(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.tanks.get(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.tanks.get(tank).isFluidValid(stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack remaining = resource.copy();
        for (FluidTank i : this.tanks) {
            remaining.setAmount(remaining.getAmount() - i.fill(remaining, action));
            if (remaining.getAmount() > 0) continue;
            break;
        }
        return resource.getAmount() - remaining.getAmount();
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        FluidStack remaining = resource.copy();
        for (FluidTank i : this.tanks) {
            remaining.setAmount(remaining.getAmount() - i.drain(remaining, action).getAmount());
            if (remaining.getAmount() > 0) continue;
            break;
        }
        remaining.setAmount(resource.getAmount() - remaining.getAmount());
        return remaining;
    }

    public MultiFluidTank readFromNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        int o = 0;
        for (Tag i : nbt.getList("tanks", 10)) {
            this.tanks.get(o).readFromNBT(lookupProvider, (CompoundTag)i);
            ++o;
        }
        return this;
    }

    public CompoundTag writeToNBT(HolderLookup.Provider lookupProvider, CompoundTag nbt) {
        ListTag tag = new ListTag();
        for (FluidTank i : this.tanks) {
            tag.add((Object)i.writeToNBT(lookupProvider, new CompoundTag()));
        }
        nbt.put("tanks", (Tag)tag);
        return nbt;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        FluidTank i;
        FluidStack drain;
        int remaining = maxDrain;
        FluidStack drainStack = FluidStack.EMPTY;
        Iterator<FluidTank> iterator = this.tanks.iterator();
        while (iterator.hasNext() && (remaining -= (drain = (i = iterator.next()).drain(maxDrain, action)).getAmount()) > 0) {
        }
        remaining = maxDrain - remaining;
        drainStack.setAmount(remaining);
        return drainStack;
    }
}

