/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.block;

import com.cmdpro.datanessence.api.util.DataBankUtil;
import com.cmdpro.datanessence.item.DataTablet;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public abstract class BaseDataBankBlock
extends Block {
    public BaseDataBankBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide && this.isOkayToOpen(pState, pLevel, pPos, pPlayer, pHitResult)) {
            if (this.canUse(pState, pLevel, pPos, pPlayer, pHitResult)) {
                DataBankUtil.sendDataBankEntries(pPlayer, this.getEntries(pState, pLevel, pPos, pPlayer, pHitResult));
            } else {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"block.datanessence.data_bank.cannot_use"), true);
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public boolean canUse(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        return pPlayer.getInventory().contains(stack -> stack.getItem() instanceof DataTablet);
    }

    public boolean isOkayToOpen(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        return true;
    }

    public abstract ResourceLocation[] getEntries(BlockState var1, Level var2, BlockPos var3, Player var4, BlockHitResult var5);
}

