/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.block;

import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.essence.container.MultiEssenceContainer;
import com.cmdpro.datanessence.api.util.BufferUtil;
import com.cmdpro.datanessence.api.util.DataTabletUtil;
import com.cmdpro.datanessence.recipe.IFabricationRecipe;
import com.cmdpro.datanessence.recipe.NonMenuCraftingContainer;
import com.cmdpro.datanessence.registry.RecipeRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingInput;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;

public abstract class BaseFabricatorBlockEntity
extends BlockEntity
implements EssenceBlockEntity {
    public MultiEssenceContainer storage = new MultiEssenceContainer(this.getSupportedEssenceTypes(), this.getMaxEssence());
    private final ItemStackHandler itemHandler = new ItemStackHandler(9){

        protected void onContentsChanged(int slot) {
            BaseFabricatorBlockEntity.this.setChanged();
            BaseFabricatorBlockEntity.this.checkRecipes();
        }

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            if (slot == 9) {
                return false;
            }
            return super.isItemValid(slot, stack);
        }
    };
    private ClientHandler clientHandler;
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});
    public ItemStack item = ItemStack.EMPTY;
    public int time;
    public int maxTime;
    public Recipe<CraftingInput> recipe;
    public boolean enoughEssence;
    public Map<ResourceLocation, Float> essenceCost;

    @Override
    public EssenceStorage getStorage() {
        return this.storage;
    }

    public void onLoad() {
        super.onLoad();
        if (this.level.isClientSide) {
            this.clientHandler = new ClientHandler();
            this.clientHandler.createWorkingSound(this.getBlockPos());
        } else {
            this.checkRecipes();
        }
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public void checkRecipes() {
        Optional recipe = this.level.getRecipeManager().getRecipeFor(RecipeRegistry.FABRICATIONCRAFTING.get(), (RecipeInput)this.getCraftingInv().asCraftInput(), this.level);
        if (recipe.isPresent()) {
            this.recipe = ((RecipeHolder)recipe.get()).value();
            this.essenceCost = ((IFabricationRecipe)((RecipeHolder)recipe.get()).value()).getEssenceCost();
            this.item = ((IFabricationRecipe)((RecipeHolder)recipe.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
            this.maxTime = ((IFabricationRecipe)((RecipeHolder)recipe.get()).value()).getTime();
        } else {
            Optional recipe2 = this.level.getRecipeManager().getRecipeFor(RecipeType.CRAFTING, (RecipeInput)this.getCraftingInv().asCraftInput(), this.level);
            if (recipe2.isPresent()) {
                this.recipe = ((RecipeHolder)recipe2.get()).value();
                this.item = ((CraftingRecipe)((RecipeHolder)recipe2.get()).value()).getResultItem((HolderLookup.Provider)this.level.registryAccess());
                this.essenceCost = null;
            } else {
                this.recipe = null;
                this.essenceCost = null;
                this.item = ItemStack.EMPTY;
            }
            this.maxTime = 20;
        }
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public abstract List<EssenceType> getSupportedEssenceTypes();

    public abstract float getMaxEssence();

    public BaseFabricatorBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.storage.fromNbt(tag.getCompound("EssenceStorage"));
        this.item = ItemStack.parseOptional((HolderLookup.Provider)pRegistries, (CompoundTag)tag.getCompound("item"));
        this.time = tag.getInt("time");
        this.maxTime = tag.getInt("maxTime");
        if (tag.contains("essenceCost")) {
            CompoundTag cost = tag.getCompound("essenceCost");
            this.essenceCost = new HashMap<ResourceLocation, Float>();
            for (String i : cost.getAllKeys()) {
                ResourceLocation location = ResourceLocation.tryParse((String)i);
                this.essenceCost.put(location, Float.valueOf(cost.getFloat(i)));
            }
        } else {
            this.essenceCost = null;
        }
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.put("item", this.item.saveOptional(pRegistries));
        tag.putInt("time", this.time);
        tag.putInt("maxTime", this.maxTime);
        if (this.essenceCost != null) {
            CompoundTag cost = new CompoundTag();
            for (Map.Entry<ResourceLocation, Float> i : this.essenceCost.entrySet()) {
                cost.putFloat(i.getKey().toString(), i.getValue().floatValue());
            }
            tag.put("essenceCost", (Tag)cost);
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        tag.put("EssenceStorage", (Tag)this.storage.toNbt());
        tag.putInt("time", this.time);
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
        this.storage.fromNbt(nbt.getCompound("EssenceStorage"));
        this.time = nbt.getInt("time");
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public CraftingContainer getCraftingInv() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>();
        for (int i = 0; i < 9; ++i) {
            items.add(this.itemHandler.getStackInSlot(i));
        }
        NonMenuCraftingContainer inventory = new NonMenuCraftingContainer(items, 3, 3);
        return inventory;
    }

    public static InteractionResult use(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand) {
        BlockEntity blockEntity = pLevel.getBlockEntity(pPos);
        if (!pLevel.isClientSide && blockEntity instanceof BaseFabricatorBlockEntity) {
            BaseFabricatorBlockEntity ent = (BaseFabricatorBlockEntity)blockEntity;
            if (ent.time >= 0) {
                ent.time = -1;
            } else if (ent.recipe != null) {
                if (ent.enoughEssence) {
                    IFabricationRecipe fabricationRecipe = null;
                    if (ent.recipe instanceof IFabricationRecipe) {
                        fabricationRecipe = (IFabricationRecipe)ent.recipe;
                    }
                    if (fabricationRecipe == null || DataTabletUtil.playerHasEntry(pPlayer, fabricationRecipe.getEntry(), fabricationRecipe.getCompletionStage())) {
                        ent.time = 0;
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.FABRICATOR_START.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
                    } else {
                        pPlayer.sendSystemMessage((Component)Component.translatable((String)"block.datanessence.fabricator.dont_know_how"));
                    }
                } else {
                    pPlayer.sendSystemMessage((Component)Component.translatable((String)"block.datanessence.fabricator.not_enough_essence"));
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public void tryCraft() {
        CraftingInput craftingInput = this.getCraftingInv().asCraftInput();
        ItemStack result = this.recipe.assemble((RecipeInput)craftingInput, (HolderLookup.Provider)this.level.registryAccess()).copy();
        NonNullList remaining = this.recipe.getRemainingItems((RecipeInput)craftingInput);
        int left = this.getCraftingInv().asPositionedCraftInput().left();
        int top = this.getCraftingInv().asPositionedCraftInput().top();
        int craftWidth = 3;
        if (this.essenceCost != null) {
            for (Map.Entry<ResourceLocation, Float> cost : this.essenceCost.entrySet()) {
                EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(cost.getKey());
                this.storage.removeEssence(type, cost.getValue().floatValue());
            }
        }
        for (int k = 0; k < craftingInput.height(); ++k) {
            for (int l = 0; l < craftingInput.width(); ++l) {
                int i1 = l + left + (k + top) * craftWidth;
                ItemStack existingItem = this.itemHandler.getStackInSlot(i1);
                ItemStack remainderItem = (ItemStack)remaining.get(l + k * craftingInput.width());
                if (!existingItem.isEmpty()) {
                    this.itemHandler.extractItem(i1, 1, false);
                    existingItem = this.itemHandler.getStackInSlot(i1);
                }
                if (!existingItem.isEmpty()) {
                    ItemEntity entity = new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 1.0f), (double)((float)this.getBlockPos().getZ() + 0.5f), remainderItem);
                    this.level.addFreshEntity((Entity)entity);
                    continue;
                }
                this.itemHandler.insertItem(i1, remainderItem, false);
            }
        }
        ItemEntity entity = new ItemEntity(this.level, (double)((float)this.getBlockPos().getX() + 0.5f), (double)((float)this.getBlockPos().getY() + 1.0f), (double)((float)this.getBlockPos().getZ() + 0.5f), result);
        this.level.addFreshEntity((Entity)entity);
        this.level.playSound(null, this.getBlockPos(), (SoundEvent)SoundRegistry.FABRICATOR_CRAFT.value(), SoundSource.BLOCKS, 2.0f, 1.0f);
    }

    public boolean isNotTryingToCraftBrokenRecipe() {
        boolean isBroken;
        boolean bl = isBroken = this.recipe.getResultItem((HolderLookup.Provider)this.level.registryAccess()).isEmpty() || this.recipe.getIngredients().stream().allMatch(Ingredient::hasNoItems);
        if (isBroken && !this.level.isClientSide) {
            DataNEssence.LOGGER.warn("[DATANESSENCE] Fabricator at {}, {}, {} is trying to craft \"{}\", which has an erroneously empty ingredient list or result! It is highly advised to correct or remove this recipe to prevent further errors.", new Object[]{this.worldPosition.getX(), this.worldPosition.getY(), this.worldPosition.getZ(), this.recipe});
        }
        return !isBroken;
    }

    public void tick(Level world, BlockPos pPos, BlockState pState, BaseFabricatorBlockEntity fabricator) {
        if (!world.isClientSide()) {
            BufferUtil.getEssenceFromBuffersBelow((BlockEntity)fabricator, fabricator.getSupportedEssenceTypes());
            if (fabricator.recipe != null && this.isNotTryingToCraftBrokenRecipe()) {
                boolean enoughEssence = true;
                if (fabricator.essenceCost != null) {
                    for (Map.Entry<ResourceLocation, Float> i : fabricator.essenceCost.entrySet()) {
                        EssenceType type = (EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(i.getKey());
                        if (!(fabricator.storage.getEssence(type) < i.getValue().floatValue())) continue;
                        enoughEssence = false;
                    }
                }
                fabricator.enoughEssence = enoughEssence;
                if (fabricator.recipe.matches((RecipeInput)fabricator.getCraftingInv().asCraftInput(), fabricator.level)) {
                    if (fabricator.time != -1) {
                        ++fabricator.time;
                    }
                } else {
                    fabricator.time = -1;
                }
            } else {
                fabricator.time = -1;
            }
            if (fabricator.time >= fabricator.maxTime) {
                fabricator.tryCraft();
                fabricator.time = 0;
            }
            fabricator.updateBlock();
        } else if (fabricator.time >= 0 && fabricator.recipe != null && this.isNotTryingToCraftBrokenRecipe()) {
            if (!fabricator.clientHandler.isSoundPlaying()) {
                fabricator.clientHandler.startSound();
            }
        } else if (fabricator.clientHandler.isSoundPlaying()) {
            fabricator.clientHandler.stopSound();
        }
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    private static boolean hasNotReachedStackLimit(BaseFabricatorBlockEntity entity) {
        return entity.itemHandler.getStackInSlot(2).getCount() < entity.itemHandler.getStackInSlot(2).getMaxStackSize();
    }

    private static class ClientHandler {
        public SoundInstance workingSound;

        private ClientHandler() {
        }

        public void createWorkingSound(BlockPos pos) {
            this.workingSound = new SimpleSoundInstance(((SoundEvent)SoundRegistry.FABRICATOR_WORKING.value()).getLocation(), SoundSource.BLOCKS, 2.0f, 1.0f, SoundInstance.createUnseededRandom(), true, 0, SoundInstance.Attenuation.LINEAR, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), false);
        }

        public void startSound() {
            Minecraft.getInstance().getSoundManager().play(this.workingSound);
        }

        public void stopSound() {
            Minecraft.getInstance().getSoundManager().stop(this.workingSound);
        }

        public boolean isSoundPlaying() {
            return Minecraft.getInstance().getSoundManager().isActive(this.workingSound);
        }
    }
}

