/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.essence;

import com.cmdpro.databank.misc.ColorGradient;
import com.cmdpro.datanessence.DataNEssence;
import java.awt.Color;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class EssenceType {
    public static final ResourceLocation ESSENCE_BAR_LOCATION = DataNEssence.locate("textures/gui/essence_bars.png");
    public final Component name;
    public final int tier;
    public final int color;
    public final EssenceBarSpriteLocation tinyBarSprite;
    public final EssenceBarSpriteLocation bigBarSprite;
    public final EssenceBarSpriteLocation iconSprite;
    public final String tooltipKey;
    public final String tooltipKeyWithMax;

    public EssenceType(Component name, int tier, int color, String tooltipKey, String tooltipKeyWithMax, EssenceBarSpriteLocation tinyBarSprite, EssenceBarSpriteLocation bigBarSprite, EssenceBarSpriteLocation iconSprite) {
        this.name = name;
        this.tier = tier;
        this.color = color;
        this.tinyBarSprite = tinyBarSprite;
        this.bigBarSprite = bigBarSprite;
        this.iconSprite = iconSprite;
        this.tooltipKey = tooltipKey;
        this.tooltipKeyWithMax = tooltipKeyWithMax;
    }

    public static EssenceBarSpriteLocation createLocation(ResourceLocation location, int x, int y) {
        return new EssenceBarSpriteLocation(location, x, y);
    }

    public String getTooltipKey() {
        return this.tooltipKey;
    }

    public Component getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public EssenceBarSpriteLocation getTinyBarSprite() {
        return this.tinyBarSprite;
    }

    public EssenceBarSpriteLocation getBigBarSprite() {
        return this.bigBarSprite;
    }

    public EssenceBarSpriteLocation getIconSprite() {
        return this.iconSprite;
    }

    public ColorGradient getThrowGradient() {
        return new ColorGradient(new Color(this.color), new Color(255, 255, 255)).fadeAlpha(1.0f, 0.0f).fadeAlpha(0.0f, 0.0f, 1.0f, 0.05f);
    }

    public static class EssenceBarSpriteLocation {
        public ResourceLocation texture;
        public int x;
        public int y;

        public EssenceBarSpriteLocation(ResourceLocation texture, int x, int y) {
            this.texture = texture;
            this.x = x;
            this.y = y;
        }
    }
}

