/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.essence.container;

import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import it.unimi.dsi.fastutil.objects.Object2FloatArrayMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public class InfiniteEssenceContainer
implements EssenceStorage {
    protected final Map<EssenceType, Float> storedEssence = new Object2FloatArrayMap();
    protected final float totalEssence;

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        ListTag tag2 = new ListTag();
        for (Map.Entry<EssenceType, Float> i : this.storedEssence.entrySet()) {
            CompoundTag tag3 = new CompoundTag();
            tag3.putString("Type", DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i.getKey()).toString());
            tag3.putFloat("Amount", i.getValue().floatValue());
            tag2.add((Object)tag3);
        }
        tag.put("Essence", (Tag)tag2);
        return tag;
    }

    public void fromNbt(@NotNull CompoundTag tag) {
        HashMap<EssenceType, Float> types = new HashMap<EssenceType, Float>();
        for (Tag i : (ListTag)tag.get("Essence")) {
            CompoundTag tag2 = (CompoundTag)i;
            types.put((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(ResourceLocation.tryParse((String)tag2.getString("Type"))), Float.valueOf(tag2.getFloat("Amount")));
        }
        this.storedEssence.clear();
        this.storedEssence.putAll(types);
    }

    public InfiniteEssenceContainer(float totalEssence) {
        this(DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.stream().toList(), totalEssence);
    }

    public InfiniteEssenceContainer(Iterable<EssenceType> supportedTypes, float totalEssence) {
        this.totalEssence = totalEssence;
        for (EssenceType type : supportedTypes) {
            this.storedEssence.put(type, Float.valueOf(totalEssence));
        }
    }

    public InfiniteEssenceContainer(Map<EssenceType, Float> types, float totalEssence) {
        this.totalEssence = totalEssence;
        this.storedEssence.putAll(types);
    }

    @Override
    public float getEssence(EssenceType type) {
        return this.storedEssence.getOrDefault(type, Float.valueOf(this.getMaxEssence())).floatValue();
    }

    @Override
    public void addEssence(EssenceType type, float amount) {
        if (this.storedEssence.containsKey(type)) {
            this.storedEssence.put(type, Float.valueOf(this.getMaxEssence()));
        }
    }

    @Override
    public void removeEssence(EssenceType type, float amount) {
        if (this.storedEssence.containsKey(type)) {
            this.storedEssence.put(type, Float.valueOf(this.getMaxEssence()));
        }
    }

    @Override
    public float getMaxEssence() {
        return this.totalEssence;
    }

    @Override
    public EssenceStorage getStorage() {
        return this;
    }

    @Override
    public Set<EssenceType> getSupportedEssenceTypes() {
        return this.storedEssence.keySet();
    }
}

