/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.essence.container;

import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.NotNull;

public class SingleEssenceContainer
implements EssenceStorage {
    protected final EssenceType storedType;
    protected float storedEssence;
    protected final float totalStorage;

    public SingleEssenceContainer(EssenceType storedType, float totalStorage) {
        this.storedType = storedType;
        this.storedEssence = 0.0f;
        this.totalStorage = totalStorage;
    }

    public SingleEssenceContainer(EssenceType storedType, float totalStorage, float amount) {
        this.storedType = storedType;
        this.storedEssence = amount;
        this.totalStorage = totalStorage;
    }

    @Override
    public float getEssence(EssenceType type) {
        if (type == this.storedType) {
            return this.storedEssence;
        }
        return 0.0f;
    }

    @Override
    public void addEssence(EssenceType type, float amount) {
        if (type == this.storedType) {
            this.storedEssence = Math.clamp(this.storedEssence + amount, 0.0f, this.getMaxEssence());
        }
    }

    @Override
    public void removeEssence(EssenceType type, float amount) {
        if (type == this.storedType) {
            this.storedEssence = Math.clamp(this.storedEssence - amount, 0.0f, this.getMaxEssence());
        }
    }

    @Override
    public float getMaxEssence() {
        return this.totalStorage;
    }

    @Override
    public EssenceStorage getStorage() {
        return this;
    }

    public CompoundTag toNbt() {
        CompoundTag tag = new CompoundTag();
        tag.putFloat("Amount", this.storedEssence);
        return tag;
    }

    public void fromNbt(@NotNull CompoundTag tag) {
        float storedAmount;
        this.storedEssence = storedAmount = tag.getFloat("Amount");
    }

    @Override
    public Set<EssenceType> getSupportedEssenceTypes() {
        return Set.of(this.storedType);
    }
}

