/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.node.block;

import com.cmdpro.databank.model.animation.DatabankAnimationReference;
import com.cmdpro.databank.model.animation.DatabankAnimationState;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.api.node.block.BaseCapabilityPoint;
import com.cmdpro.datanessence.api.node.item.INodeUpgrade;
import com.cmdpro.datanessence.client.particle.CircleParticleOptions;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.ItemStackHandler;
import org.jgrapht.GraphPath;
import org.jgrapht.alg.interfaces.ShortestPathAlgorithm;
import org.jgrapht.graph.DefaultEdge;
import org.joml.Quaternionfc;
import org.joml.Vector3f;

public abstract class BaseCapabilityPointBlockEntity
extends BlockEntity {
    public DatabankAnimationState animState = new DatabankAnimationState("idle").addAnim(new DatabankAnimationReference("idle", (state, anim) -> {}, (state, anim) -> {}));
    public List<BlockPos> link;
    public boolean isRelay;
    boolean wasRelay;
    public final ItemStackHandler universalUpgrade = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BaseCapabilityPointBlockEntity.this.setChanged();
        }
    };
    public final ItemStackHandler uniqueUpgrade = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            BaseCapabilityPointBlockEntity.this.setChanged();
        }
    };

    public void setLevel(Level level) {
        super.setLevel(level);
        this.animState.setLevel(level);
    }

    public <T> T getValue(ResourceLocation id, T defaultValue) {
        INodeUpgrade upgrade;
        Object modified;
        Object value = defaultValue;
        Item item = this.universalUpgrade.getStackInSlot(0).getItem();
        if (item instanceof INodeUpgrade && (modified = (upgrade = (INodeUpgrade)item).getValue(this.universalUpgrade.getStackInSlot(0), id, value, this)) != null) {
            value = modified;
        }
        if ((modified = this.uniqueUpgrade.getStackInSlot(0).getItem()) instanceof INodeUpgrade && (modified = (upgrade = (INodeUpgrade)modified).getValue(this.uniqueUpgrade.getStackInSlot(0), id, value, this)) != null) {
            value = modified;
        }
        return value;
    }

    public float getFinalSpeed(float value) {
        return value * this.getValue(DataNEssence.locate("speed_multiplier"), Float.valueOf(1.0f)).floatValue();
    }

    public int getFinalSpeed(int value) {
        return (int)((float)value * this.getValue(DataNEssence.locate("speed_multiplier"), Float.valueOf(1.0f)).floatValue());
    }

    public BaseCapabilityPointBlockEntity(BlockEntityType<?> pType, BlockPos pPos, BlockState pBlockState) {
        super(pType, pPos, pBlockState);
    }

    public void onLoad() {
        super.onLoad();
        if (this.level != null && !this.level.isClientSide) {
            BlockPosNetworks networks = (BlockPosNetworks)this.level.getData(AttachmentTypeRegistry.CAPABILITY_NODE_NETWORKS);
            if (!networks.graph.containsVertex((Object)this.getBlockPos())) {
                networks.graph.addVertex((Object)this.getBlockPos());
            }
        }
    }

    public abstract Color linkColor();

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, BaseCapabilityPointBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide()) {
            if (pBlockEntity.link == null) {
                pBlockEntity.updateLinks();
            }
            BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.CAPABILITY_NODE_NETWORKS);
            Set edges = networks.graph.edgesOf((Object)pPos);
            if (edges.stream().noneMatch(edge -> ((BlockPos)networks.graph.getEdgeTarget(edge)).equals((Object)pPos)) && !edges.isEmpty()) {
                ShortestPathAlgorithm.SingleSourcePaths paths = networks.path.getPaths((Object)pPos);
                List<GraphPath<BlockPos, DefaultEdge>> ends = networks.graph.vertexSet().stream().filter(vertex -> pLevel.isLoaded(vertex) && networks.graph.edgesOf(vertex).stream().noneMatch(edge -> ((BlockPos)networks.graph.getEdgeSource(edge)).equals(vertex)) && paths.getPath(vertex) != null).map(arg_0 -> ((ShortestPathAlgorithm.SingleSourcePaths)paths).getPath(arg_0)).toList();
                pBlockEntity.preTransferHooks(pBlockEntity, ends);
                pBlockEntity.transfer(pBlockEntity, ends);
                pBlockEntity.postTransferHooks(pBlockEntity, ends);
            }
            Set incoming = networks.graph.incomingEdgesOf((Object)pPos);
            Set outgoing = networks.graph.outgoingEdgesOf((Object)pPos);
            pBlockEntity.isRelay = !incoming.isEmpty() && !outgoing.isEmpty();
        } else {
            if (pBlockEntity.link == null) {
                pBlockEntity.link = new ArrayList<BlockPos>();
            }
            if (pBlockEntity.wasRelay != pBlockEntity.isRelay) {
                Color color = pBlockEntity.linkColor();
                for (int i = 0; i < 32; ++i) {
                    CircleParticleOptions options = new CircleParticleOptions();
                    options.setColor(color);
                    Vec3 center = pPos.getCenter();
                    float angle = 11.25f * (float)i;
                    Vector3f spd = new Vector3f((float)Math.sin(Math.toRadians(angle)), 0.0f, (float)Math.cos(Math.toRadians(angle))).mul(0.2f);
                    AttachFace attachFace = (AttachFace)pState.getValue(BaseCapabilityPoint.FACE);
                    Direction direction = (Direction)pState.getValue((Property)BaseCapabilityPoint.FACING);
                    if (attachFace.equals((Object)AttachFace.WALL)) {
                        spd.rotate((Quaternionfc)direction.getRotation());
                    }
                    pLevel.addParticle((ParticleOptions)options, center.x, center.y, center.z, (double)spd.x, (double)spd.y, (double)spd.z);
                }
            }
            pBlockEntity.wasRelay = pBlockEntity.isRelay;
        }
    }

    public void updateLinks() {
        if (this.link == null) {
            this.link = new ArrayList<BlockPos>();
        }
        this.link.clear();
        BlockPosNetworks networks = (BlockPosNetworks)this.level.getData(AttachmentTypeRegistry.CAPABILITY_NODE_NETWORKS);
        if (networks.graph.containsVertex((Object)this.getBlockPos())) {
            for (DefaultEdge i : networks.graph.edgesOf((Object)this.getBlockPos())) {
                if (!((BlockPos)networks.graph.getEdgeSource((Object)i)).equals((Object)this.getBlockPos())) continue;
                BlockPos target = (BlockPos)networks.graph.getEdgeTarget((Object)i);
                this.link.add(target);
            }
        }
    }

    public boolean preTransferHooks(BlockEntity from, List<GraphPath<BlockPos, DefaultEdge>> other) {
        INodeUpgrade upgrade;
        boolean cancel = false;
        Item item = this.universalUpgrade.getStackInSlot(0).getItem();
        if (item instanceof INodeUpgrade && (upgrade = (INodeUpgrade)item).preTransfer(this.universalUpgrade.getStackInSlot(0), from, other, cancel)) {
            cancel = true;
        }
        if ((item = this.uniqueUpgrade.getStackInSlot(0).getItem()) instanceof INodeUpgrade && (upgrade = (INodeUpgrade)item).preTransfer(this.uniqueUpgrade.getStackInSlot(0), from, other, cancel)) {
            cancel = true;
        }
        return cancel;
    }

    public void postTransferHooks(BlockEntity from, List<GraphPath<BlockPos, DefaultEdge>> other) {
        INodeUpgrade upgrade;
        Item item = this.universalUpgrade.getStackInSlot(0).getItem();
        if (item instanceof INodeUpgrade) {
            upgrade = (INodeUpgrade)item;
            upgrade.postTransfer(this.universalUpgrade.getStackInSlot(0), from, other);
        }
        if ((item = this.uniqueUpgrade.getStackInSlot(0).getItem()) instanceof INodeUpgrade) {
            upgrade = (INodeUpgrade)item;
            upgrade.postTransfer(this.uniqueUpgrade.getStackInSlot(0), from, other);
        }
    }

    public abstract void transfer(BaseCapabilityPointBlockEntity var1, List<GraphPath<BlockPos, DefaultEdge>> var2);

    public Direction getDirection() {
        if (((AttachFace)this.getBlockState().getValue(BaseCapabilityPoint.FACE)).equals((Object)AttachFace.CEILING)) {
            return Direction.DOWN;
        }
        if (((AttachFace)this.getBlockState().getValue(BaseCapabilityPoint.FACE)).equals((Object)AttachFace.WALL)) {
            return (Direction)this.getBlockState().getValue((Property)BaseCapabilityPoint.FACING);
        }
        return Direction.UP;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        ListTag list = (ListTag)tag.get("link");
        if (this.link == null) {
            this.link = new ArrayList<BlockPos>();
        }
        this.link.clear();
        for (Tag i : list) {
            CompoundTag blockpos = (CompoundTag)i;
            this.link.add(new BlockPos(blockpos.getInt("linkX"), blockpos.getInt("linkY"), blockpos.getInt("linkZ")));
        }
        this.uniqueUpgrade.deserializeNBT(pRegistries, tag.getCompound("uniqueUpgrade"));
        this.universalUpgrade.deserializeNBT(pRegistries, tag.getCompound("universalUpgrade"));
        this.isRelay = tag.getBoolean("Relay");
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        ListTag list = new ListTag();
        if (this.link != null) {
            for (BlockPos target : this.link) {
                CompoundTag blockpos = new CompoundTag();
                blockpos.putInt("linkX", target.getX());
                blockpos.putInt("linkY", target.getY());
                blockpos.putInt("linkZ", target.getZ());
                list.add((Object)blockpos);
            }
        }
        tag.put("link", (Tag)list);
        tag.put("uniqueUpgrade", (Tag)this.uniqueUpgrade.serializeNBT(pRegistries));
        tag.put("universalUpgrade", (Tag)this.universalUpgrade.serializeNBT(pRegistries));
        tag.putBoolean("Relay", this.isRelay);
        return tag;
    }

    public void updateBlock() {
        this.updateLinks();
        BlockPosNetworks networks = (BlockPosNetworks)this.level.getData(AttachmentTypeRegistry.CAPABILITY_NODE_NETWORKS);
        Set incoming = networks.graph.incomingEdgesOf((Object)this.getBlockPos());
        Set outgoing = networks.graph.outgoingEdgesOf((Object)this.getBlockPos());
        this.isRelay = !incoming.isEmpty() && !outgoing.isEmpty();
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.loadAdditional(tag, pRegistries);
        ListTag list = (ListTag)tag.get("link");
        if (this.link == null) {
            this.link = new ArrayList<BlockPos>();
        }
        this.link.clear();
        for (Tag i : list) {
            CompoundTag blockpos = (CompoundTag)i;
            this.link.add(new BlockPos(blockpos.getInt("linkX"), blockpos.getInt("linkY"), blockpos.getInt("linkZ")));
        }
        this.uniqueUpgrade.deserializeNBT(pRegistries, tag.getCompound("uniqueUpgrade"));
        this.universalUpgrade.deserializeNBT(pRegistries, tag.getCompound("universalUpgrade"));
        this.isRelay = tag.getBoolean("Relay");
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider pRegistries) {
        super.saveAdditional(tag, pRegistries);
        tag.put("uniqueUpgrade", (Tag)this.uniqueUpgrade.serializeNBT(pRegistries));
        tag.put("universalUpgrade", (Tag)this.universalUpgrade.serializeNBT(pRegistries));
        ListTag list = new ListTag();
        if (this.link != null) {
            for (BlockPos target : this.link) {
                CompoundTag blockpos = new CompoundTag();
                blockpos.putInt("linkX", target.getX());
                blockpos.putInt("linkY", target.getY());
                blockpos.putInt("linkZ", target.getZ());
                list.add((Object)blockpos);
            }
        }
        tag.put("link", (Tag)list);
        tag.putBoolean("Relay", this.isRelay);
    }
}

