/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.node.block;

import com.cmdpro.datanessence.api.misc.BlockPosNetworks;
import com.cmdpro.datanessence.api.node.block.BaseEssencePointBlockEntity;
import com.cmdpro.datanessence.api.node.item.INodeUpgrade;
import com.cmdpro.datanessence.api.util.PlayerDataUtil;
import com.cmdpro.datanessence.config.DataNEssenceConfig;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import com.cmdpro.datanessence.registry.ItemRegistry;
import com.cmdpro.datanessence.registry.SoundRegistry;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jgrapht.graph.DefaultEdge;

public abstract class BaseEssencePoint
extends Block
implements EntityBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final EnumProperty<AttachFace> FACE = BlockStateProperties.ATTACH_FACE;
    protected static final VoxelShape NORTH_AABB = Block.box((double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.box((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)4.0);
    protected static final VoxelShape WEST_AABB = Block.box((double)12.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
    protected static final VoxelShape EAST_AABB = Block.box((double)0.0, (double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0);
    protected static final VoxelShape UP_AABB = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0, (double)12.0);
    protected static final VoxelShape DOWN_AABB = Block.box((double)4.0, (double)12.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BaseEssencePoint(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(FACE, (Comparable)AttachFace.FLOOR));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.add(new Property[]{FACE, FACING});
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        switch ((AttachFace)pState.getValue(FACE)) {
            case FLOOR: {
                return UP_AABB;
            }
            case WALL: {
                switch ((Direction)pState.getValue((Property)FACING)) {
                    case EAST: {
                        return EAST_AABB;
                    }
                    case WEST: {
                        return WEST_AABB;
                    }
                    case SOUTH: {
                        return SOUTH_AABB;
                    }
                }
                return NORTH_AABB;
            }
        }
        return DOWN_AABB;
    }

    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        int n = 0;
        Direction[] directionArray = pContext.getNearestLookingDirections();
        int n2 = directionArray.length;
        if (n < n2) {
            Direction direction = directionArray[n];
            if (direction.getAxis() == Direction.Axis.Y) {
                return (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)(direction == Direction.UP ? AttachFace.CEILING : AttachFace.FLOOR))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
            }
            return (BlockState)((BlockState)this.defaultBlockState().setValue(FACE, (Comparable)AttachFace.WALL)).setValue((Property)FACING, (Comparable)direction.getOpposite());
        }
        return null;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pMovedByPiston) {
        BlockEntity blockEntity;
        if (pState.getBlock() != pNewState.getBlock() && (blockEntity = pLevel.getBlockEntity(pPos)) instanceof BaseEssencePointBlockEntity) {
            BaseEssencePointBlockEntity node = (BaseEssencePointBlockEntity)blockEntity;
            BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ESSENCE_NODE_NETWORKS);
            Set edges = networks.graph.edgesOf((Object)pPos);
            for (DefaultEdge i : edges) {
                ItemEntity upgradeSigil;
                BlockEntity blockEntity2;
                BlockPos pos = (BlockPos)networks.graph.getEdgeSource((Object)i);
                ItemEntity item = new ItemEntity(pLevel, pos.getCenter().x, pos.getCenter().y, pos.getCenter().z, new ItemStack((ItemLike)this.getRequiredWire()));
                pLevel.addFreshEntity((Entity)item);
                networks.graph.removeEdge((Object)i);
                if (!pos.equals((Object)pPos) && (blockEntity2 = pLevel.getBlockEntity(pos)) instanceof BaseEssencePointBlockEntity) {
                    BaseEssencePointBlockEntity ent = (BaseEssencePointBlockEntity)blockEntity2;
                    ent.updateBlock();
                }
                if (node.uniqueUpgrade.getStackInSlot(0) != ItemStack.EMPTY) {
                    upgradeSigil = new ItemEntity(pLevel, pPos.getCenter().x, pPos.getCenter().y, pPos.getCenter().z, node.uniqueUpgrade.getStackInSlot(0).copy());
                    pLevel.addFreshEntity((Entity)upgradeSigil);
                }
                if (node.universalUpgrade.getStackInSlot(0) == ItemStack.EMPTY) continue;
                upgradeSigil = new ItemEntity(pLevel, pPos.getCenter().x, pPos.getCenter().y, pPos.getCenter().z, node.universalUpgrade.getStackInSlot(0).copy());
                pLevel.addFreshEntity((Entity)upgradeSigil);
            }
        }
        super.onRemove(pState, pLevel, pPos, pNewState, pMovedByPiston);
    }

    public static Direction getConnectedDirection(BlockState pState) {
        switch ((AttachFace)pState.getValue(FACE)) {
            case CEILING: {
                return Direction.DOWN;
            }
            case FLOOR: {
                return Direction.UP;
            }
        }
        return (Direction)pState.getValue((Property)FACING);
    }

    public abstract Item getRequiredWire();

    protected ItemInteractionResult useItemOn(ItemStack pStack, BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHitResult) {
        BlockEntity entity;
        boolean success;
        boolean bl = success = pPlayer.getItemInHand(pHand).is(this.getRequiredWire()) || pPlayer.getItemInHand(pHand).getItem() instanceof INodeUpgrade;
        if (!pLevel.isClientSide() && (entity = pLevel.getBlockEntity(pPos)) instanceof BaseEssencePointBlockEntity) {
            Object edges;
            BaseEssencePointBlockEntity ent = (BaseEssencePointBlockEntity)entity;
            if (pPlayer.getItemInHand(pHand).is(this.getRequiredWire())) {
                BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ESSENCE_NODE_NETWORKS);
                edges = networks.graph.edgesOf((Object)pPos);
                Optional linkFrom = (Optional)pPlayer.getData(AttachmentTypeRegistry.LINK_FROM);
                if (!linkFrom.isPresent()) {
                    if (edges.stream().filter(edge -> ((BlockPos)networks.graph.getEdgeSource(edge)).equals((Object)pPos)).toList().size() < DataNEssenceConfig.maxNodeWires) {
                        pPlayer.setData(AttachmentTypeRegistry.LINK_FROM, Optional.of(ent));
                        PlayerDataUtil.updateData((ServerPlayer)pPlayer);
                        pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.NODE_LINK_FROM.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                    }
                } else {
                    Object t;
                    BaseEssencePoint other;
                    Block block = ((BlockEntity)linkFrom.get()).getBlockState().getBlock();
                    if (block instanceof BaseEssencePoint && (other = (BaseEssencePoint)block).getRequiredWire() == this.getRequiredWire() && ent != linkFrom.get() && (ent.link.isEmpty() || !ent.link.contains(((BlockEntity)linkFrom.get()).getBlockPos())) && (t = linkFrom.get()) instanceof BaseEssencePointBlockEntity) {
                        BaseEssencePointBlockEntity linkFrom2 = (BaseEssencePointBlockEntity)((Object)t);
                        if (((BlockEntity)linkFrom.get()).getBlockPos().closerThan((Vec3i)ent.getBlockPos(), (double)DataNEssenceConfig.wireDistanceLimit)) {
                            networks.graph.addEdge((Object)linkFrom2.getBlockPos(), (Object)pPos);
                            linkFrom2.updateBlock();
                            ent.updateBlock();
                            pPlayer.setData(AttachmentTypeRegistry.LINK_FROM, Optional.empty());
                            PlayerDataUtil.updateData((ServerPlayer)pPlayer);
                            pPlayer.getInventory().clearOrCountMatchingItems(item -> item.is(this.getRequiredWire()), 1, (Container)pPlayer.inventoryMenu.getCraftSlots());
                            pLevel.playSound(null, pPos, (SoundEvent)SoundRegistry.NODE_LINK_TO.value(), SoundSource.BLOCKS, 1.0f, 1.0f);
                        }
                    }
                }
            }
            if ((edges = pPlayer.getItemInHand(pHand).getItem()) instanceof INodeUpgrade) {
                INodeUpgrade upgrade = (INodeUpgrade)edges;
                if (ent.universalUpgrade.getStackInSlot(0).isEmpty() && upgrade.getType().equals((Object)INodeUpgrade.Type.UNIVERSAL)) {
                    copy = pPlayer.getItemInHand(pHand).copy();
                    copy.setCount(1);
                    ent.universalUpgrade.setStackInSlot(0, copy);
                    pPlayer.getItemInHand(pHand).shrink(1);
                    ent.updateBlock();
                } else if (ent.uniqueUpgrade.getStackInSlot(0).isEmpty() && upgrade.getType().equals((Object)INodeUpgrade.Type.UNIQUE)) {
                    copy = pPlayer.getItemInHand(pHand).copy();
                    copy.setCount(1);
                    ent.uniqueUpgrade.setStackInSlot(0, copy);
                    pPlayer.getItemInHand(pHand).shrink(1);
                    ent.updateBlock();
                }
            }
            if (pPlayer.getItemInHand(pHand).is(ItemRegistry.ESSENCE_REDIRECTOR.get())) {
                if (!ent.universalUpgrade.getStackInSlot(0).isEmpty()) {
                    pPlayer.getInventory().add(ent.universalUpgrade.getStackInSlot(0));
                    ent.universalUpgrade.setStackInSlot(0, ItemStack.EMPTY);
                    ent.updateBlock();
                } else if (!ent.uniqueUpgrade.getStackInSlot(0).isEmpty()) {
                    pPlayer.getInventory().add(ent.uniqueUpgrade.getStackInSlot(0));
                    ent.uniqueUpgrade.setStackInSlot(0, ItemStack.EMPTY);
                    ent.updateBlock();
                }
            }
        }
        if (success) {
            return ItemInteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
        }
        return super.useItemOn(pStack, pState, pLevel, pPos, pPlayer, pHand, pHitResult);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        BlockEntity entity;
        if (!pLevel.isClientSide() && (entity = pLevel.getBlockEntity(pPos)) instanceof BaseEssencePointBlockEntity) {
            BaseEssencePointBlockEntity ent = (BaseEssencePointBlockEntity)entity;
            if (pPlayer.isShiftKeyDown()) {
                BlockPosNetworks networks = (BlockPosNetworks)pLevel.getData(AttachmentTypeRegistry.ESSENCE_NODE_NETWORKS);
                Set edges = networks.graph.edgesOf((Object)pPos);
                if (edges.stream().anyMatch(edge -> ((BlockPos)networks.graph.getEdgeSource(edge)).equals((Object)pPos))) {
                    for (DefaultEdge i : edges) {
                        if (!((BlockPos)networks.graph.getEdgeSource((Object)i)).equals((Object)pPos)) continue;
                        ItemEntity item = new ItemEntity(pLevel, pPos.getCenter().x, pPos.getCenter().y, pPos.getCenter().z, new ItemStack((ItemLike)this.getRequiredWire()));
                        pLevel.addFreshEntity((Entity)item);
                        networks.graph.removeEdge((Object)i);
                        BlockPos to = (BlockPos)networks.graph.getEdgeTarget((Object)i);
                        BlockEntity blockEntity = pLevel.getBlockEntity(to);
                        if (!(blockEntity instanceof BaseEssencePointBlockEntity)) continue;
                        BaseEssencePointBlockEntity toEnt = (BaseEssencePointBlockEntity)blockEntity;
                        toEnt.updateBlock();
                    }
                    ent.updateBlock();
                }
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide());
    }

    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return BaseEssencePoint.getConnectedDirection(pState).getOpposite() == pFacing && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public BlockState rotate(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.setValue((Property)FACING, (Comparable)pRotation.rotate((Direction)pState.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState pState, Mirror pMirror) {
        return pState.rotate(pMirror.getRotation((Direction)pState.getValue((Property)FACING)));
    }
}

