/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.node.renderers;

import com.cmdpro.databank.misc.RenderingUtil;
import com.cmdpro.databank.model.DatabankModel;
import com.cmdpro.databank.model.DatabankModels;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityModel;
import com.cmdpro.databank.model.blockentity.DatabankBlockEntityRenderer;
import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.databank.rendering.RenderHandler;
import com.cmdpro.datanessence.DataNEssence;
import com.cmdpro.datanessence.api.node.block.BaseEssencePointBlockEntity;
import com.cmdpro.datanessence.api.util.client.ClientRenderingUtil;
import com.cmdpro.datanessence.block.transmission.EssencePoint;
import com.cmdpro.datanessence.client.shaders.DataNEssenceRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public abstract class BaseEssencePointRenderer<T extends BaseEssencePointBlockEntity>
extends DatabankBlockEntityRenderer<T> {
    public Model<T> model;
    public RelayModel<T> relayModel;

    public BaseEssencePointRenderer(Model<T> model, RelayModel<T> relayModel) {
        super(model);
        this.model = model;
        this.relayModel = relayModel;
    }

    public DatabankBlockEntityModel<T> getModel(T pBlockEntity) {
        return ((BaseEssencePointBlockEntity)((Object)pBlockEntity)).isRelay ? this.relayModel : this.model;
    }

    public void render(T pBlockEntity, float pPartialTick, PoseStack pPoseStack, MultiBufferSource pBufferSource, int pPackedLight, int pPackedOverlay) {
        if (((BaseEssencePointBlockEntity)((Object)pBlockEntity)).link != null) {
            BlockPos blockPos = pBlockEntity.getBlockPos();
            Vec3 pos = blockPos.getCenter();
            pPoseStack.pushPose();
            pPoseStack.translate(-pos.x, -pos.y, -pos.z);
            pPoseStack.translate(0.5, 0.5, 0.5);
            Vec3 origin = blockPos.getCenter();
            for (BlockPos i : ((BaseEssencePointBlockEntity)((Object)pBlockEntity)).link) {
                Vec3 target = i.getCenter();
                VertexConsumer vertexConsumer = RenderHandler.createBufferSource().getBuffer(DataNEssenceRenderTypes.WIRES);
                float darken = 1.5f;
                Color segColor1 = ((BaseEssencePointBlockEntity)((Object)pBlockEntity)).linkColor();
                Color segColor2 = new Color((int)((float)segColor1.getRed() / darken), (int)((float)segColor1.getGreen() / darken), (int)((float)segColor1.getBlue() / darken), segColor1.getAlpha());
                Color segColor3 = ColorUtil.blendColors((Color)segColor1, (Color)segColor2, (float)0.35f);
                float ticks = (float)(Minecraft.getInstance().level.getGameTime() % 8L) + pPartialTick;
                int currentSeg = (int)(ticks % 8.0f);
                ClientRenderingUtil.renderLine(vertexConsumer, pPoseStack, origin, target, seg -> {
                    if (7 - seg % 8 == this.getSegWithOffset(currentSeg, -2) || 7 - seg % 8 == this.getSegWithOffset(currentSeg, 1) % 8) {
                        return segColor3;
                    }
                    return 7 - seg % 8 == currentSeg || 7 - seg % 8 == this.getSegWithOffset(currentSeg, -1) ? segColor1 : segColor2;
                }, blockPos.getX() == i.getX() && blockPos.getZ() == i.getZ() ? 0.0 : 0.3);
            }
            pPoseStack.popPose();
        }
        Color color = ((BaseEssencePointBlockEntity)((Object)pBlockEntity)).linkColor();
        pBufferSource.getBuffer(this.getModel(pBlockEntity).getRenderType(pBlockEntity));
        AttachFace face = (AttachFace)pBlockEntity.getBlockState().getValue((Property)EssencePoint.FACE);
        Direction facing = (Direction)pBlockEntity.getBlockState().getValue((Property)EssencePoint.FACING);
        this.rotateStack(face, facing, pPoseStack);
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        pPoseStack.translate(0.0, 0.0, -0.15);
        pPoseStack.mulPose(Axis.ZP.rotationDegrees((float)(pBlockEntity.getLevel().getLevelData().getGameTime() % 360L) + pPartialTick));
        pPoseStack.scale(0.75f, 0.75f, 0.75f);
        RenderingUtil.renderItemWithColor((ItemStack)((BaseEssencePointBlockEntity)((Object)pBlockEntity)).uniqueUpgrade.getStackInSlot(0), (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false, (PoseStack)pPoseStack, (MultiBufferSource)pBufferSource, (int)0xF000F0, (int)pPackedOverlay, (Color)color, (Level)pBlockEntity.getLevel());
        pPoseStack.popPose();
        pPoseStack.pushPose();
        pPoseStack.translate(0.5, 0.5, 0.5);
        pPoseStack.mulPose(Axis.XP.rotationDegrees(90.0f));
        pPoseStack.translate(0.0, 0.0, -0.3);
        pPoseStack.mulPose(Axis.ZP.rotationDegrees(-((float)(pBlockEntity.getLevel().getLevelData().getGameTime() % 360L) + pPartialTick)));
        pPoseStack.scale(0.5f, 0.5f, 0.5f);
        RenderingUtil.renderItemWithColor((ItemStack)((BaseEssencePointBlockEntity)((Object)pBlockEntity)).universalUpgrade.getStackInSlot(0), (ItemDisplayContext)ItemDisplayContext.FIXED, (boolean)false, (PoseStack)pPoseStack, (MultiBufferSource)pBufferSource, (int)0xF000F0, (int)pPackedOverlay, (Color)color, (Level)pBlockEntity.getLevel());
        pPoseStack.popPose();
        super.render(pBlockEntity, pPartialTick, pPoseStack, pBufferSource, pPackedLight, pPackedOverlay);
    }

    private int getSegWithOffset(int seg, int offset) {
        int segment = seg + offset;
        if (segment < 0) {
            segment += 8;
        }
        return segment %= 8;
    }

    public void rotateStack(AttachFace face, Direction facing, PoseStack poseStack) {
        Vec3 rotateAround = new Vec3(0.5, 0.5, 0.5);
        if (face.equals((Object)AttachFace.CEILING)) {
            poseStack.rotateAround(Axis.XP.rotationDegrees(180.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
        }
        if (face.equals((Object)AttachFace.WALL)) {
            if (facing.equals((Object)Direction.NORTH)) {
                poseStack.rotateAround(Axis.XP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
            }
            if (facing.equals((Object)Direction.SOUTH)) {
                poseStack.rotateAround(Axis.XP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
            }
            if (facing.equals((Object)Direction.EAST)) {
                poseStack.rotateAround(Axis.ZP.rotationDegrees(-90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
            }
            if (facing.equals((Object)Direction.WEST)) {
                poseStack.rotateAround(Axis.ZP.rotationDegrees(90.0f), (float)rotateAround.x, (float)rotateAround.y, (float)rotateAround.z);
            }
        }
    }

    public AABB getRenderBoundingBox(T blockEntity) {
        return AABB.INFINITE;
    }

    public boolean shouldRenderOffScreen(BaseEssencePointBlockEntity pBlockEntity) {
        return true;
    }

    public static class Model<T extends BaseEssencePointBlockEntity>
    extends DatabankBlockEntityModel<T> {
        public ResourceLocation texture;

        public Model(ResourceLocation texture) {
            this.texture = texture;
        }

        public ResourceLocation getTextureLocation() {
            return this.texture;
        }

        public void setupModelPose(BaseEssencePointBlockEntity pEntity, float partialTick) {
            pEntity.animState.updateAnimDefinitions(this.getModel());
            this.animate(pEntity.animState);
        }

        public DatabankModel getModel() {
            return (DatabankModel)DatabankModels.models.get(DataNEssence.locate("essence_point"));
        }
    }

    public static class RelayModel<T extends BaseEssencePointBlockEntity>
    extends Model<T> {
        public RelayModel(ResourceLocation texture) {
            super(texture);
        }

        @Override
        public DatabankModel getModel() {
            return (DatabankModel)DatabankModels.models.get(DataNEssence.locate("node_relay"));
        }
    }
}

