/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.util;

import com.cmdpro.databank.DatabankUtils;
import com.cmdpro.datanessence.api.node.block.BaseCapabilityPointBlockEntity;
import com.cmdpro.datanessence.api.node.block.BaseEssencePointBlockEntity;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlock;
import com.cmdpro.datanessence.api.pearlnetwork.PearlNetworkBlockEntity;
import com.cmdpro.datanessence.networking.ModMessages;
import com.cmdpro.datanessence.networking.packet.s2c.PlayerDataSync;
import com.cmdpro.datanessence.networking.packet.s2c.PlayerTierSync;
import com.cmdpro.datanessence.networking.packet.s2c.UnlockEntry;
import com.cmdpro.datanessence.networking.packet.s2c.UnlockedEntrySync;
import com.cmdpro.datanessence.registry.AttachmentTypeRegistry;
import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;

public class PlayerDataUtil {
    public static void updateData(ServerPlayer player) {
        Color linkColor = new Color(0, 0, 0, 0);
        Optional linkFromEntity = (Optional)player.getData(AttachmentTypeRegistry.LINK_FROM);
        BlockPos linkFrom = null;
        if (linkFromEntity.isPresent()) {
            linkFrom = ((BlockEntity)linkFromEntity.get()).getBlockPos();
            Object t = linkFromEntity.get();
            if (t instanceof BaseEssencePointBlockEntity) {
                BaseEssencePointBlockEntity linkFrom2 = (BaseEssencePointBlockEntity)((Object)t);
                linkColor = linkFrom2.linkColor();
            } else {
                t = linkFromEntity.get();
                if (t instanceof BaseCapabilityPointBlockEntity) {
                    BaseCapabilityPointBlockEntity linkFrom2 = (BaseCapabilityPointBlockEntity)((Object)t);
                    linkColor = linkFrom2.linkColor();
                } else {
                    t = linkFromEntity.get();
                    if (t instanceof PearlNetworkBlockEntity) {
                        PearlNetworkBlockEntity linkFrom2 = (PearlNetworkBlockEntity)((Object)t);
                        linkColor = PearlNetworkBlock.getColor();
                    }
                }
            }
        }
        ModMessages.sendToPlayer(new PlayerDataSync(PlayerDataUtil.getUnlockedEssences(player), linkFrom, linkColor), player);
    }

    public static void updateUnlockedEntries(ServerPlayer player) {
        ModMessages.sendToPlayer(new UnlockedEntrySync((List)player.getData(AttachmentTypeRegistry.UNLOCKED), (HashMap)player.getData(AttachmentTypeRegistry.INCOMPLETE_STAGES)), player);
        DatabankUtils.updateHidden((Player)player);
    }

    public static void unlockEntry(ServerPlayer player, ResourceLocation entry, int completionStage) {
        ModMessages.sendToPlayer(new UnlockEntry(entry, completionStage), player);
        DatabankUtils.updateHidden((Player)player);
    }

    public static void sendTier(ServerPlayer player, boolean showIndicator) {
        ModMessages.sendToPlayer(new PlayerTierSync((Integer)player.getData(AttachmentTypeRegistry.TIER), showIndicator), player);
    }

    public static Map<ResourceLocation, Boolean> getUnlockedEssences(ServerPlayer player) {
        return (Map)player.getData(AttachmentTypeRegistry.UNLOCKED_ESSENCES);
    }
}

