/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.api.util.client;

import com.cmdpro.databank.shaders.PostShaderManager;
import com.cmdpro.datanessence.api.LockableItemHandler;
import com.cmdpro.datanessence.api.util.client.ClientProgressionUtil;
import com.cmdpro.datanessence.client.shaders.DataNEssenceCoreShaders;
import com.cmdpro.datanessence.client.shaders.DataNEssenceRenderTypes;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.SlotItemHandler;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class ClientRenderingUtil
extends ClientProgressionUtil {
    public static void renderLockedSlotBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY, int x, int y, NonNullList<Slot> slots) {
        for (Slot i : slots) {
            SlotItemHandler handlerSlot;
            IItemHandler iItemHandler;
            if (!(i instanceof SlotItemHandler) || !((iItemHandler = (handlerSlot = (SlotItemHandler)i).getItemHandler()) instanceof LockableItemHandler)) continue;
            LockableItemHandler lockable = (LockableItemHandler)iItemHandler;
            if (!i.getItem().isEmpty() || !lockable.lockedSlots.containsKey(i.getContainerSlot())) continue;
            pGuiGraphics.pose().pushPose();
            pGuiGraphics.pose().scale(0.5f, 0.5f, 0.5f);
            pGuiGraphics.renderFakeItem(lockable.lockedSlots.get(i.getContainerSlot()), (int)((float)(x + i.x) / 0.5f), (int)((float)(y + i.y) / 0.5f));
            pGuiGraphics.pose().popPose();
        }
    }

    public static void renderBlackHole(PoseStack stack, Vec3 pos, MultiBufferSource source, float radius, int longs, int lats) {
        stack.pushPose();
        stack.translate(pos.x, pos.y, pos.z);
        Matrix4f last = stack.last().pose();
        ShaderInstance shader = DataNEssenceCoreShaders.WARPING_POINT;
        shader.safeGetUniform("CameraPosition").set(new Vector3f(0.0f, 0.0f, 0.0f));
        shader.safeGetUniform("ObjectPosition").set(pos.toVector3f().sub((Vector3fc)Minecraft.getInstance().gameRenderer.getMainCamera().getPosition().toVector3f()));
        shader.safeGetUniform("Radius").set(Math.abs(radius));
        shader.safeGetUniform("ModelViewMatrix").set(PostShaderManager.viewStackMatrix);
        shader.safeGetUniform("lookVector").set(Minecraft.getInstance().gameRenderer.getMainCamera().getLookVector());
        shader.safeGetUniform("FOV").set((float)Math.toRadians(Minecraft.getInstance().gameRenderer.getFov(Minecraft.getInstance().gameRenderer.getMainCamera(), Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true), true)));
        VertexConsumer consumer = source.getBuffer(DataNEssenceRenderTypes.WARPING_POINT);
        float startU = 0.0f;
        float startV = 0.0f;
        float endU = (float)Math.PI * 2;
        float endV = (float)Math.PI;
        float stepU = (endU - startU) / (float)longs;
        float stepV = (endV - startV) / (float)lats;
        for (int i = 0; i < longs; ++i) {
            for (int j = 0; j < lats; ++j) {
                float u = (float)i * stepU + startU;
                float v = (float)j * stepV + startV;
                float un = i + 1 == longs ? endU : (float)(i + 1) * stepU + startU;
                float vn = j + 1 == lats ? endV : (float)(j + 1) * stepV + startV;
                Vector3f p0 = ClientRenderingUtil.parametricSphere(u, v, radius);
                Vector3f p1 = ClientRenderingUtil.parametricSphere(u, vn, radius);
                Vector3f p2 = ClientRenderingUtil.parametricSphere(un, v, radius);
                Vector3f p3 = ClientRenderingUtil.parametricSphere(un, vn, radius);
                consumer.addVertex(last, p0.x(), p0.y(), p0.z());
                consumer.addVertex(last, p2.x(), p2.y(), p2.z());
                consumer.addVertex(last, p1.x(), p1.y(), p1.z());
                consumer.addVertex(last, p1.x(), p1.y(), p1.z());
                consumer.addVertex(last, p3.x(), p3.y(), p3.z());
                consumer.addVertex(last, p1.x(), p1.y(), p1.z());
                consumer.addVertex(last, p2.x(), p2.y(), p2.z());
                consumer.addVertex(last, p2.x(), p2.y(), p2.z());
            }
        }
        ((MultiBufferSource.BufferSource)source).endBatch(DataNEssenceRenderTypes.WARPING_POINT);
        stack.popPose();
    }

    public static double getFractionalLerp(int current, int max) {
        return (double)current / (double)max;
    }

    public static double getYLerp(double lerp, double dY) {
        return Math.pow(lerp, Math.log(Math.abs(dY) + 3.0));
    }

    public static void renderLine(VertexConsumer consumer, PoseStack stack, Vec3 pointA, Vec3 pointB, Color color) {
        ClientRenderingUtil.renderLine(consumer, stack, pointA, pointB, color, 0.3);
    }

    public static void renderLine(VertexConsumer consumer, PoseStack stack, Vec3 pointA, Vec3 pointB, Function<Integer, Color> color) {
        ClientRenderingUtil.renderLine(consumer, stack, pointA, pointB, color, 0.3);
    }

    public static void renderLine(VertexConsumer consumer, PoseStack stack, Vec3 pointA, Vec3 pointB, Color color, double sag) {
        ClientRenderingUtil.renderLine(consumer, stack, pointA, pointB, (Integer seg) -> color, sag);
    }

    public static void renderLine(VertexConsumer consumer, PoseStack stack, Vec3 pointA, Vec3 pointB, Function<Integer, Color> color, double sag) {
        int segmentCount = 32;
        ArrayList<Vec3> segments = new ArrayList<Vec3>();
        boolean reversed = pointA.y < pointB.y;
        Vec3 sagOrigin = reversed ? pointA : pointB;
        Vec3 sagTarget = reversed ? pointB : pointA;
        Vec3 diff = sagTarget.subtract(sagOrigin);
        for (int i = 0; i < segmentCount; ++i) {
            double startLerp = ClientRenderingUtil.getFractionalLerp(i, segmentCount - 1);
            double startYLerp = ClientRenderingUtil.getYLerp(startLerp, diff.y);
            double sagFactor = sag * (1.0 - 4.0 * Math.pow(startLerp - 0.5, 2.0));
            double y = diff.y != 0.0 ? (startYLerp - sagFactor) * diff.y : -sagFactor;
            segments.add(new Vec3(startLerp * diff.x, y, startLerp * diff.z).add(sagOrigin));
        }
        if (!segments.isEmpty()) {
            Vec3 currentPos = (Vec3)segments.get(0);
            for (int i = 1; i < segments.size(); ++i) {
                Color segColor = color.apply(reversed ? segments.size() - i : i);
                Vec3 targetPos = (Vec3)segments.get(i);
                Vec3 normal = currentPos.subtract(targetPos).normalize();
                consumer.addVertex(stack.last(), (float)currentPos.x, (float)currentPos.y, (float)currentPos.z).setColor(segColor.getRGB()).setNormal(stack.last(), (float)normal.x, (float)normal.y, (float)normal.z);
                currentPos = targetPos;
                consumer.addVertex(stack.last(), (float)currentPos.x, (float)currentPos.y, (float)currentPos.z).setColor(segColor.getRGB()).setNormal(stack.last(), (float)normal.x, (float)normal.y, (float)normal.z);
            }
        }
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.cos((float)u) * Mth.sin((float)v) * r, Mth.cos((float)v) * r, Mth.sin((float)u) * Mth.sin((float)v) * r);
    }
}

