/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import com.cmdpro.datanessence.screen.EnticingLureMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EnticingLureBlockEntity
extends BlockEntity
implements MenuProvider {
    private final ItemStackHandler itemHandler = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            EnticingLureBlockEntity.this.setChanged();
        }
    };
    private final CombinedInvWrapper combinedInvWrapper = new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemHandler});

    public IItemHandler getItemHandler() {
        return this.itemHandler;
    }

    public CombinedInvWrapper getCombinedInvWrapper() {
        return this.combinedInvWrapper;
    }

    public EnticingLureBlockEntity(BlockPos pos, BlockState state) {
        super(BlockEntityRegistry.ENTICING_LURE.get(), pos, state);
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        tag.put("inventory", (Tag)this.itemHandler.serializeNBT(pRegistries));
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        this.itemHandler.deserializeNBT(pRegistries, nbt.getCompound("inventory"));
    }

    public SimpleContainer getInv() {
        SimpleContainer inventory = new SimpleContainer(this.itemHandler.getSlots());
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            inventory.setItem(i, this.itemHandler.getStackInSlot(i));
        }
        return inventory;
    }

    public void drops() {
        SimpleContainer inventory = this.getInv();
        Containers.dropContents((Level)this.level, (BlockPos)this.worldPosition, (Container)inventory);
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, EnticingLureBlockEntity pBlockEntity) {
        if (!pLevel.isClientSide) {
            ItemStack stack = pBlockEntity.itemHandler.getStackInSlot(0).copy();
            for (Animal i : pLevel.getEntitiesOfClass(Animal.class, AABB.ofSize((Vec3)pPos.getCenter(), (double)10.0, (double)10.0, (double)10.0))) {
                if (!i.isFood(pBlockEntity.itemHandler.getStackInSlot(0)) || !(i.position().distanceTo(pPos.getCenter()) > 3.0)) continue;
                Vec3 pos = pPos.getCenter().add(i.position().subtract(pPos.getCenter()).normalize().multiply(2.5, 2.5, 2.5));
                if (i.getNavigation().getPath() != null && !(i.getNavigation().getPath().getTarget().distToCenterSqr((Position)pos) > 0.25)) continue;
                i.getNavigation().stop();
                i.getNavigation().moveTo(pos.x, pos.y, pos.z, 1.0);
            }
        }
    }

    public Component getDisplayName() {
        return Component.empty();
    }

    @Nullable
    public AbstractContainerMenu createMenu(int pContainerId, Inventory pInventory, Player pPlayer) {
        return new EnticingLureMenu(pContainerId, pInventory, this);
    }
}

