/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.auxiliary;

import com.cmdpro.databank.rendering.ColorUtil;
import com.cmdpro.datanessence.api.DataNEssenceRegistries;
import com.cmdpro.datanessence.api.essence.EssenceBlockEntity;
import com.cmdpro.datanessence.api.essence.EssenceStorage;
import com.cmdpro.datanessence.api.essence.EssenceType;
import com.cmdpro.datanessence.api.item.EssenceShard;
import com.cmdpro.datanessence.block.auxiliary.EssenceReader;
import com.cmdpro.datanessence.registry.BlockEntityRegistry;
import java.awt.Color;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.NotNull;

public class EssenceReaderBlockEntity
extends BlockEntity {
    public Set<EssenceType> selectedEssences;
    public EssenceShard selectedShard;
    private int signal;

    public EssenceReaderBlockEntity(BlockPos pPos, BlockState pBlockState) {
        super(BlockEntityRegistry.ESSENCE_READER.get(), pPos, pBlockState);
    }

    public boolean selectFromItem(ItemStack stack) {
        if (stack == null) {
            this.selectedEssences = null;
            this.selectedShard = null;
            this.updateBlock();
            return true;
        }
        Item item = stack.getItem();
        if (item instanceof EssenceShard) {
            EssenceShard shard = (EssenceShard)item;
            this.selectedEssences = shard.essence.keySet().stream().map(Supplier::get).collect(Collectors.toSet());
            this.selectedShard = shard;
            this.updateBlock();
            return true;
        }
        return false;
    }

    public boolean isItemValid(ItemStack stack) {
        Item item = stack.getItem();
        if (item instanceof EssenceShard) {
            EssenceShard shard = (EssenceShard)item;
            return true;
        }
        return false;
    }

    public Color getColor() {
        if (this.selectedEssences == null || this.selectedEssences.isEmpty()) {
            return new Color(4272727);
        }
        Color color = new Color(((EssenceType)this.selectedEssences.stream().findFirst().orElseThrow()).color);
        for (EssenceType i : this.selectedEssences) {
            Color newColor = new Color(i.color);
            if (newColor.equals(color)) continue;
            color = ColorUtil.blendColors((Color)color, (Color)newColor, (float)0.5f);
        }
        return color;
    }

    public Set<EssenceType> getTypesToCheck(EssenceStorage storage) {
        if (this.selectedEssences != null) {
            return this.selectedEssences;
        }
        return storage.getSupportedEssenceTypes();
    }

    protected void updateBlock() {
        BlockState blockState = this.level.getBlockState(this.getBlockPos());
        this.level.sendBlockUpdated(this.getBlockPos(), blockState, blockState, 3);
        this.setChanged();
    }

    private void updateNeighbors() {
        if (!this.hasLevel()) {
            return;
        }
        this.getLevel().updateNeighborsAt(this.getBlockPos(), this.getBlockState().getBlock());
    }

    public void tick(Level pLevel, BlockPos pPos, BlockState pState) {
        if (!pLevel.isClientSide) {
            int newSignal = this.updateSignal();
            boolean update = newSignal != this.signal;
            this.signal = newSignal;
            if (update) {
                this.updateNeighbors();
            }
        }
    }

    public int getSignal() {
        return this.signal;
    }

    private int updateSignal() {
        Direction detectDir = ((Direction)this.getBlockState().getValue((Property)EssenceReader.FACING)).getOpposite();
        BlockPos detectingPos = this.getBlockPos().relative(detectDir);
        BlockEntity blockEntity = this.level.getBlockEntity(detectingPos);
        if (blockEntity instanceof EssenceBlockEntity) {
            EssenceBlockEntity essenceEntity = (EssenceBlockEntity)blockEntity;
            EssenceStorage storage = essenceEntity.getStorage();
            float essence = 0.0f;
            float maxEssence = 0.0f;
            Set<EssenceType> typesToCheck = this.getTypesToCheck(storage);
            for (EssenceType i : typesToCheck) {
                essence += storage.getEssence(i);
                maxEssence += storage.getMaxEssence();
            }
            float amount = essence / maxEssence;
            return (int)Math.floor(amount * 15.0f);
        }
        return 0;
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void onDataPacket(Connection connection, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider pRegistries) {
        CompoundTag tag = pkt.getTag();
        this.handleData(tag);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.handleData(tag);
    }

    public void handleData(CompoundTag tag) {
        if (tag.contains("selected")) {
            ListTag selected = tag.getList("selected", 8);
            ArrayList<EssenceType> types = new ArrayList<EssenceType>();
            for (Tag i : selected) {
                StringTag str = (StringTag)i;
                types.add((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(ResourceLocation.tryParse((String)str.getAsString())));
            }
            this.selectedEssences = new HashSet<EssenceType>(types);
        } else {
            this.selectedEssences = null;
        }
        this.updateBlock();
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider pRegistries) {
        CompoundTag tag = new CompoundTag();
        if (this.selectedEssences != null) {
            ListTag list = new ListTag();
            for (EssenceType i : this.selectedEssences) {
                ResourceLocation location = DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i);
                if (location == null) continue;
                list.add((Object)StringTag.valueOf((String)location.toString()));
            }
            tag.put("selected", (Tag)list);
        }
        return tag;
    }

    protected void saveAdditional(@NotNull CompoundTag tag, HolderLookup.Provider pRegistries) {
        if (this.selectedEssences != null) {
            ListTag list = new ListTag();
            for (EssenceType i : this.selectedEssences) {
                ResourceLocation location = DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.getKey((Object)i);
                if (location == null) continue;
                list.add((Object)StringTag.valueOf((String)location.toString()));
            }
            tag.put("selected", (Tag)list);
        }
        super.saveAdditional(tag, pRegistries);
    }

    public void loadAdditional(CompoundTag nbt, HolderLookup.Provider pRegistries) {
        super.loadAdditional(nbt, pRegistries);
        if (nbt.contains("selected")) {
            ListTag selected = nbt.getList("selected", 8);
            ArrayList<EssenceType> types = new ArrayList<EssenceType>();
            for (Tag i : selected) {
                StringTag str = (StringTag)i;
                types.add((EssenceType)DataNEssenceRegistries.ESSENCE_TYPE_REGISTRY.get(ResourceLocation.tryParse((String)str.getAsString())));
            }
            this.selectedEssences = new HashSet<EssenceType>(types);
        } else {
            this.selectedEssences = null;
        }
    }
}

