/*
 * Decompiled with CFR 0.152.
 */
package com.cmdpro.datanessence.block.decoration;

import com.cmdpro.datanessence.block.decoration.FlareLightBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class FlareLight
extends Block
implements EntityBlock {
    private static final VoxelShape SHAPE = Block.box((double)4.0, (double)4.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0);

    public FlareLight(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.INVISIBLE;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new FlareLightBlockEntity(pos, state);
    }

    public boolean isRandomlyTicking(BlockState state) {
        return false;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level pLevel, BlockState pState, BlockEntityType<T> pBlockEntityType) {
        return (lvl, pos, st, blockEntity) -> {
            if (blockEntity instanceof FlareLightBlockEntity) {
                FlareLightBlockEntity ent = (FlareLightBlockEntity)blockEntity;
                FlareLightBlockEntity.tick(lvl, pos, st, ent);
            }
        };
    }
}

